/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package package01;

import java.awt.Color;
import static java.lang.Math.floor;
import javax.swing.JOptionPane;

/**
 *
 * @author kgto
 */
public class TestColor02 extends javax.swing.JFrame {
    int jRBselect;
    int valuePercent;
    int valueMin, valueMax;
    
    int limitMin, limitMax;
    int limitRange = 0;
    int limitCenter = 0;
    
    int gradationHigh1, gradationHigh2;
    int gradationLow1, gradationLow2;
    
    /**
     * Creates new form Test01
     */
    public TestColor02() {
        initComponents();
        
        set_jRBtn(1);  // 指値範囲
        jRBtn_select();
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        buttonGroup1 = new javax.swing.ButtonGroup();
        jSlider1 = new javax.swing.JSlider();
        jTextField1 = new javax.swing.JTextField();
        jTextred = new javax.swing.JTextField();
        jTextgreen = new javax.swing.JTextField();
        jTextblue = new javax.swing.JTextField();
        jTextField2 = new javax.swing.JTextField();
        jPanelSlider = new javax.swing.JPanel();
        jTextSliderMin = new javax.swing.JTextField();
        jTextSliderMax = new javax.swing.JTextField();
        jBtnSliderSet = new javax.swing.JButton();
        jPanelLimit = new javax.swing.JPanel();
        jLabelLimitMax = new javax.swing.JLabel();
        jLabelLimitmin = new javax.swing.JLabel();
        jTextLimitMax = new javax.swing.JTextField();
        jTextLimitMin = new javax.swing.JTextField();
        jPanel1 = new javax.swing.JPanel();
        jTextPercent = new javax.swing.JTextField();
        jTextValueMin = new javax.swing.JTextField();
        jTextValueMax = new javax.swing.JTextField();
        jRBtn_LimitRange = new javax.swing.JRadioButton();
        jRBtn_Percent = new javax.swing.JRadioButton();
        jRBtn_ValueMinMax = new javax.swing.JRadioButton();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);

        jSlider1.setMajorTickSpacing(10);
        jSlider1.setOrientation(javax.swing.JSlider.VERTICAL);
        jSlider1.setPaintTicks(true);
        jSlider1.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                jSlider1StateChanged(evt);
            }
        });

        jTextField1.setToolTipText("スライダー位置");

        jTextred.setHorizontalAlignment(javax.swing.JTextField.CENTER);
        jTextred.setText("RED");

        jTextgreen.setHorizontalAlignment(javax.swing.JTextField.CENTER);
        jTextgreen.setText("GREEN");

        jTextblue.setHorizontalAlignment(javax.swing.JTextField.CENTER);
        jTextblue.setText("BLUE");

        jTextField2.setToolTipText("グラデーションパーセント");

        jPanelSlider.setBorder(javax.swing.BorderFactory.createTitledBorder("スライダー範囲"));

        jTextSliderMin.setHorizontalAlignment(javax.swing.JTextField.RIGHT);
        jTextSliderMin.setText("0");

        jTextSliderMax.setHorizontalAlignment(javax.swing.JTextField.RIGHT);
        jTextSliderMax.setText("100");

        jBtnSliderSet.setText("set");
        jBtnSliderSet.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jBtnSliderSetActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout jPanelSliderLayout = new javax.swing.GroupLayout(jPanelSlider);
        jPanelSlider.setLayout(jPanelSliderLayout);
        jPanelSliderLayout.setHorizontalGroup(
            jPanelSliderLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanelSliderLayout.createSequentialGroup()
                .addComponent(jTextSliderMin, javax.swing.GroupLayout.PREFERRED_SIZE, 38, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jTextSliderMax, javax.swing.GroupLayout.PREFERRED_SIZE, 38, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jBtnSliderSet))
        );
        jPanelSliderLayout.setVerticalGroup(
            jPanelSliderLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanelSliderLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                .addComponent(jTextSliderMin, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addComponent(jTextSliderMax, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addComponent(jBtnSliderSet))
        );

        jTextSliderMin.getAccessibleContext().setAccessibleName("");
        jTextSliderMin.getAccessibleContext().setAccessibleDescription("");

        jPanelLimit.setBorder(javax.swing.BorderFactory.createTitledBorder("指値"));
        jPanelLimit.setName(""); // NOI18N

        jLabelLimitMax.setText("高");

        jLabelLimitmin.setText("低");

        jTextLimitMax.setHorizontalAlignment(javax.swing.JTextField.RIGHT);
        jTextLimitMax.setText("80");

        jTextLimitMin.setHorizontalAlignment(javax.swing.JTextField.RIGHT);
        jTextLimitMin.setText("20");

        javax.swing.GroupLayout jPanelLimitLayout = new javax.swing.GroupLayout(jPanelLimit);
        jPanelLimit.setLayout(jPanelLimitLayout);
        jPanelLimitLayout.setHorizontalGroup(
            jPanelLimitLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanelLimitLayout.createSequentialGroup()
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addGroup(jPanelLimitLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanelLimitLayout.createSequentialGroup()
                        .addComponent(jLabelLimitMax)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jTextLimitMax, javax.swing.GroupLayout.PREFERRED_SIZE, 38, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addGroup(jPanelLimitLayout.createSequentialGroup()
                        .addComponent(jLabelLimitmin)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jTextLimitMin, javax.swing.GroupLayout.PREFERRED_SIZE, 38, javax.swing.GroupLayout.PREFERRED_SIZE)))
                .addContainerGap())
        );
        jPanelLimitLayout.setVerticalGroup(
            jPanelLimitLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanelLimitLayout.createSequentialGroup()
                .addGroup(jPanelLimitLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabelLimitMax)
                    .addComponent(jTextLimitMax, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanelLimitLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabelLimitmin)
                    .addComponent(jTextLimitMin, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))
        );

        jTextPercent.setHorizontalAlignment(javax.swing.JTextField.RIGHT);
        jTextPercent.setText("50");

        jTextValueMin.setHorizontalAlignment(javax.swing.JTextField.RIGHT);
        jTextValueMin.setText("30");

        jTextValueMax.setHorizontalAlignment(javax.swing.JTextField.RIGHT);
        jTextValueMax.setText("90");

        buttonGroup1.add(jRBtn_LimitRange);
        jRBtn_LimitRange.setText("指値範囲内");
        jRBtn_LimitRange.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                jRBtn_LimitRangeMouseClicked(evt);
            }
        });

        buttonGroup1.add(jRBtn_Percent);
        jRBtn_Percent.setText("パーセント指定");
        jRBtn_Percent.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                jRBtn_PercentMouseClicked(evt);
            }
        });

        buttonGroup1.add(jRBtn_ValueMinMax);
        jRBtn_ValueMinMax.setText("値指定");
        jRBtn_ValueMinMax.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                jRBtn_ValueMinMaxMouseClicked(evt);
            }
        });

        javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel1Layout.createSequentialGroup()
                        .addComponent(jRBtn_Percent)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jTextPercent, javax.swing.GroupLayout.PREFERRED_SIZE, 38, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addGroup(jPanel1Layout.createSequentialGroup()
                        .addComponent(jRBtn_ValueMinMax)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jTextValueMax, javax.swing.GroupLayout.PREFERRED_SIZE, 38, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jTextValueMin, javax.swing.GroupLayout.PREFERRED_SIZE, 38, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addComponent(jRBtn_LimitRange))
                .addContainerGap(14, Short.MAX_VALUE))
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jRBtn_LimitRange)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jRBtn_Percent)
                    .addComponent(jTextPercent, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jRBtn_ValueMinMax)
                    .addComponent(jTextValueMax, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jTextValueMin, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addComponent(jSlider1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jPanelSlider, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(jTextred, javax.swing.GroupLayout.PREFERRED_SIZE, 83, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jTextgreen, javax.swing.GroupLayout.PREFERRED_SIZE, 83, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jTextblue, javax.swing.GroupLayout.PREFERRED_SIZE, 83, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addGroup(layout.createSequentialGroup()
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jPanelLimit, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addGroup(layout.createSequentialGroup()
                                .addComponent(jTextField1, javax.swing.GroupLayout.PREFERRED_SIZE, 38, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(jTextField2, javax.swing.GroupLayout.PREFERRED_SIZE, 38, javax.swing.GroupLayout.PREFERRED_SIZE)))
                        .addGap(18, 18, 18)
                        .addComponent(jPanel1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))
                .addGap(24, 24, 24))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                    .addComponent(jSlider1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(jPanelSlider, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addGroup(layout.createSequentialGroup()
                                .addComponent(jPanelLimit, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                                    .addComponent(jTextField1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                    .addComponent(jTextField2, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))
                            .addComponent(jPanel1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(jTextred, javax.swing.GroupLayout.PREFERRED_SIZE, 42, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(jTextgreen, javax.swing.GroupLayout.PREFERRED_SIZE, 42, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(jTextblue, javax.swing.GroupLayout.PREFERRED_SIZE, 42, javax.swing.GroupLayout.PREFERRED_SIZE))))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void jSlider1StateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_jSlider1StateChanged
        int value;
        Color color;

        int sliderValue = jSlider1.getValue();
        jTextField1.setText(String.valueOf(sliderValue));
        
        if(!getLimit_range()) {
            jTextField2.setBackground(Color.WHITE);
            
            jTextred.setBackground(Color.WHITE);
            jTextgreen.setBackground(Color.WHITE);
            jTextblue.setBackground(Color.WHITE);
            return;
        }
        
        switch(jRBselect) {
            case 1 : limitRange();  break;
            case 2 : percent();     break;
            case 3 : valueMinMax(); break;
        }
        
        if(sliderValue <= gradationLow1) {
            value = gradationMin(gradationLow1, gradationLow2);
            color = Color.GREEN;
        } else {
            value = gradationMax(gradationHigh1, gradationHigh2);
            color = Color.RED;
        }
        jTextField2.setText(String.valueOf(value));
        jTextField2.setBackground(toneColor(color, value));
        
        if(jRBselect > 0) {
            jTextred.setBackground(toneColor(Color.RED, value));
            jTextgreen.setBackground(toneColor(Color.GREEN, value));
            jTextblue.setBackground(toneColor(Color.BLUE, value));
        }
        
    }//GEN-LAST:event_jSlider1StateChanged

    private void jRBtn_LimitRangeMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jRBtn_LimitRangeMouseClicked
        jRBtn_select();
    }//GEN-LAST:event_jRBtn_LimitRangeMouseClicked

    private void jRBtn_PercentMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jRBtn_PercentMouseClicked
        jRBtn_select();
    }//GEN-LAST:event_jRBtn_PercentMouseClicked

    private void jRBtn_ValueMinMaxMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jRBtn_ValueMinMaxMouseClicked
        jRBtn_select();
    }//GEN-LAST:event_jRBtn_ValueMinMaxMouseClicked

    private void jBtnSliderSetActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jBtnSliderSetActionPerformed
        int sliderMin = Integer.parseInt(jTextSliderMin.getText());
        int sliderMax = Integer.parseInt(jTextSliderMax.getText());
        
        // 入力チェック
        if(sliderMin >= sliderMax) {
            JOptionPane.showMessageDialog(null, "スライダー範囲設定エラー");
            return;
        }
        jSlider1.setMinimum(sliderMin);
        jSlider1.setMaximum(sliderMax);
    }//GEN-LAST:event_jBtnSliderSetActionPerformed

    /**
     * 指値範囲取得.
     * @return 指値未入力、入力エラー時、false
     */
    boolean getLimit_range() {
        // 入力チェック
        if(jTextLimitMin.getText().isEmpty() || jTextLimitMax.getText().isEmpty()) {
            return false;
        }
        limitMin = Integer.parseInt(jTextLimitMin.getText());
        limitMax = Integer.parseInt(jTextLimitMax.getText());
        if(limitMin >= limitMax) {
            JOptionPane.showMessageDialog(null, "指値範囲設定エラー");
            return false;
        }
        limitRange  = limitMax - limitMin;
        limitCenter = limitRange / 2;
        
        return true;
    }
    
    /**
     * ラジオボタン選択.
     */
    private void jRBtn_select() {
        int new_jRBselect = 0;
        
        if(jRBtn_LimitRange.isSelected())   new_jRBselect = 1;
        if(jRBtn_Percent.isSelected())      new_jRBselect = 2;
        if(jRBtn_ValueMinMax.isSelected())  new_jRBselect = 3;
        
        // 入力チェック
        if(new_jRBselect == 2) {
            valuePercent = Integer.parseInt(jTextPercent.getText());
        }
        if(new_jRBselect == 3) {
            valueMin = Integer.parseInt(jTextValueMin.getText());
            valueMax = Integer.parseInt(jTextValueMax.getText());
            if(!getLimit_range()) {
                return;
            }
            
            if(valueMin < limitMin || valueMax > limitMax) {
                JOptionPane.showMessageDialog(null, "条件値設定エラー");
                set_jRBtn(jRBselect);
                return;
            }
            
            if(valueMin >= valueMax) {
                JOptionPane.showMessageDialog(null, "条件値設定エラー");
                set_jRBtn(jRBselect);
                return;
            }
        }
        jRBselect = new_jRBselect;
    }
    
    private void set_jRBtn(int select) {
        switch(select) {
            case 1 : jRBtn_LimitRange.setSelected(true);  break;
            case 2 : jRBtn_Percent.setSelected(true);     break;
            case 3 : jRBtn_ValueMinMax.setSelected(true); break;
        }
    }
    
    /**
     * グラデーション設定（指値範囲）.
     */
    void limitRange() {
        gradationHigh2 = limitMax;
        gradationHigh1 = limitMin + limitCenter;
        
        gradationLow1  = limitMin + limitCenter;
        gradationLow2  = limitMin;
    }
    
    /**
     * グラデーション設定（パーセント指定）.
     */
    void percent() {
        int rate = limitRange * valuePercent / 100;
        
        gradationHigh2 = limitMax;
        gradationHigh1 = limitMax - rate;
        
        gradationLow1  = limitMin + rate;
        gradationLow2  = limitMin;
    }
    
    /**
     * グラデーション設定（開始・終了値設定）.
     */
    void valueMinMax() {
        gradationHigh2 = limitMax;
        gradationHigh1 = valueMax;
        
        gradationLow1  = valueMin;
        gradationLow2  = limitMin;
    }
    
    /**
     * 上方グラデーション値設定.
     * 数値が「大きく」なるほど、グラデーション値を大きくする。
     * @param min 開始値(グラデーション値 ０％)
     * @param max 終了値(グラデーション値 １００％)
     * @return グラデーション値
     */
    int gradationMax(int min, int max) {
        int sliderValue = jSlider1.getValue();
        
        if(sliderValue < min) {
            return 0;
        }
        if(sliderValue > max) {
            return 100;
        }
        float range = max - min;
        float rangePoint = sliderValue - min;
        int gradationPercent = (int)floor(rangePoint / range * 100.0);
        
        return gradationPercent;
    }
    
    /**
     * 下方グラデーション値設定.
     * 数値が「小さく」なるほど、グラデーション値を大きくする。
     * @param min 開始値(グラデーション値 ０％)
     * @param max 終了値(グラデーション値 １００％)
     * @return グラデーション値
     */
    int gradationMin(int min, int max) {
        int sliderValue = jSlider1.getValue();
        
        if(sliderValue > min) {
            return 0;
        }
        if(sliderValue < max) {
            return 100;
        }
        float range = min - max;
        float rangePoint = min - sliderValue;
        int gradationPercent = (int)floor(rangePoint / range * 100.0);
        
        return gradationPercent;
    }

    /**
     * カラー設定.
     * @param strongColor  強調色
     * @param value グラデーション値
     * @return カラー属性
     */
    Color toneColor(Color strongColor, int value) {
        final int MAXRGB = 255;
        
        int toneR = MAXRGB;
        int toneG = MAXRGB;
        int toneB = MAXRGB;
        
        if(value < 0)   value = 0;
        if(value > 100) value = 100;
        
        int percentRGB     = MAXRGB * value / 100;
        int subtractionRGB = MAXRGB - percentRGB;
        if(Color.RED.equals(strongColor)) {
            toneG = subtractionRGB;
            toneB = subtractionRGB;
        }
        if(Color.GREEN.equals(strongColor)) {
            toneR = subtractionRGB;
            toneB = subtractionRGB;
        }
        if(Color.BLUE.equals(strongColor)) {
            toneR = subtractionRGB;
            toneG = subtractionRGB;
        }
        return new Color(toneR, toneG, toneB);
    }
    
    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        /* Set the Nimbus look and feel */
        //<editor-fold defaultstate="collapsed" desc=" Look and feel setting code (optional) ">
        /* If Nimbus (introduced in Java SE 6) is not available, stay with the default look and feel.
         * For details see http://download.oracle.com/javase/tutorial/uiswing/lookandfeel/plaf.html 
         */
        try {
            for (javax.swing.UIManager.LookAndFeelInfo info : javax.swing.UIManager.getInstalledLookAndFeels()) {
                if ("Nimbus".equals(info.getName())) {
                    javax.swing.UIManager.setLookAndFeel(info.getClassName());
                    break;
                }
            }
        } catch (ClassNotFoundException ex) {
            java.util.logging.Logger.getLogger(TestColor02.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (InstantiationException ex) {
            java.util.logging.Logger.getLogger(TestColor02.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (IllegalAccessException ex) {
            java.util.logging.Logger.getLogger(TestColor02.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (javax.swing.UnsupportedLookAndFeelException ex) {
            java.util.logging.Logger.getLogger(TestColor02.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        }
        //</editor-fold>
        //</editor-fold>
        //</editor-fold>
        //</editor-fold>

        /* Create and display the form */
        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                new TestColor02().setVisible(true);
            }
        });
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.ButtonGroup buttonGroup1;
    private javax.swing.JButton jBtnSliderSet;
    private javax.swing.JLabel jLabelLimitMax;
    private javax.swing.JLabel jLabelLimitmin;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanelLimit;
    private javax.swing.JPanel jPanelSlider;
    private javax.swing.JRadioButton jRBtn_LimitRange;
    private javax.swing.JRadioButton jRBtn_Percent;
    private javax.swing.JRadioButton jRBtn_ValueMinMax;
    private javax.swing.JSlider jSlider1;
    private javax.swing.JTextField jTextField1;
    private javax.swing.JTextField jTextField2;
    private javax.swing.JTextField jTextLimitMax;
    private javax.swing.JTextField jTextLimitMin;
    private javax.swing.JTextField jTextPercent;
    private javax.swing.JTextField jTextSliderMax;
    private javax.swing.JTextField jTextSliderMin;
    private javax.swing.JTextField jTextValueMax;
    private javax.swing.JTextField jTextValueMin;
    private javax.swing.JTextField jTextblue;
    private javax.swing.JTextField jTextgreen;
    private javax.swing.JTextField jTextred;
    // End of variables declaration//GEN-END:variables
}
