/*
 * Copyright (C) 2014 kgto.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301  USA
 */
/*
 * $Id: HtmlSearch.java 114 2015-01-09 00:58:38Z tuna_p $
 */
package webScraping.utility;

import webScraping.core.HtmlParser;
import webScraping.core.SearchData;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.DefaultTableModel;

/**
 * HTMLページ上の特定の項目を検索し、その項目内容の値を取得する.
 * @author kgto
 */
public class HtmlSearch extends javax.swing.JFrame {
    private final SearchDataRW sio = new SearchDataRW();

    SearchDataTableModel sdatatblmodel;
    
    /**
     * Creates new form Frame1
     */
    public HtmlSearch() {
        sdatatblmodel = new SearchDataTableModel();
        
        initComponents();
        
        // カレントディレクトリ取得
        String dir = System.getProperty("user.dir");
        File file = new java.io.File(dir + "\\data");
        jFileChooser1.setCurrentDirectory(file);
        
        FileFilter filter1 = new FileNameExtensionFilter("XMLファイル", "xml");
        FileFilter filter2 = new FileNameExtensionFilter("TEXTファイル", "txt");
        jFileChooser1.addChoosableFileFilter(filter1);
        jFileChooser1.addChoosableFileFilter(filter2);
        jFileChooser1.setFileFilter(filter1);
        
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jFileChooser1 = new javax.swing.JFileChooser();
        jRadioButton1 = new javax.swing.JRadioButton();
        jLabel1 = new javax.swing.JLabel();
        jTxtUrl = new javax.swing.JTextField();
        jBtnSearch = new javax.swing.JButton();
        jTabbedPane1 = new javax.swing.JTabbedPane();
        jPanelTab1 = new javax.swing.JPanel();
        jScrollPane1 = new javax.swing.JScrollPane();
        jTable1 = new javax.swing.JTable();
        jBtnRowIns = new javax.swing.JButton();
        jBtnRowDel = new javax.swing.JButton();
        jBtnRowCpy = new javax.swing.JButton();
        jPanelTab2 = new javax.swing.JPanel();
        jScrollPaneLabel = new javax.swing.JScrollPane();
        jTxtLabel = new javax.swing.JTextArea();
        jScrollPane404msg = new javax.swing.JScrollPane();
        jTxt404msg = new javax.swing.JTextArea();
        jPanelRtn = new javax.swing.JPanel();
        jScrollPaneRtn = new javax.swing.JScrollPane();
        jTxtRtn = new javax.swing.JTextArea();
        jMenuBar1 = new javax.swing.JMenuBar();
        jMenu1 = new javax.swing.JMenu();
        jMenuLoad = new javax.swing.JMenuItem();
        jMenuSave = new javax.swing.JMenuItem();
        jMenu3 = new javax.swing.JMenu();
        jMenuItem1 = new javax.swing.JMenuItem();
        jMenu2 = new javax.swing.JMenu();

        jFileChooser1.setCurrentDirectory(null);
        jFileChooser1.setDialogTitle("");

        jRadioButton1.setText("jRadioButton1");

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        setTitle("タグ検索");

        jLabel1.setText(" URL:");

        jBtnSearch.setText("検索");
        jBtnSearch.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jBtnSearchActionPerformed(evt);
            }
        });

        jPanelTab1.setBorder(javax.swing.BorderFactory.createTitledBorder("検索情報"));

        jTable1.setModel(sdatatblmodel);
        jTable1.setSelectionMode(javax.swing.ListSelectionModel.SINGLE_SELECTION);
        jTable1.getTableHeader().setReorderingAllowed(false);
        jScrollPane1.setViewportView(jTable1);

        jBtnRowIns.setText("行挿入");
        jBtnRowIns.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jBtnRowInsActionPerformed(evt);
            }
        });

        jBtnRowDel.setText("行削除");
        jBtnRowDel.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jBtnRowDelActionPerformed(evt);
            }
        });

        jBtnRowCpy.setText("行コピー");
        jBtnRowCpy.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jBtnRowCpyActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout jPanelTab1Layout = new javax.swing.GroupLayout(jPanelTab1);
        jPanelTab1.setLayout(jPanelTab1Layout);
        jPanelTab1Layout.setHorizontalGroup(
            jPanelTab1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanelTab1Layout.createSequentialGroup()
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addComponent(jBtnRowCpy)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jBtnRowDel)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jBtnRowIns))
            .addComponent(jScrollPane1, javax.swing.GroupLayout.PREFERRED_SIZE, 0, Short.MAX_VALUE)
        );
        jPanelTab1Layout.setVerticalGroup(
            jPanelTab1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanelTab1Layout.createSequentialGroup()
                .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 173, Short.MAX_VALUE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanelTab1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jBtnRowDel)
                    .addComponent(jBtnRowIns)
                    .addComponent(jBtnRowCpy)))
        );

        jTabbedPane1.addTab("キー設定", jPanelTab1);

        jPanelTab2.setBorder(javax.swing.BorderFactory.createTitledBorder("メッセージ"));

        jScrollPaneLabel.setHorizontalScrollBarPolicy(javax.swing.ScrollPaneConstants.HORIZONTAL_SCROLLBAR_NEVER);
        jScrollPaneLabel.setVerticalScrollBarPolicy(javax.swing.ScrollPaneConstants.VERTICAL_SCROLLBAR_NEVER);

        jTxtLabel.setEditable(false);
        jTxtLabel.setBackground(java.awt.Color.lightGray);
        jTxtLabel.setColumns(20);
        jTxtLabel.setFont(new java.awt.Font("MS UI Gothic", 0, 12)); // NOI18N
        jTxtLabel.setLineWrap(true);
        jTxtLabel.setRows(2);
        jTxtLabel.setText("取得ページに以下のメッセージが含まれていた場合、対象データが取得出来なかったと通知します。");
        jTxtLabel.setAutoscrolls(false);
        jTxtLabel.setBorder(null);
        jTxtLabel.setCursor(new java.awt.Cursor(java.awt.Cursor.DEFAULT_CURSOR));
        jTxtLabel.setFocusable(false);
        jTxtLabel.setHighlighter(null);
        jTxtLabel.setKeymap(null);
        jTxtLabel.setOpaque(false);
        jTxtLabel.setRequestFocusEnabled(false);
        jTxtLabel.setVerifyInputWhenFocusTarget(false);
        jScrollPaneLabel.setViewportView(jTxtLabel);

        jTxt404msg.setColumns(20);
        jTxt404msg.setRows(3);
        jTxt404msg.setText("一致する銘柄は見つかりませんでした\n");
        jScrollPane404msg.setViewportView(jTxt404msg);

        javax.swing.GroupLayout jPanelTab2Layout = new javax.swing.GroupLayout(jPanelTab2);
        jPanelTab2.setLayout(jPanelTab2Layout);
        jPanelTab2Layout.setHorizontalGroup(
            jPanelTab2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jScrollPane404msg)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanelTab2Layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jScrollPaneLabel, javax.swing.GroupLayout.DEFAULT_SIZE, 359, Short.MAX_VALUE)
                .addContainerGap())
        );
        jPanelTab2Layout.setVerticalGroup(
            jPanelTab2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanelTab2Layout.createSequentialGroup()
                .addComponent(jScrollPaneLabel, javax.swing.GroupLayout.PREFERRED_SIZE, 38, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(jScrollPane404msg))
        );

        jTabbedPane1.addTab("結果無し判定", jPanelTab2);

        jPanelRtn.setBorder(javax.swing.BorderFactory.createTitledBorder("検索結果"));

        jTxtRtn.setColumns(20);
        jTxtRtn.setRows(5);
        jScrollPaneRtn.setViewportView(jTxtRtn);

        javax.swing.GroupLayout jPanelRtnLayout = new javax.swing.GroupLayout(jPanelRtn);
        jPanelRtn.setLayout(jPanelRtnLayout);
        jPanelRtnLayout.setHorizontalGroup(
            jPanelRtnLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jScrollPaneRtn)
        );
        jPanelRtnLayout.setVerticalGroup(
            jPanelRtnLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jScrollPaneRtn, javax.swing.GroupLayout.DEFAULT_SIZE, 163, Short.MAX_VALUE)
        );

        jMenu1.setText("ファイル");

        jMenuLoad.setText("LOAD");
        jMenuLoad.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuLoadActionPerformed(evt);
            }
        });
        jMenu1.add(jMenuLoad);

        jMenuSave.setText("SAVE");
        jMenuSave.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuSaveActionPerformed(evt);
            }
        });
        jMenu1.add(jMenuSave);

        jMenuBar1.add(jMenu1);

        jMenu3.setText("ツール");

        jMenuItem1.setText("ブラウザで表示");
        jMenuItem1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItem1ActionPerformed(evt);
            }
        });
        jMenu3.add(jMenuItem1);

        jMenuBar1.add(jMenu3);

        jMenu2.setText("検索");
        jMenu2.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                jMenu2MouseClicked(evt);
            }
        });
        jMenuBar1.add(jMenu2);

        setJMenuBar(jMenuBar1);

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jPanelRtn, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
            .addGroup(layout.createSequentialGroup()
                .addComponent(jLabel1)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jTxtUrl)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jBtnSearch))
            .addComponent(jTabbedPane1)
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel1)
                    .addComponent(jTxtUrl, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jBtnSearch))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jTabbedPane1, javax.swing.GroupLayout.PREFERRED_SIZE, 250, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jPanelRtn, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addContainerGap())
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void jBtnRowInsActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jBtnRowInsActionPerformed
        int SelectedRow = jTable1.getSelectedRow();
        SearchData sdata = new SearchData();
        if(SelectedRow >= 0) {
            sdatatblmodel.insertRow(SelectedRow, sdata);
        } else {
            sdatatblmodel.addRow(sdata);
        }
    }//GEN-LAST:event_jBtnRowInsActionPerformed

    private void jBtnRowDelActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jBtnRowDelActionPerformed
        int SelectedRow = jTable1.getSelectedRow();
        if(!(SelectedRow < 0)) {
            sdatatblmodel.removeRow(SelectedRow);
        }
    }//GEN-LAST:event_jBtnRowDelActionPerformed

    private void jMenuLoadActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuLoadActionPerformed
        jFileChooser1.setDialogTitle("読込");
        int selected = jFileChooser1.showOpenDialog(this);
        if (selected == JFileChooser.APPROVE_OPTION) {
            File file = jFileChooser1.getSelectedFile();
            sio.load(file);
            jTxtUrl.setText(sio.geturl());
            sdatatblmodel.setRowCount(0);
            for(int i = 0; i < SearchData.size(); i++) {
                SearchData sdata = SearchData.get(i);
                sdatatblmodel.addRow(sdata);
            }
        }
    }//GEN-LAST:event_jMenuLoadActionPerformed

    private void jMenuSaveActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuSaveActionPerformed
        jFileChooser1.setDialogTitle("保存");
        int selected = jFileChooser1.showSaveDialog(this);
        if (selected == JFileChooser.APPROVE_OPTION) {
            File file = jFileChooser1.getSelectedFile();
            sio.seturl(jTxtUrl.getText());
            
            SearchData.clear();
            for(int row = 0; row < sdatatblmodel.getRowCount(); row++) {
                SearchData sdata = sdatatblmodel.getSearchData(row);
                SearchData.add(sdata);
            }
            sio.save(file);
        }
    }//GEN-LAST:event_jMenuSaveActionPerformed

    private void jBtnRowCpyActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jBtnRowCpyActionPerformed
        int SelectedRow = jTable1.getSelectedRow();
        if(SelectedRow >= 0) {
            SearchData sdata = sdatatblmodel.getSearchData(SelectedRow);
            sdatatblmodel.insertRow(SelectedRow, sdata);
        }
    }//GEN-LAST:event_jBtnRowCpyActionPerformed

    private void jMenuItem1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItem1ActionPerformed
        Desktop desktop = Desktop.getDesktop();
        String uriString = jTxtUrl.getText();
        try {
            URI uri = new URI(uriString);
            desktop.browse(uri);
            
        } catch (URISyntaxException | IOException ex) {
            Logger.getLogger(HtmlSearch.class.getName()).log(Level.SEVERE, null, ex);
        }
    }//GEN-LAST:event_jMenuItem1ActionPerformed

    private void jMenu2MouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jMenu2MouseClicked
        Search_execution();
    }//GEN-LAST:event_jMenu2MouseClicked

    private void jBtnSearchActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jBtnSearchActionPerformed
        Search_execution();
    }//GEN-LAST:event_jBtnSearchActionPerformed

    /**
     * 検索実行.
     */
    void Search_execution() {
        jTxtRtn.setText(null);
        HtmlParser par = new HtmlParser(jTxtUrl.getText());
        
        // データ無し(404)判定
        String strdata = par.getStringPageData();
        if(strdata == null) {
            jTxtRtn.append("読込みページがありません");
            return;
        }
        String text = jTxt404msg.getText();
        String[] strsearch = text.split("\n");
        for(String strsearch1 : strsearch) {
            if(strdata.contains(strsearch1)) {
                jTxtRtn.append(strsearch1);
                return;
            }
        }
        
        // 検索結果
        for(int row = 0; row < sdatatblmodel.getRowCount(); row++) {
            SearchData sdata = sdatatblmodel.getSearchData(row);
            String ans = sdata.getitem();
            String rtn = par.search(sdata);
            jTxtRtn.append(ans + "\t" + rtn + "\n");
        }
        
        jTxtRtn.setCaretPosition(0);
    }
    
    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        /* Set the Nimbus look and feel */
        //<editor-fold defaultstate="collapsed" desc=" Look and feel setting code (optional) ">
        /* If Nimbus (introduced in Java SE 6) is not available, stay with the default look and feel.
         * For details see http://download.oracle.com/javase/tutorial/uiswing/lookandfeel/plaf.html 
         */
        try {
            for (javax.swing.UIManager.LookAndFeelInfo info : javax.swing.UIManager.getInstalledLookAndFeels()) {
                if ("Nimbus".equals(info.getName())) {
                    javax.swing.UIManager.setLookAndFeel(info.getClassName());
                    break;
                }
            }
        } catch (ClassNotFoundException
                | InstantiationException
                | IllegalAccessException
                | javax.swing.UnsupportedLookAndFeelException ex) {
            java.util.logging.Logger.getLogger(HtmlSearch.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        }
        //</editor-fold>

        /* Create and display the form */
        java.awt.EventQueue.invokeLater(new Runnable() {
            @Override
            public void run() {
                new HtmlSearch().setVisible(true);
            }
        });
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jBtnRowCpy;
    private javax.swing.JButton jBtnRowDel;
    private javax.swing.JButton jBtnRowIns;
    private javax.swing.JButton jBtnSearch;
    private javax.swing.JFileChooser jFileChooser1;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JMenu jMenu1;
    private javax.swing.JMenu jMenu2;
    private javax.swing.JMenu jMenu3;
    private javax.swing.JMenuBar jMenuBar1;
    private javax.swing.JMenuItem jMenuItem1;
    private javax.swing.JMenuItem jMenuLoad;
    private javax.swing.JMenuItem jMenuSave;
    private javax.swing.JPanel jPanelRtn;
    private javax.swing.JPanel jPanelTab1;
    private javax.swing.JPanel jPanelTab2;
    private javax.swing.JRadioButton jRadioButton1;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JScrollPane jScrollPane404msg;
    private javax.swing.JScrollPane jScrollPaneLabel;
    private javax.swing.JScrollPane jScrollPaneRtn;
    private javax.swing.JTabbedPane jTabbedPane1;
    private javax.swing.JTable jTable1;
    private javax.swing.JTextArea jTxt404msg;
    private javax.swing.JTextArea jTxtLabel;
    private javax.swing.JTextArea jTxtRtn;
    private javax.swing.JTextField jTxtUrl;
    // End of variables declaration//GEN-END:variables
}

class SearchDataTableModel extends DefaultTableModel {
    /* ---------------------------------------------------------------------- *
     *   データ属性
     * ---------------------------------------------------------------------- */
    public String[] columnName = {
        /*  0 */    "項目名",
        /*  1 */    "タグ",
        /*  2 */    "ＩＤ",
        /*  3 */    "クラス",
        /*  4 */    "位置",
        /*  5 */    "抽出条件"
    };

    public Class[] columnClass = {
        /*  0 */    String.class,
        /*  1 */    String.class,
        /*  2 */    String.class,
        /*  3 */    String.class,
        /*  4 */    String.class,
        /*  5 */    String.class
    };
    
    int column_item      = 0;
    int column_htmltag   = 1;
    int column_htmlid    = 2;
    int column_htmlclass = 3;
    int column_around    = 4;
    int column_regexp    = 5;
    
    /* ---------------------------------------------------------------------- *
     *   処理
     * ---------------------------------------------------------------------- */
    @Override
    public String getColumnName(int modelIndex) {
        return columnName[modelIndex];
    }
    
    @Override
    public Class<?> getColumnClass(int modelIndex) {
        return columnClass[modelIndex];
    }
    
    @Override
    public int getColumnCount() {
        return columnName.length;
    }

    /* ---------------------------------------------------------------------- */
    
    public SearchData getSearchData(int row) {
        SearchData sdata = new SearchData();
        sdata.setitem(String.valueOf(getValueAt(row, column_item)));
        sdata.setHtmltag(String.valueOf(getValueAt(row, column_htmltag)));
        sdata.setHtmlid(String.valueOf(getValueAt(row, column_htmlid)));
        sdata.setHtmlclass(String.valueOf(getValueAt(row, column_htmlclass)));
        sdata.setaround(String.valueOf(getValueAt(row, column_around)));
        sdata.setregexp(String.valueOf(getValueAt(row, column_regexp)));
        return sdata;
    }
    
    public void addRow(SearchData sdata) {
        addRow(getObjdata(sdata));
    }
    
    public void insertRow(int row, SearchData sdata) {
        insertRow(row, getObjdata(sdata));
    }
    
    private Object[] getObjdata(SearchData sdata) {
        Object[] obj = new Object[] {
            sdata.getitem(), 
            sdata.getHtmltag(),
            sdata.getHtmlid(),
            sdata.getHtmlclass(),
            sdata.getaround(),
            sdata.getregexp()
        };
        return obj;
    }
    
}