/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package HtmlParser;

import javax.swing.text.html.HTML;
import org.junit.After;
import org.junit.AfterClass;
import static org.junit.Assert.*;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

/**
 *
 * @author kgto
 */
public class HtmlTagSearchTest {
    
    HtmlTagSearch tc;
    
    public HtmlTagSearchTest() {
        tc = new HtmlTagSearch();
    }
    
    @BeforeClass
    public static void setUpClass() {
        System.out.println("* HtmlTagSearchTest: @BeforeClass");
    }
    
    @AfterClass
    public static void tearDownClass() {
        System.out.println("* HtmlTagSearchTest: @AfterClass");
    }


    @Before
    public void setUp() {
        System.out.println("* HtmlTagSearchTest: @Before");
        // 保持情報表示
        disp();
    }

    @After
    public void tearDown() {
        System.out.println("* HtmlTagSearchTest: @After");
        // 保持情報表示
        disp();
    }
    
    // メンバ変数表示
    public void disp() {
        for(int i = 0; i < tc.size(); i++) {
            tc.get(i);
            System.out.println(" " + i + " tag: " + tc.gettag().toString() +
                    " id: " + tc.getid() + " class: " + tc.getclass());
        }
    }
    
    // テストデータ
    public void testdata() {
        System.out.println(" --- testdata 挿入 ---");
        
        tc.setall(HTML.Tag.DL, "dl-dataid1", "dl-dataclass1");
        tc.setid(HTML.Tag.DL, "dl-dataid1");
        tc.setclass(HTML.Tag.DL, "dl-dataclass1");

        tc.setall(HTML.Tag.DL, "dl-dataid2", "dl-dataclass2");
        tc.setid(HTML.Tag.DL, "dl-dataid2");
        tc.setclass(HTML.Tag.TH, "th-dataclass2");
        
        tc.setall(HTML.Tag.DIV, "div-dataid1", "div-dataclass1");
        tc.setid(HTML.Tag.DIV, "div-dataid1");
        tc.setclass(HTML.Tag.DIV, "div-dataclass1");
}
    
    
    /**
     * Test of setall method, of class HtmlTagSearch.
     */
    @Test
    public void testSetall() {
        System.out.println("* HtmlTagSearchTest: test method 1 - setall");
        
        //HtmlTagSearch tc = new HtmlTagSearch();
        int size1, size2;
        
        // 重複チェック
        // (1)Tagのみケース
        tc.setall(HTML.Tag.DL, null, null);
        size1 = tc.size();
        tc.setall(HTML.Tag.DL, null, null);
        size2 = tc.size();
        assertEquals(size1, size2);
        
        // (2)Tag + ID のケース
        tc.setall(HTML.Tag.DL, "testid1", null);
        size1 = tc.size();
        tc.setall(HTML.Tag.DL, "testid1", null);
        size2 = tc.size();
        assertEquals(size1, size2);
        
        // (3)Tag + Class のケース
        tc.setall(HTML.Tag.DL, null, "testclass1");
        size1 = tc.size();
        tc.setall(HTML.Tag.DL, null, "testclass1");
        size2 = tc.size();
        assertEquals(size1, size2);

        // (4)Tag + ID + Class のケース
        tc.setall(HTML.Tag.DL, "testid1", "testclass1");
        size1 = tc.size();
        tc.setall(HTML.Tag.DL, "testid1", "testclass1");
        size2 = tc.size();
        assertEquals(size1, size2);
        
        // 重複チェック後の登録数
        assertEquals(4, size2);
        
        // 登録チェック
        tc.setall(HTML.Tag.DIV, null, null);
        tc.setall(HTML.Tag.DIV, "testid1div", null);
        tc.setall(HTML.Tag.DIV, null, "testclass1div");
        tc.setall(HTML.Tag.DIV, "testid1div", "testclass1div");
        assertEquals(8, tc.size());
        
        // ID違いの登録
        tc.setall(HTML.Tag.DL, "testid2", null);
        tc.setall(HTML.Tag.DIV, "testid2div", null);
        // Class違いの登録
        tc.setall(HTML.Tag.DL, null, "testclass2");
        tc.setall(HTML.Tag.DIV, null, "testclass2div");
        // ID + Class違いの登録
        tc.setall(HTML.Tag.DL, "testid2", "testclass2");
        tc.setall(HTML.Tag.DL, "testid2", "testclass3");
        tc.setall(HTML.Tag.DL, "testid3", "testclass2");
        tc.setall(HTML.Tag.DIV, "testid2div", "testclass2div");
        tc.setall(HTML.Tag.DIV, "testid2div", "testclass3div");
        tc.setall(HTML.Tag.DIV, "testid3div", "testclass2div");
        assertEquals(18, tc.size());
        
    }

    /**
     * Test of setid method, of class HtmlTagSearch.
     */
    @Test
    public void testSetid() {
        System.out.println("* HtmlTagSearchTest: test method 2 - setid");
        
        //HtmlTagSearch tc = new HtmlTagSearch();
        int size1;
        
        // 重複チェック
        tc.setid(HTML.Tag.DL, "dl-setid1");
        size1 = tc.size();
        tc.setid(HTML.Tag.DL, "dl-setid1");
        assertEquals(size1, tc.size());
        
        // 登録チェック
        tc.setid(HTML.Tag.DIV, "div-setid1");
        assertEquals(2, tc.size());
        
        // ID違いの登録
        tc.setid(HTML.Tag.DIV, "div-setid2");
        tc.setid(HTML.Tag.DL, "dl-setid2");
        assertEquals(4, tc.size());
    }

    /**
     * Test of setclass method, of class HtmlTagSearch.
     */
    @Test
    public void testSetclass() {
        System.out.println("* HtmlTagSearchTest: test method 3 - setclass");
        
        //HtmlTagSearch tc = new HtmlTagSearch();
        int size1;
        
        // 重複チェック
        tc.setclass(HTML.Tag.DL, "dl-setclass1");
        size1 = tc.size();
        tc.setclass(HTML.Tag.DL, "dl-setclass1");
        assertEquals(size1, tc.size());
        
        // 登録チェック
        tc.setclass(HTML.Tag.DIV, "div-setclass1");
        assertEquals(2, tc.size());
        
        // Class違いの登録
        tc.setclass(HTML.Tag.DIV, "div-setclass2");
        tc.setclass(HTML.Tag.DL, "dl-setclass2");
        assertEquals(4, tc.size());
    }

    /**
     * Test of get method, of class HtmlTagSearch.
     */
    @Test
    public void testGet() {
        System.out.println("* HtmlTagSearchTest: test method 4 - get");
        
        testdata();
        tc.get(7);
        assertEquals(HTML.Tag.DIV, tc.gettag());
        assertEquals("div-dataid1", tc.getid());
        assertEquals(null, tc.getclass());
        
        // 引数 >= tc.size() の時、直前の値のままになっていること
        int i = tc.size();
        tc.get(i);
        assertEquals(HTML.Tag.DIV, tc.gettag());
        assertEquals("div-dataid1", tc.getid());
        assertEquals(null, tc.getclass());
    }

    /**
     * Test of gettag method, of class HtmlTagSearch.
     */
    @Test
    public void testGettag() {
        System.out.println("* HtmlTagSearchTest: test method 5 - gettag");

        testdata();
        tc.get(5);
        assertEquals(HTML.Tag.TH, tc.gettag());
    }

    /**
     * Test of getid method, of class HtmlTagSearch.
     */
    @Test
    public void testGetid() {
        System.out.println("* HtmlTagSearchTest: test method 6 - getid");
        
        testdata();
        tc.get(7);
        assertEquals("div-dataid1", tc.getid());
    }

    /**
     * Test of getclass method, of class HtmlTagSearch.
     */
    @Test
    public void testGetclass() {
        System.out.println("* HtmlTagSearchTest: test method 7 - getclass");
        
        testdata();
        tc.get(8);
        assertEquals("div-dataclass1", tc.getclass());
    }

    /**
     * Test of size method, of class HtmlTagSearch.
     */
    @Test
    public void testSize() {
        System.out.println("* HtmlTagSearchTest: test method 8 - size");
        
        testdata();
        assertEquals(9, tc.size());
    }

    /**
     * Test of searchall method, of class HtmlTagSearch.
     */
    @Test
    public void testSearchall() {
        System.out.println("* HtmlTagSearchTest: test method 9 - searchall");
        
        testdata();
        
        assertTrue(tc.searchall(HTML.Tag.DL, "dl-dataid2", "dl-dataclass2"));
        assertTrue(tc.searchall(HTML.Tag.DL, null, "dl-dataclass1"));
        assertTrue(tc.searchall(HTML.Tag.DL, "dl-dataid2", null));
        
        assertFalse(tc.searchall(HTML.Tag.TH, "dl-dataid2", "dl-dataclass2"));
        assertFalse(tc.searchall(HTML.Tag.TH, null, "dl-dataclass0"));
        assertFalse(tc.searchall(HTML.Tag.TH, "th-dataid0", null));
        
        assertTrue(tc.searchall(HTML.Tag.DIV, null, "div-dataclass1"));
    }

    /**
     * Test of searchid method, of class HtmlTagSearch.
     */
    @Test
    public void testSearchid() {
        System.out.println("* HtmlTagSearchTest: test method 10 - searchid");
        
        testdata();
        
        assertTrue(tc.searchid(HTML.Tag.DL, "dl-dataid1"));
        assertTrue(tc.searchid(HTML.Tag.DIV, "div-dataid1"));

        assertFalse(tc.searchid(HTML.Tag.TH, "TH-dataid0"));
        assertFalse(tc.searchid(HTML.Tag.DIV, "TH-dataid0"));
        
        assertTrue(tc.searchid(HTML.Tag.DL, "dl-dataid2"));
    }

    /**
     * Test of searchclass method, of class HtmlTagSearch.
     */
    @Test
    public void testSearchclass() {
        System.out.println("* HtmlTagSearchTest: test method 11 - searchclass");
        
        testdata();
        
        assertFalse(tc.searchclass(HTML.Tag.DL, "dl-dataclass2"));
        assertFalse(tc.searchclass(HTML.Tag.DIV, "div-dataclass3"));
        assertFalse(tc.searchclass(HTML.Tag.DIV, "aaaaa"));
        
        assertTrue(tc.searchclass(HTML.Tag.DL, "dl-dataclass1"));
        assertTrue(tc.searchclass(HTML.Tag.TH, "th-dataclass2"));
        assertTrue(tc.searchclass(HTML.Tag.DIV, "div-dataclass1"));
    }
    
}
