
package XmlTest1;

import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class Traversal {

    public static void main(String[] args)
            throws ParserConfigurationException, SAXException, IOException {
        //パーサを作成 
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        //パース 
        Document doc = db.parse("MyTest.gwt.xml");
        print(doc, 0);
    }

    static void print(Node node, int indent) {
        // インデントを表示 
        for (int i = 0; i < indent; i++) {
            System.out.print(" ");
        }
        // ノードの種別と名前、値を出力 
        System.out.println(node.getNodeType() + " " + node.getNodeName() + " = " + node.getNodeValue());
        if(node.getNodeType() == Node.ELEMENT_NODE) {
            System.out.println("FistValue = " + node.getFirstChild().getNodeValue());    
        }
        
        Node child;
        for (child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            // 再帰呼び出し 
            print(child, indent + 1);
        }
    }
}
