/*
 * Interface for personal dictionary
 */
#ifndef _dicutil_h_included_
#define _dicutil_h_included_

#ifdef __cplusplus
extern "C" {
#endif


/** ֤ / anthy_priv_dic_add_entry */
enum anthy_priv_dic_ret_t {
  /** OK / ñ줬ϿǤ */
  ANTHY_DIC_UTIL_OK = 0,
  /**  / Ͽ˼Ԥ */
  ANTHY_DIC_UTIL_ERROR = -1,
  /** Ʊñ줬ϿƤä٤ */
  ANTHY_DIC_UTIL_DUPLICATE = -2,
  /** ¸ߤʤ */
  ANTHY_DIC_UTIL_INVALID = -3,
};

extern void anthy_dic_util_init(void);
extern int anthy_dic_util_init_with_dicrefresh( void );	/* Patched by G-HAL, Wed,14 Jan,2009 */
extern void anthy_dic_util_quit(void);
extern void anthy_dic_util_set_personality(const char *id);
extern const char *anthy_dic_util_get_anthydir(void);
#define HAS_ANTHY_DICUTIL_SET_ENCODING
extern int anthy_dic_util_set_encoding(int enc);

extern void anthy_priv_dic_delete(void);
extern int anthy_priv_dic_select_first_entry(void);
extern int anthy_priv_dic_select_next_entry(void);

extern char *anthy_priv_dic_get_index(char *buf, int len);
extern int anthy_priv_dic_get_freq(void);
extern char *anthy_priv_dic_get_wtype(char *buf, int len);
extern char *anthy_priv_dic_get_word(char *buf, int len);

extern enum anthy_priv_dic_ret_t anthy_priv_dic_add_entry(const char *yomi, const char *word,
			     const char *wt, int freq);

/* experimental and unstable /usr/share/dict/wordsñõ */
#define HAS_ANTHY_DIC_SEARCH_WORDS_FILE
extern char *anthy_dic_search_words_file(const char *word);


#ifdef __cplusplus
}
#endif

#endif /* _dicutil_h_included_ */
/* [ End of File ] */
/* vim:ts=8 sw=2 nomodified:
 */
