/**@file
 *			Patches for Anthy, by G-HAL
 *@brief	Ķθ
 *@date		Fri,17 Mar,2000 - Thu,16 Apr,2009
 *@date		Wed,13 Oct,2010
 *@date		Sun,31 Jul,2011 - Fri,12 Aug,2011
 *@date		Sat,19 Nov,2011
 *@author	Copyright(C)2000-2011 G-HAL
 *
 *@note
 *@verbatim
Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

* Redistributions of source code must retain the above copyright
notice, this list of conditions and the following disclaimer.

* Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

* Neither the name of the copyright holders nor the names of its contributors
may be used to endorse or promote products derived from this software
without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
SUCH DAMAGE.
 *@endverbatim
 */
#ifndef _environment_check_h_included_
#define _environment_check_h_included_


/* #define	_XOPEN_SOURCE			*/	/* XPG3?, XPG4?, XPG4v2?, POSIX.1, POSIX.2, NetBSD/OpenBSD */
/* #define	_XOPEN_SOURCE	2		*/	/* ? */
/* #define	_XOPEN_SOURCE	500		*/	/* XPG5, SUSv2 UNIX 98, FreeBSD/NetBSD/OpenBSD, Legacy GNU/Linux?, OpenBSD:_POSIX_C_SOURCE=199506L */
/* #define	_XOPEN_SOURCE	520		*/	/* XPG5v2, NetBSD/OpenBSD, OpenBSD:_POSIX_C_SOURCE=199506L */
/* #define	_XOPEN_SOURCE	600		*/	/* POSIX 1003.1-2001 with XSI, SUSv3 UNIX 03; POSIX.1-2001 XSI, FreeBSD/NetBSD/OpenBSD, Current GNU/Linux?, OpenBSD:_POSIX_C_SOURCE=200112L */
/* #define	_XOPEN_SOURCE	700		*/	/* POSIX 1003.1-2008 with XSI, SUSv4 POSIX.1-2008 XSI, OpenBSD, OpenBSD:_POSIX_C_SOURCE=200809L */
/* #define	_XOPEN_SOURCE_EXTENDED	*/	/* NetBSD/OpenBSD, GNU/Linux, XPG4v2 */

/* #define	_POSIX_C_SOURCE			*/	/* 1003.1-1988, FreeBSD */
/* #define	_POSIX_C_SOURCE	198808L	*/	/* 1003.1-1988, FreeBSD */
/* #define	_POSIX_C_SOURCE	1		*/	/* POSIX.1-1990, FreeBSD/NetBSD/OpenBSD, GNU/Linux */
/* #define	_POSIX_C_SOURCE	199009L	*/	/* POSIX.1-1990, FreeBSD */
/* #define	_POSIX_C_SOURCE	2		*/	/* POSIX.2-1992, FreeBSD/NetBSD/OpenBSD, IEEE Std 1003.2, GNU/Linux */
/* #define	_POSIX_C_SOURCE	199209L	*/	/* POSIX.2-1992, FreeBSD */
/* #define	_POSIX_C_SOURCE	199309L	*/	/* POSIX.1b-1993, FreeBSD/NetBSD/OpenBSD, GNU/Linux */
/* #define	_POSIX_C_SOURCE	199506L	*/	/* POSIX.1c-1995, 1003.1i-1995, FreeBSD/NetBSD/OpenBSD, GNU/Linux */
/* #define	_POSIX_C_SOURCE	200112L	*/	/* POSIX.1-2001, FreeBSD/NetBSD/OpenBSD, IEEE 1003.1-2004, GNU/Linux */
/* #define	_POSIX_C_SOURCE	200809L	*/	/* POSIX.1-2008, OpenBSD */

/* #define	_POSIX_SOURCE			*/	/* Obsolete, IEEE Std 1003.1-1988 */
/* #define	_POSIX_VERSION			*/	/* Defined at unistd.h, POSIX.1 version */
/* #define	__POSIX_VISIBLE			*/	/* Defined at sys/cdefs.h in FreeBSD/OpenBSD */

/* #define	__ISO_C_VISIBLE			*/	/* Defined at sys/cdefs.h in FreeBSD/OpenBSD, 1988? */
/* #define	__ISO_C_VISIBLE	1990	*/	/* Defined at sys/cdefs.h in FreeBSD/OpenBSD, C90 */
/* #define	__ISO_C_VISIBLE	1999	*/	/* Defined at sys/cdefs.h in FreeBSD/OpenBSD, C99 */
/* #define	_ISOC99_SOURCE			*/	/* In NetBSD/OpenBSD, GNU/Linux, (1999 == __ISO_C_VISIBLE)  */

/* #define	__BSD_VISIBLE			*/	/* *BSD OnlyBSD ͳ */

/* #define	_BSD_SOURCE				*/	/* GNU/Linux OnlyBSD ͳ */
/* #define	_SVID_SOURCE			*/	/* GNU/Linux OnlySystem V ͳ */
/* #define	_FORTIFY_SOURCE	1		*/
/* #define	_FORTIFY_SOURCE	2		*/	/* GNU/Linux Only(gcc 4.0ʹ)(glibc 2.3.4 ʹ)
											ʸԤ͡ʴؿѤݤ
											ХåեСե򸡽Ф뤿
											ڤΥå¹Ԥ褦ˤʤ롣
											-O1 ʾΤͭ */


#if defined(HAVE_UNISTD_H)
# include <unistd.h>			/* Unix like OS Only */
#endif
#if defined(HAVE_FEATURES_H)
# include <features.h>			/* GNU/Linux Only */
#endif
#if defined(HAVE_SYS_FEATURETEST_H)
# include <sys/featuretest.h>	/* NetBSD Only */
#endif
#if defined(HAVE_SYS_CDEFS_H)
# include <sys/cdefs.h>			/* *BSD Only */
#endif

#if defined(GCC30_REMOVAL_OF_HEADERS)
# if defined(HAVE_MALLOC_H)
#  undef	HAVE_MALLOC_H
# endif
# if defined(HAVE_ALLOCA_H)
#  undef	HAVE_ALLOCA_H
# endif
#endif
#if defined(GCC43_REMOVAL_OF_PREISO_HEADERS)
# if defined(HAVE_ALLOC_H)
#  undef	HAVE_ALLOC_H
# endif
#endif


/*  */
#if (200809UL <= (_POSIX_C_SOURCE +0)) || (!defined(_POSIX_C_SOURCE) && (200809UL <= (__POSIX_VISIBLE +0))) || (!defined(_POSIX_C_SOURCE) && !defined(__POSIX_VISIBLE) && (200809 <= (_POSIX_VERSION +0))) || defined(__BSD_VISIBLE) || (defined(__linux__) && (defined(_BSD_SOURCE) || defined(_SVID_SOURCE)))
# define	STAT_has_tv_nsec	/* stat(2)  buf  tv_nsec äƤ롣 */
#endif



/**@name define		ѥ¸
@{
 */

#define	SLASH()			/

#if defined(__GNUC__)

# if (3 < __GNUC__) || ((3 == __GNUC__) && (1 <= __GNUC_MINOR__))
#  define	COMPILER_SUPPORT_NRVO		/**< Named Return Value Optimization б */
#  define	COMPILER_NRV(arg)		
#  define	COMPILER_NRVO(arg)		arg
# elif (2 == __GNUC__)
#  define	COMPILER_SUPPORT_NRV		/**< Named Return Value б */
#  define	COMPILER_NRV(arg)		arg
#  define	COMPILER_NRVO(arg)		
# else
#  define	COMPILER_NRV(arg)		
#  define	COMPILER_NRVO(arg)		arg
# endif

# if !defined(_unused_)
#  if defined(__unused)
#   define		_unused_	__unused					/** *BSD, Not Linux */
#  else
#   if !defined(HAVE_CONFIG_H)
#    if (3 < __GNUC__) || ((3 == __GNUC__) && (3 <= __GNUC_MINOR__))
#     define	_unused_	__attribute__((__unused__))	/**< __unused__ б */
#    else
#     define	_unused_								/**< __unused__ б */
#    endif
#   else
#    if defined(HAVE___ATTRIBUTE__UNUSED_)
#     define	_unused_	__attribute__((__unused__))	/**< __unused__ б */
#    else
#     define	_unused_								/**< __unused__ б */
#    endif
#   endif
#  endif
# endif

# if !defined(_unused)
#  if !defined(HAVE_CONFIG_H)
#   if (3 < __GNUC__) || ((3 == __GNUC__) && (4 <= __GNUC_MINOR__))
#    define	_unused	__attribute__((__unused__))	/**< ؿΰ __unused__ б */
#   else
#    define	_unused								/**< ؿΰ __unused__ б */
#   endif
#  else
#   if defined(HAVE___ATTRIBUTE__UNUSED_ARG)
#    define	_unused	__attribute__((__unused__))	/**< ؿΰ __unused__ б */
#   else
#    define	_unused								/**< ؿΰ __unused__ б */
#   endif
#  endif
# endif

#else	/* defined(__GNUC__) */

# define	COMPILER_NRV(arg)		/* not supported */
# define	COMPILER_NRVO(arg)		arg

# if !defined(HAVE_CONFIG_H)
#  if !defined(__attribute__)
#   define	__attribute__(x)		/* not supported */
#  endif
#  if !defined(unused_)
#   define	_unused_				/* not supported */
#  endif
#  if !defined(_unused)
#   define	_unused					/* not supported */
#  endif
# else

#  if !defined(__attribute__)
#   if defined(HAVE___ATTRIBUTE__)
#   else
#    define	__attribute__(x)		/* not supported */
#   endif
#  endif

#  if !defined(_unused_)
#   if defined(HAVE___ATTRIBUTE__UNUSED_)
#    define	_unused_	__attribute__((__unused__))	/**< __unused__ б */
#   else
#    define	_unused_								/**< __unused__ б */
#   endif
#  endif

#  if !defined(_unused)
#   if defined(HAVE___ATTRIBUTE__UNUSED_ARG)
#    define	_unused	__attribute__((__unused__))	/**< ؿΰ __unused__ б */
#   else
#    define	_unused								/**< ؿΰ __unused__ б */
#   endif
#  endif

# endif

#endif	/* defined(__GNUC__) else */


# if !defined(__printflike)
#  if defined(HAVE___ATTRIBUTE____FORMAT____PRINTF__)
#   define __printflike(fmtarg, firstvararg)	__attribute__((__format__ (__printf__, fmtarg, firstvararg)))
#  else
#   define __printflike(fmtarg, firstvararg)
#  endif
# endif

# if !defined(__scanflike)
#  if defined(HAVE___ATTRIBUTE____FORMAT____SCANF__)
#   define __scanflike(fmtarg, firstvararg)		__attribute__((__format__ (__scanf__, fmtarg, firstvararg)))
#  else
#   define __scanflike(fmtarg, firstvararg)
#  endif
# endif

# if !defined(__bounded__)
#  if !defined(HAVE_CONFIG_H)
#   if defined(__OpenBSD__) && ((3 < __GNUC__) || ((3 == __GNUC__) && (2 < __GNUC_MINOR__)) || ((3 == __GNUC__) && (2 == __GNUC_MINOR__) && (3 <= __GNUC_PATCHLEVEL__)))
/* OpenBSD 3.4 ʹߤ __attribute__((__bounded__(,,))) б
 * ޥ OpenBSD ΥСľΤˡĤʤäΤǡ
 */
#   else
#    define	__bounded__(a,b,c)		/**< ХåեСեŪ̵ */
#   endif
#  else
#   if defined(HAVE___ATTRIBUTE__BOUNDED)
#   else
#    define	__bounded__(a,b,c)		/**< ХåեСեŪ̵ */
#   endif
#  endif
# endif

/**@}
 */



/**@name function_alias	ؿ̾
@{
 */

#if defined(HAVE_DECL_BETOH64) && defined(HAVE_DECL_BE64TOH) && !HAVE_DECL_BETOH64 && HAVE_DECL_BE64TOH
# define	betoh64		be64toh
# undef		HAVE_DECL_BETOH64
# define	HAVE_DECL_BETOH64	1
#endif

#if defined(HAVE_DECL_BETOH64) && defined(HAVE_DECL_NTOHLL) && !HAVE_DECL_BETOH64 && HAVE_DECL_NTOHLL
# define	betoh64		ntohll
# undef		HAVE_DECL_BETOH64
# define	HAVE_DECL_BETOH64	1
#endif

#if defined(HAVE_DECL_HTOBE64) && defined(HAVE_DECL_HTONLL) && !HAVE_DECL_HTOBE64 && HAVE_DECL_HTONLL
# define	htobe64		htonll
# undef		HAVE_DECL_HTOBE64
# define	HAVE_DECL_HTOBE64	1
#endif

/**@}
 */



/**@name tips	äΤʤޥ
@{
 */

#if !defined(_number_)
# define		_number_(arr)			(sizeof(arr)/sizeof((arr)[0]))
#endif

/**@}
 */



#ifdef __cplusplus
extern "C" {
#endif


#ifdef __cplusplus
}
#endif

#endif /* _environment_check_h_included_ */
/* [ End of File ] */
/* vim:ts=4 sw=4 nomodified:
 */
