/**@file
 *		Patches for Anthy, by G-HAL
 *@brief	ΥХʥ꼭
 *@date		Sat,17 Oct,2009 - Tue,20 Oct,2009
 *@date		Sat,31 Oct,2009
 *@date		Sat,07 Nov,2009
 *@date		Fri,13 Nov,2009 - Sat,14 Nov,2009
 *@date		Wed,13 Oct,2010 - Thu,14 Oct,2010
 *@author	Copyright(C)2009-2010 G-HAL
 */
#if 0		/* Patched by G-HAL */
/*
 * 㼭
 *
 * Copyright (C) 2003-2005 TABATA Yusuke
 */
#include <stdlib.h>
#include <string.h>
#include <stdio.h>

#include <anthy/matrix.h>
#include "mkdic.h"
#else
#if defined(HAVE_CONFIG_H)
# include "config.h"
#endif

#if defined(HAVE_STDLIB_H)
# include <stdlib.h>
#endif
#if defined(HAVE_MALLOC_H)
# include <malloc.h>
#endif
#if defined(HAVE_STDIO_H)
# include <stdio.h>
#endif
#if !defined(__STDC_LIMIT_MACROS)
# define __STDC_LIMIT_MACROS
#endif
#if !defined(__STDC_CONSTANT_MACROS)
# define __STDC_CONSTANT_MACROS
#endif
#if defined(HAVE_STDINT_H)
# include <stdint.h>
#endif
#if !defined(__STDC_FORMAT_MACROS)
# define __STDC_FORMAT_MACROS
#endif
#if defined(HAVE_INTTYPES_H)
# include <inttypes.h>
#endif
#if defined(HAVE_SYS_TYPES_H)
# include <sys/types.h>
#endif
#if defined(HAVE_STRING_H)
# include <string.h>
#endif
#if defined(HAVE_STRINGS_H)
# include <strings.h>
#endif
#if defined(HAVE_ASSERT_H)
# include <assert.h>
#endif

#include "anthy/anthy.h"
#include "anthy/settings.h"
#include "anthy/xstr.h"
#include "anthy/matrix.h"
#include "src-ordering/ucdict.h"
#include "mkdic.h"
#endif

#if 0	/* Patched by G-HAL */



#define LINE_LEN 256

/*  */
struct use_case {
  int id[2];
  struct use_case *next;
};

/* 㼭 */
struct uc_dict {
  /* ꥹ */
  struct use_case uc_head;
  int nr_ucs;
};

/* ιԤñid
 */
static int
get_id_from_word_line(char *buf)
{
  char yomi[LINE_LEN];
  char okuri[LINE_LEN];
  char wt[LINE_LEN];
  char kanji[LINE_LEN];
  int res, id;
  xstr *xs;

  res = sscanf(buf, "%s %s %s %s", yomi, okuri, wt, kanji);
  if (res != 4) {
    return -1;
  }
  xs = anthy_cstr_to_xstr(kanji, 0);
  id = anthy_xstr_hash(xs);
  anthy_free_xstr(xs);
  return id;
}

static void
commit_uc(struct uc_dict *dict, int x, int y)
{
  struct use_case *uc;
  if (x < 0 || y < 0) {
    return ;
  }
  uc = (struct use_case*) malloc(sizeof(struct use_case));
  uc->id[0] = x;
  uc->id[1] = y;
  /**/
  uc->next = dict->uc_head.next;
  dict->uc_head.next = uc;
  dict->nr_ucs ++;
}

/* ǡ١ */
struct uc_dict *
create_uc_dict(void)
{
  struct uc_dict *dict = (struct uc_dict*) malloc(sizeof(struct uc_dict));

  dict->uc_head.next = NULL;
  dict->nr_ucs = 0;

  return dict;
}

/* եɤ߹ */
void
read_uc_file(struct uc_dict *dict, const char *fn)
{
  char buf[LINE_LEN];
  FILE *uc_file;
  int off, base = 0, cur;
  int line_number = 0;

  uc_file = fopen(fn, "r");
  if (!uc_file) {
    return ;
  }

  /* off=0      : ǽñ
   * off=1,2..n : ȴطñ
   */
  off = 0;
  while (fgets(buf, LINE_LEN, uc_file)) {
    /**/
    line_number ++;
    /**/
    if (buf[0] == '#') {
      /*  */
      continue;
    }
    if (buf[0] == '-') {
      /* ڤ국 */
      off = 0;
      continue;
    }
    cur = get_id_from_word_line(buf);
    if (cur == -1) {
      fprintf(stderr, "Invalid line(%d):%s\n", line_number, buf);
    }
    /**/
    if (off == 0) {
      /* Ĥι */
      base = cur;
    } else {
      /* Ĥʹߤι */
      commit_uc(dict, cur, base);
    }
    off ++;
  }
}

/* 㼭ե˽񤭽Ф */
void
make_ucdict(FILE *uc_out, struct uc_dict *dict)
{
  struct use_case *uc;
  struct sparse_matrix *sm;
  struct matrix_image *mi;
  int i;
  /* ¹˵ͤ */
  sm = anthy_sparse_matrix_new();
  if (dict) {
    for (uc = dict->uc_head.next; uc; uc = uc->next) {
      anthy_sparse_matrix_set(sm, uc->id[0], uc->id[1], 1, NULL);
    }
  }
  anthy_sparse_matrix_make_matrix(sm);
  /* ¹Υ᡼ƥե˽񤭽Ф */
  mi = anthy_matrix_image_new(sm);
  for (i = 0; i < mi->size; i++) {
    write_nl(uc_out, mi->image[i]);
  }
  if (dict) {
    printf("udic: %d use examples.\n", dict->nr_ucs);
  } else {
    printf("udic: no use examples.\n");
  }

}



#else	/* Patched by G-HAL */



#define	BUF_LEN	256	/* ԥѡѥХåեΥ */
static const char UC_INDEP_WILDCARD[] = "*";			/**< 㼭Ρ°磻ɥɥե饰ʸ */
static const char UC_DEP_BLANKMARK[]  = "_";			/**< 㼭Ρ°̵ե饰ʸ */
static const char UC_DEP_WILDCARD[]   = "*";			/**< 㼭Ρ°磻ɥɥե饰ʸ */
static const char UC_WT_WILDCARD[]    = UCDICT_WT_WILDCARD;	/**< 㼭ΡΩʻΥ磻ɥʸ */
static const char UC_WT_NULL[]        = "";			/**< 㼭ΡʻΥʸ */



/** ǡΣåȤθǡ */
struct uc_seg_pair {
  xstr* id1indep_yomi;		/**< μΩɤ߲̾ */
  xstr* id1indep_cand;		/**< μΩѴ */
  char* id1indep_wt;		/**< ʻ */
  xstr* id1dep;			/**< ° */
  char* id1dep_wt;		/**< ʻ */
  xstr* id2indep_yomi;		/**< μΩɤ߲̾ */
  xstr* id2indep_cand;		/**< μΩѴ */
  char* id2indep_wt;		/**< ʻ */
  xstr* id2dep;			/**< ° */
  char* id2dep_wt;		/**< ʻ */
};

/** ǡΣå */
struct use_case {
  int			monopolize;	/**< id ξͤʤåȤǥХå */
  int			line_number;	/**< ιֹ桧ǥХå */
  int			id[2];		/**< ʸڥγƥϥå */
  int			value;		/**< ʸڥФե饰 */
  struct use_case*	next;		/**< ꥹ */
  struct uc_seg_pair*	seg_pair_info;	/**< ʸڥθǡ */
};

/** ΥХʥ꼭δ¤ */
struct uc_dict {
  int				nr;		/**< ǡåȿ */
  struct use_case*		head;		/**< ƬΥǡå */
  const struct yomi_entry_list*	dic_entry;	/**< Ѥ̾Ｍ */
};



/** ʸü EOL 
 *@param[in,out]	buf			ʸ
 *
 *@note
 *	 Anthy ΤμδܴؿͥԲĤˤʤäƤ뤫鼫Ǻ뤷ʤ
 *
 *@comment
 *	Patched by G-HAL
 *	Sat,17 Oct,2009 - Sun,18 Oct,2009
 */
static void chomp_eol( char* const buf )
{
  assert( buf );
  { size_t len = strlen( buf );
    while (0 < len) {
      --len;
      switch (buf[len]) {
      case '\\':
      default:
	goto DOUBLE_BREAK;
      case '\n':
      case '\r':
      case ' ':
      case '\t':
	if (0 < len) {
	  if ('\\' == buf[len-1]) {
	    goto DOUBLE_BREAK;
	  }
	}
	buf[len] = '\0';
	break;
      }
    }
   DOUBLE_BREAK:
    ;
  }
  return;
}

/** ʸƬ SPC 򥹥å
 *@param[in,out]	buf			ʸ
 *
 *@note
 *	 Anthy ΤμδܴؿͥԲĤˤʤäƤ뤫鼫Ǻ뤷ʤ
 *
 *@comment
 *	Patched by G-HAL
 *	Sat,17 Oct,2009 - Sun,18 Oct,2009
 */
static char* skip_space( char* const buf )
{
  char* ptr = buf;
  assert( buf );
  while (*ptr) {
    switch (*ptr) {
    case '\\':
    default:
      goto DOUBLE_BREAK;
    case '\n':
    case '\r':
    case ' ':
    case '\t':
      break;
    }
    ++ptr;
  }
 DOUBLE_BREAK:
  return ptr;
}

/** ʸ󤫤 SPC ڤΥȡ򣱤ļ
 *@param[in]		buf			ʸ
 *@param[in,out]	ret			ʸ
 *@return					ȡʸ
 *
 *@note
 *	buf μȡθ NUL ˽񤭴롣
 *
 *	 Anthy ΤμδܴؿͥԲĤˤʤäƤ뤫鼫Ǻ뤷ʤ
 *
 *@comment
 *	Patched by G-HAL
 *	Sat,17 Oct,2009 - Sun,18 Oct,2009
 */
static char* get_token( char* const buf, char** const next )
{
  if (NULL == buf) {
    if (next) {
      *next = NULL;
    }
    return NULL;
  }
  { char* const ret = skip_space( buf );
    char* ptr = ret;
    while (*ptr) {
      switch (*ptr) {
      case '\\':
	if ('\0' != (ptr[1])) {
	  ++ptr;
	}
	break;
      default:
	break;
      case '\n':
      case '\r':
      case ' ':
      case '\t':
	goto DOUBLE_BREAK;
      }
      ++ptr;
    }
   DOUBLE_BREAK:
    if (next) {
      if ('\0' != *ptr) {
	*next = &(ptr[1]);
      } else {
	*next = NULL;
      }
    }
    *ptr = '\0';
    return ret;
  }
}



/** ڥȥե饰Хʥ꼭Ͽ
 *@param[in,out]	ucdic			ΥХʥ꼭δ¤
 *@param		id1			
 *@param		id2			
 *@param		flag			ե饰
 *@param		monopolize		id ξͤʤåȤ
 *@param[in]		id1indep_yomi		θǡμΩʬɤ߲̾
 *@param[in]		id1indep_cand		θǡμΩʬѴ
 *@param[in]		id1indep_wt		θǡμΩʬʻ
 *@param[in]		id1dep			θǡ°ʬ
 *@param[in]		id1dep_wt		θǡ°ʬʻ
 *@param[in]		id2indep_yomi		θǡμΩʬɤ߲̾
 *@param[in]		id2indep_cand		θǡμΩʬѴ
 *@param[in]		id2indep_wt		θǡμΩʬʻ
 *@param[in]		id2dep			θǡ°ʬ
 *@param[in]		id2dep_wt		θǡ°ʬʻ
 *@param		line_no			ιֹ桧ǥХå
 *@retval		0			ｪλ
 *@retval		!= 0			͡ϥå⤷ϥե饰ξͤ򵯤ֹ
 *
 *@comment
 *	Patched by G-HAL
 *	Sat,17 Oct,2009 - Tue,20 Oct,2009
 *	Sat,31 Oct,2009 - Sun,01 Nov,2009
 *	Fri,13 Nov,2009
 */
static int commit_uc( struct uc_dict* const ucdic, int id1, int id2, int flag, int monopolize,
		     const xstr* const id1indep_yomi, const xstr* const id1indep_cand, const char* const id1indep_wt, const xstr* const id1dep, const char* const id1dep_wt,
		     const xstr* const id2indep_yomi, const xstr* const id2indep_cand, const char* const id2indep_wt, const xstr* const id2dep, const char* const id2dep_wt,
		     int line_no )
{
  int ret  = 0;
  struct use_case* uc;
  assert( ucdic );
  for (uc = ucdic->head; uc; uc = uc->next) {
    if ((id1 == uc->id[0]) && (id2 == uc->id[1])) {
      if ((~UCDICT_PRIORITY & uc->value) != (~UCDICT_PRIORITY & flag)) {
	return uc->line_number;
      }
      if (monopolize || uc->monopolize) {
	if ((0 == anthy_xstrcmp(id1indep_yomi, uc->seg_pair_info->id1indep_yomi))
	    && (0 == anthy_xstrcmp(id1indep_cand, uc->seg_pair_info->id1indep_cand))
	    && (0 ==        strcmp(id1indep_wt, uc->seg_pair_info->id1indep_wt))
	    && (0 == anthy_xstrcmp(id1dep, uc->seg_pair_info->id1dep))
	    && (0 ==        strcmp(id1dep_wt, uc->seg_pair_info->id1dep_wt))
	    && (0 == anthy_xstrcmp(id2indep_yomi, uc->seg_pair_info->id2indep_yomi))
	    && (0 == anthy_xstrcmp(id2indep_cand, uc->seg_pair_info->id2indep_cand))
	    && (0 ==        strcmp(id2indep_wt, uc->seg_pair_info->id2indep_wt))
	    && (0 == anthy_xstrcmp(id2dep, uc->seg_pair_info->id2dep))
	    && (0 ==        strcmp(id2dep_wt, uc->seg_pair_info->id2dep_wt))
	) {
	  const int old_prio = ((UCDICT_PRIORITY_MINUS & uc->value) ? -1 : +1) * (UCDICT_PRIORITY_VALUE & uc->value);
	  const int new_prio = ((UCDICT_PRIORITY_MINUS & flag) ? -1 : +1) * (UCDICT_PRIORITY_VALUE & flag);
	  if (old_prio < new_prio) {
	    uc->value = (~UCDICT_PRIORITY & uc->value) | (UCDICT_PRIORITY & flag);
	  }
	  return 0;
	} else {
	  ret = uc->line_number;
	}
      }
    }
  }
  if (0 == ret) {
    struct uc_seg_pair* sp;
    uc = (struct use_case*) malloc( sizeof(struct use_case) );
    sp = (struct uc_seg_pair*) malloc( sizeof(struct uc_seg_pair) );
    if ((NULL == uc) || (NULL == sp)) {
      fprintf(stderr,"Out of memory." );
      abort();
    }
    sp->id1indep_yomi = (NULL != id1indep_yomi) ? anthy_xstr_dup( id1indep_yomi ) : NULL;
    sp->id1indep_cand = (NULL != id1indep_cand) ? anthy_xstr_dup( id1indep_cand ) : NULL;
    sp->id1indep_wt   = (NULL != id1indep_wt  ) ?         strdup( id1indep_wt   ) : NULL;
    sp->id1dep        = (NULL != id1dep       ) ? anthy_xstr_dup( id1dep        ) : NULL;
    sp->id1dep_wt     = (NULL != id1dep_wt    ) ?         strdup( id1dep_wt     ) : NULL;
    sp->id2indep_yomi = (NULL != id2indep_yomi) ? anthy_xstr_dup( id2indep_yomi ) : NULL;
    sp->id2indep_cand = (NULL != id2indep_cand) ? anthy_xstr_dup( id2indep_cand ) : NULL;
    sp->id2indep_wt   = (NULL != id2indep_wt  ) ?         strdup( id2indep_wt   ) : NULL;
    sp->id2dep        = (NULL != id2dep       ) ? anthy_xstr_dup( id2dep        ) : NULL;
    sp->id2dep_wt     = (NULL != id2dep_wt    ) ?         strdup( id2dep_wt     ) : NULL;
    uc->monopolize  = monopolize;
    uc->line_number = line_no;
    uc->seg_pair_info = sp;
    uc->id[0] = id1;
    uc->id[1] = id2;
    uc->value = flag;
    uc->next  = ucdic->head;
    ucdic->head = uc;
    ++ ucdic->nr;
  }
  return ret;
}


/** ñ줬˺ܤäƤ뤫
 *@param[in]		dic			ǡ
 *@param[in]		yomi			ɤ߲̾
 *@param[in]		cand			Ѵ
 *@param[in]		wt			ʻ
 *@retval		0			̵
 *@retval		!= 0			ͭ
 *
 *@comment
 *	Patched by G-HAL
 *	Sat,31 Oct,2009
 */
static int find_word_on_dic( const struct yomi_entry_list* const dic, const xstr* const yomi, const xstr* const cand, const char* const wt )
{
  const struct yomi_entry* const ye = find_yomi_entry( dic, yomi, 0 );
  int i;
  const char* cand_utf8;
  int ret = 0;
  assert( dic );
  assert( yomi );
  assert( cand );
  assert( wt );
  if (NULL == ye) {
    return 0;
  }
 #if !defined(USE_ICONV)
  cand_utf8 = ucs4_xstr_to_utf8( cand );
 #else
  cand_utf8 = anthy_xstr_to_cstr( cand, ANTHY_UTF8_ENCODING );
 #endif
  for (i = 0; i < ye->nr_entries; ++i) {
    const struct word_entry* const we = &(ye->entries[i]);
    if ((0 == strcmp(cand_utf8, we->word_utf8)) && (0 == strcmp(wt, we->wt_name))) {
      ret = 1;
      break;
    }
  }
  free( cand_utf8 );
  return ret;
}


/** 㼭ɤ߹ǥХʥ꼭Ѵ
 *@param[in,out]	ucdic			ΥХʥ꼭δ¤
 *@param[in]		fp			ɤ߹㼭ե
 *@param		input_encoding		ɤ߹եʸ󥳡ǥ
 *@retval		0			ｪλ
 *@retval		!= 0			۾ｪλ
 *
 *@comment
 *	Patched by G-HAL
 *	Sat,17 Oct,2009 - Tue,20 Oct,2009
 *	Sat,31 Oct,2009 - Sun,01 Nov,2009
 *	Sat,07 Nov,2009
 *	Fri,13 Nov,2009 - Sat,14 Nov,2009
 */
# if !defined(USE_ICONV)
int parse_ucdic_file( struct uc_dict* const ucdic, FILE* const fp, int input_encoding )
# else
int parse_ucdic_file( struct uc_dict* const ucdic, FILE* const fp, enum ANTHY_ENCODING input_encoding )
# endif
{
  int	line_number = 0;	/* ιֹ桧顼ɽ */
  char	buf[BUF_LEN];
  char	buf_bak[BUF_LEN];
  char*	ptr;

  while (fgets(buf, sizeof(buf), fp)) {
    ++line_number;

    chomp_eol( buf );
    strlcpy( buf_bak, buf, sizeof(buf_bak) );
    ptr = skip_space( buf );
    if ('#' == (*ptr)) {
      continue;
    }
    { /* ԥѡ */
      enum UC_TOKEN_TYPE {
	SEG1_YOMI_INDEP,
	SEG1_YOMI_DEP  ,
	SEG2_YOMI_INDEP,
	SEG2_YOMI_DEP  ,
	SEG1_CAND_INDEP,
	SEG1_CAND_DEP  ,
	SEG2_CAND_INDEP,
	SEG2_CAND_DEP  ,
	SEG1_WT_INDEP  ,
	SEG1_WT_DEP    ,
	SEG2_WT_INDEP  ,
	SEG2_WT_DEP    ,
	UC_TOKEN_TYPE_MAX
      };
      enum UC_WT_TYPE {
	SEG1_WT,
	SEG2_WT,
	SEG1_WT_H,
	SEG2_WT_H,
	SEG1_WT_C,
	SEG2_WT_C,
	SEG1_WT_S,
	SEG2_WT_S,
	UC_WT_TYPE_MAX
      };
      char* const	flag_str = get_token( ptr, &ptr );
      char* const	prio = get_token( ptr, &ptr );
      char*		tokens[UC_TOKEN_TYPE_MAX];
      xstr*		xsa[UC_TOKEN_TYPE_MAX];
      char*		wt[UC_WT_TYPE_MAX];
      int		check_word_1;
      int		check_word_2;
      int		flag_base = 0;
      int		flag;
      ssize_t		i;
      for (i = 0; i < UC_TOKEN_TYPE_MAX; ++i) {
	tokens[i] = get_token( ptr, &ptr );
      }
      if (NULL == tokens[SEG2_WT_DEP]) {
	fprintf(stderr, "ucdict:%d: Illigal line:%s\n", line_number, buf_bak );
	continue;
      }

      wt[SEG1_WT] = (0 == strcmp(UC_WT_WILDCARD,tokens[SEG1_WT_INDEP])) ? UC_WT_WILDCARD : get_wt_name( tokens[SEG1_WT_INDEP] );
      wt[SEG2_WT] = (0 == strcmp(UC_WT_WILDCARD,tokens[SEG2_WT_INDEP])) ? UC_WT_WILDCARD : get_wt_name( tokens[SEG2_WT_INDEP] );

      if (0 == strcmp(UC_WT_WILDCARD,tokens[SEG1_WT_DEP])) {
	wt[SEG1_WT_H] = UC_WT_WILDCARD;
	wt[SEG1_WT_C] = UC_WT_WILDCARD;
	wt[SEG1_WT_S] = UC_WT_WILDCARD;
      } else {
	char* wt_ptr = tokens[SEG1_WT_DEP];

	wt[SEG1_WT_H] = strchr( wt_ptr, UCDICT_WT_H_KEY );
	if (wt[SEG1_WT_H]) {
	  *(wt[SEG1_WT_H]) = '\0';
	  ++ wt[SEG1_WT_H];
	  wt_ptr = wt[SEG1_WT_H];
	} else {
	  wt[SEG1_WT_H] = UC_WT_WILDCARD;
	}

	wt[SEG1_WT_C] = strchr( wt_ptr, UCDICT_WT_C_KEY );
	if (wt[SEG1_WT_C]) {
	  *(wt[SEG1_WT_C]) = '\0';
	  ++ wt[SEG1_WT_C];
	  wt_ptr = wt[SEG1_WT_C];
	} else {
	  wt[SEG1_WT_C] = UC_WT_WILDCARD;
	}

	wt[SEG1_WT_S] = strchr( wt_ptr, UCDICT_WT_S_KEY );
	if (wt[SEG1_WT_S]) {
	  *(wt[SEG1_WT_S]) = '\0';
	  ++ wt[SEG1_WT_S];
	  wt_ptr = wt[SEG1_WT_S];
	} else {
	  wt[SEG1_WT_S] = UC_WT_WILDCARD;
	}

	if (('\0' == *(wt[SEG1_WT_H])) || (0 == strcmp(UC_WT_WILDCARD,wt[SEG1_WT_H]))) {
	  wt[SEG1_WT_H] = UC_WT_WILDCARD;
	}
	if (('\0' == *(wt[SEG1_WT_C])) || (0 == strcmp(UC_WT_WILDCARD,wt[SEG1_WT_C]))) {
	  wt[SEG1_WT_C] = UC_WT_WILDCARD;
	}
	if (('\0' == *(wt[SEG1_WT_S])) || (0 == strcmp(UC_WT_WILDCARD,wt[SEG1_WT_S]))) {
	  wt[SEG1_WT_S] = UC_WT_WILDCARD;
	}
      }

      if (0 == strcmp(UC_WT_WILDCARD,tokens[SEG2_WT_DEP])) {
	wt[SEG2_WT_H] = UC_WT_WILDCARD;
	wt[SEG2_WT_C] = UC_WT_WILDCARD;
	wt[SEG2_WT_S] = UC_WT_WILDCARD;
      } else {
	char* wt_ptr = tokens[SEG2_WT_DEP];

	wt[SEG2_WT_H] = strchr( wt_ptr, UCDICT_WT_H_KEY );
	if (wt[SEG2_WT_H]) {
	  *(wt[SEG2_WT_H]) = '\0';
	  ++ wt[SEG2_WT_H];
	  wt_ptr = wt[SEG2_WT_H];
	} else {
	  wt[SEG2_WT_H] = UC_WT_WILDCARD;
	}

	wt[SEG2_WT_C] = strchr( wt_ptr, UCDICT_WT_C_KEY );
	if (wt[SEG2_WT_C]) {
	  *(wt[SEG2_WT_C]) = '\0';
	  ++ wt[SEG2_WT_C];
	  wt_ptr = wt[SEG2_WT_C];
	} else {
	  wt[SEG2_WT_C] = UC_WT_WILDCARD;
	}

	wt[SEG2_WT_S] = strchr( wt_ptr, UCDICT_WT_S_KEY );
	if (wt[SEG2_WT_S]) {
	  *(wt[SEG2_WT_S]) = '\0';
	  ++ wt[SEG2_WT_S];
	  wt_ptr = wt[SEG2_WT_S];
	} else {
	  wt[SEG2_WT_S] = UC_WT_WILDCARD;
	}

	if (('\0' == *(wt[SEG2_WT_H])) || (0 == strcmp(UC_WT_WILDCARD,wt[SEG2_WT_H]))) {
	  wt[SEG2_WT_H] = UC_WT_WILDCARD;
	}
	if (('\0' == *(wt[SEG2_WT_C])) || (0 == strcmp(UC_WT_WILDCARD,wt[SEG2_WT_C]))) {
	  wt[SEG2_WT_C] = UC_WT_WILDCARD;
	}
	if (('\0' == *(wt[SEG2_WT_S])) || (0 == strcmp(UC_WT_WILDCARD,wt[SEG2_WT_S]))) {
	  wt[SEG2_WT_S] = UC_WT_WILDCARD;
	}
      }

     #if defined(DEBUG) && (3 <= DEBUG)
      printf("%d:%s:%s:%s,%s,%s,%s:%s,%s,%s,%s:%s,%s,%s,%s\n",
	     line_number,
	     flag_str, prio,
	     tokens[SEG1_YOMI_INDEP], tokens[SEG1_YOMI_DEP],
	     tokens[SEG2_YOMI_INDEP], tokens[SEG2_YOMI_DEP],
	     tokens[SEG1_CAND_INDEP], tokens[SEG1_CAND_DEP],
	     tokens[SEG2_CAND_INDEP], tokens[SEG2_CAND_DEP],
	     wt[SEG1_WT], tokens[SEG1_WT_DEP],
	     wt[SEG2_WT], tokens[SEG2_WT_DEP]
	     );
     #endif

      /* ѷѴ */
      { int value = atoi( prio );
	if (value < 0) {
	  flag_base |= UCDICT_PRIORITY_MINUS;
	  value = - value;
	}
	if (value < UC_PRIO_MIN) {
	  value = UC_PRIO_MIN;
	} else if (UC_PRIO_MAX < value) {
	  value = UC_PRIO_MAX;
	}
	flag_base |= (UCDICT_PRIORITY_VALUE & value);
      }
      { const char* flag_ptr = flag_str;
	for (; '\0' != *flag_ptr; ++flag_ptr) {
	  switch (*flag_ptr) {
	  case '_':	break;
	  case 'n':	flag_base |= UCDICT_NEIGHBOR_ONLY;	break;
	  default:
			fprintf(stderr,"ucdict:%d: Illigal flag(s).:%s\n", line_number, buf_bak );
			break;
	  }
	}
      }

      for (i = 0; i < UC_TOKEN_TYPE_MAX; ++i) {
	xsa[i] = anthy_cstr_to_xstr( tokens[i], input_encoding );
      }

      check_word_1 = (UC_WT_WILDCARD == wt[SEG1_WT]) ? 1 : find_word_on_dic( ucdic->dic_entry, xsa[SEG1_YOMI_INDEP], xsa[SEG1_CAND_INDEP], wt[SEG1_WT] );
      check_word_2 = (UC_WT_WILDCARD == wt[SEG2_WT]) ? 1 : find_word_on_dic( ucdic->dic_entry, xsa[SEG2_YOMI_INDEP], xsa[SEG2_CAND_INDEP], wt[SEG2_WT] );
      if (check_word_1 && check_word_2) {
	/* ڥ */
	const int seg2_null          = (0 == strcmp( UC_INDEP_WILDCARD, tokens[SEG2_YOMI_INDEP] ));
	const int seg1_no_dep        = (0 == strcmp( UC_DEP_BLANKMARK, tokens[SEG1_YOMI_DEP] ));
	const int seg2_no_dep        = (0 == strcmp( UC_DEP_BLANKMARK, tokens[SEG2_YOMI_DEP] ));
	const int seg1_wildcard_dep  = (0 == strcmp( UC_DEP_WILDCARD,  tokens[SEG1_YOMI_DEP] ));
	const int seg2_wildcard_dep  = (0 == strcmp( UC_DEP_WILDCARD,  tokens[SEG2_YOMI_DEP] ));
	const int seg1_have_dep      = (!seg1_no_dep && !seg1_wildcard_dep);
	const int seg2_have_dep      = (!seg2_no_dep && !seg2_wildcard_dep);
	const int seg1_wildcard_wt   = (UC_WT_WILDCARD == wt[SEG1_WT]);
	const int seg2_wildcard_wt   = (UC_WT_WILDCARD == wt[SEG2_WT]);
	const int seg1_wildcard_wt_h = (UC_WT_WILDCARD == wt[SEG1_WT_H]);
	const int seg2_wildcard_wt_h = (UC_WT_WILDCARD == wt[SEG2_WT_H]);
	const int seg1_wildcard_wt_c = (UC_WT_WILDCARD == wt[SEG1_WT_C]);
	const int seg2_wildcard_wt_c = (UC_WT_WILDCARD == wt[SEG2_WT_C]);
	const int seg1_wildcard_wt_s = (UC_WT_WILDCARD == wt[SEG1_WT_S]);
	const int seg2_wildcard_wt_s = (UC_WT_WILDCARD == wt[SEG2_WT_S]);
	const uint32_t id_seg1_yomi     = anthy_hash_uint32_update( anthy_hash_xstr_start( xsa[SEG1_YOMI_INDEP] ), '\0' );
	const uint32_t id_seg2_yomi     = anthy_hash_uint32_update( anthy_hash_xstr_start( xsa[SEG2_YOMI_INDEP] ), '\0' );
	const uint32_t id_seg1_base     = anthy_hash_uint32_update( anthy_hash_xstr_update( id_seg1_yomi, xsa[SEG1_CAND_INDEP] ), '\0' );
	const uint32_t id_seg2_base     = anthy_hash_uint32_update( anthy_hash_xstr_update( id_seg2_yomi, xsa[SEG2_CAND_INDEP] ), '\0' );
	const uint32_t id_seg1_Wdep     = anthy_hash_uint32_update( seg1_have_dep ? anthy_hash_xstr_update( id_seg1_base, xsa[SEG1_YOMI_DEP] ) : id_seg1_base, '\0' );
	const uint32_t id_seg2_Wdep     = anthy_hash_uint32_update( seg2_have_dep ? anthy_hash_xstr_update( id_seg2_base, xsa[SEG2_YOMI_DEP] ) : id_seg2_base, '\0' );
	const uint32_t id_seg1_WdepWwt  = anthy_hash_uint8_update( seg1_wildcard_wt ? id_seg1_Wdep : anthy_hash_str_update( id_seg1_Wdep, wt[SEG1_WT] ), '\0' );
	const uint32_t id_seg2_WdepWwt  = anthy_hash_uint8_update( seg2_wildcard_wt ? id_seg2_Wdep : anthy_hash_str_update( id_seg2_Wdep, wt[SEG2_WT] ), '\0' );
	const uint32_t id_seg1_WdepWwtH = anthy_hash_uint8_update( seg1_wildcard_wt_h ? id_seg1_WdepWwt  : anthy_hash_str_update( id_seg1_WdepWwt , wt[SEG1_WT_H] ), '\0' );
	const uint32_t id_seg2_WdepWwtH = anthy_hash_uint8_update( seg2_wildcard_wt_h ? id_seg2_WdepWwt  : anthy_hash_str_update( id_seg2_WdepWwt , wt[SEG2_WT_H] ), '\0' );
	const uint32_t id_seg1_WdepWwtC = anthy_hash_uint8_update( seg1_wildcard_wt_c ? id_seg1_WdepWwtH : anthy_hash_str_update( id_seg1_WdepWwtH, wt[SEG1_WT_C] ), '\0' );
	const uint32_t id_seg2_WdepWwtC = anthy_hash_uint8_update( seg2_wildcard_wt_c ? id_seg2_WdepWwtH : anthy_hash_str_update( id_seg2_WdepWwtH, wt[SEG2_WT_C] ), '\0' );
	const uint32_t id_seg1_WdepWwtS = anthy_hash_uint8_update( seg1_wildcard_wt_s ? id_seg1_WdepWwtC : anthy_hash_str_update( id_seg1_WdepWwtC, wt[SEG1_WT_S] ), '\0' );
	const uint32_t id_seg2_WdepWwtS = anthy_hash_uint8_update( seg2_wildcard_wt_s ? id_seg2_WdepWwtC : anthy_hash_str_update( id_seg2_WdepWwtC, wt[SEG2_WT_S] ), '\0' );
	const uint32_t id_seg1_extended = id_seg1_WdepWwtS;
	const uint32_t id_seg2_extended = id_seg2_WdepWwtS;
	const int have_extended_pair = (seg1_have_dep || seg2_have_dep
					|| !seg1_wildcard_wt || !seg2_wildcard_wt
					|| !seg1_wildcard_wt_h || !seg2_wildcard_wt_h
					|| !seg1_wildcard_wt_c || !seg2_wildcard_wt_c
					|| !seg1_wildcard_wt_s || !seg2_wildcard_wt_s
					);
	int ret;

	if (have_extended_pair) {
	  /* ĥڥ */
	  flag = flag_base
	      | (seg1_have_dep      ? UCDICT_SEG1_LEAF_HAVE_DEP : 0)
	      | (seg2_have_dep      ? UCDICT_SEG2_LEAF_HAVE_DEP : 0)
	      | (seg1_wildcard_wt   ? 0 : UCDICT_SEG1_NODE_HAVE_WT)
	      | (seg2_wildcard_wt   ? 0 : UCDICT_SEG2_NODE_HAVE_WT)
	      | (seg1_wildcard_wt_h ? 0 : UCDICT_SEG1_NODE_HAVE_WT_H)
	      | (seg2_wildcard_wt_h ? 0 : UCDICT_SEG2_NODE_HAVE_WT_H)
	      | (seg1_wildcard_wt_c ? 0 : UCDICT_SEG1_NODE_HAVE_WT_C)
	      | (seg2_wildcard_wt_c ? 0 : UCDICT_SEG2_NODE_HAVE_WT_C)
	      | (seg1_wildcard_wt_s ? 0 : UCDICT_SEG1_NODE_HAVE_WT_S)
	      | (seg2_wildcard_wt_s ? 0 : UCDICT_SEG2_NODE_HAVE_WT_S)
	      ;
	  if (!seg2_null) {
	    ret = commit_uc( ucdic,
			    anthy_hash_finalize(id_seg1_extended), anthy_hash_finalize(id_seg2_extended),
			    flag, 1,
			    xsa[SEG1_YOMI_INDEP], xsa[SEG1_CAND_INDEP], wt[SEG1_WT], xsa[SEG1_YOMI_DEP], tokens[SEG1_WT_DEP],
			    xsa[SEG2_YOMI_INDEP], xsa[SEG2_CAND_INDEP], wt[SEG2_WT], xsa[SEG2_YOMI_DEP], tokens[SEG2_WT_DEP],
			    line_number );
	  } else {
	    ret = commit_uc( ucdic,
			    anthy_hash_finalize(id_seg1_extended), 0,
			    flag, 1,
			    xsa[SEG1_YOMI_INDEP], xsa[SEG1_CAND_INDEP], wt[SEG1_WT], xsa[SEG1_YOMI_DEP], tokens[SEG1_WT_DEP],
			    NULL, NULL, UC_WT_NULL, NULL, UC_WT_NULL,
			    line_number );
	  }
	  if (ret) {
	    fprintf(stderr,"ucdict:%d: A hash conflicted at extended pair. (Previous:%d):%s\n", line_number, ret, buf_bak );
	  }
	}
	{ /* ܥڥ */
	  flag = flag_base
	      | (seg1_wildcard_dep  ? UCDICT_SEG1_NODE_WILDCARD_DEP : 0)
	      | (seg2_wildcard_dep  ? UCDICT_SEG2_NODE_WILDCARD_DEP : 0)
	      | (seg1_no_dep        ? UCDICT_SEG1_NODE_NO_DEP       : 0)
	      | (seg2_no_dep        ? UCDICT_SEG2_NODE_NO_DEP       : 0)
	      | (seg1_have_dep      ? UCDICT_SEG1_NODE_HAVE_DEP     : 0)
	      | (seg2_have_dep      ? UCDICT_SEG2_NODE_HAVE_DEP     : 0)
	      | (seg1_wildcard_wt   ? 0 : UCDICT_SEG1_NODE_HAVE_WT)
	      | (seg2_wildcard_wt   ? 0 : UCDICT_SEG2_NODE_HAVE_WT)
	      | (seg1_wildcard_wt_h ? 0 : UCDICT_SEG1_NODE_HAVE_WT_H)
	      | (seg2_wildcard_wt_h ? 0 : UCDICT_SEG2_NODE_HAVE_WT_H)
	      | (seg1_wildcard_wt_c ? 0 : UCDICT_SEG1_NODE_HAVE_WT_C)
	      | (seg2_wildcard_wt_c ? 0 : UCDICT_SEG2_NODE_HAVE_WT_C)
	      | (seg1_wildcard_wt_s ? 0 : UCDICT_SEG1_NODE_HAVE_WT_S)
	      | (seg2_wildcard_wt_s ? 0 : UCDICT_SEG2_NODE_HAVE_WT_S)
	      ;
	  if (!seg2_null) {
	    ret = commit_uc( ucdic,
			    anthy_hash_finalize(id_seg1_base), anthy_hash_finalize(id_seg2_base),
			    flag, !have_extended_pair,
			    xsa[SEG1_YOMI_INDEP], xsa[SEG1_CAND_INDEP], UC_WT_NULL, NULL, UC_WT_NULL,
			    xsa[SEG2_YOMI_INDEP], xsa[SEG2_CAND_INDEP], UC_WT_NULL, NULL, UC_WT_NULL,
			    line_number );
	  } else {
	    ret = commit_uc( ucdic,
			    anthy_hash_finalize(id_seg1_base), 0,
			    flag, !have_extended_pair,
			    xsa[SEG1_YOMI_INDEP], xsa[SEG1_CAND_INDEP], UC_WT_NULL, NULL, UC_WT_NULL,
			    NULL, NULL, UC_WT_NULL, NULL, UC_WT_NULL,
			    line_number );
	  }
	}
	if (ret) {
	  fprintf(stderr,"ucdict:%d: A hash or a flag conflicted. (Previous:%d):%s\n", line_number, ret, buf_bak );
	}

      } else {

	if (!check_word_1) {
	  fprintf(stderr, "ucdict:%d: A 1st word is not found:%s %s %s\n", line_number, tokens[SEG1_YOMI_INDEP], tokens[SEG1_WT_INDEP], tokens[SEG1_CAND_INDEP] );
	}
	if (!check_word_2) {
	  fprintf(stderr, "ucdict:%d: A 2nd word is not found:%s %s %s\n", line_number, tokens[SEG2_YOMI_INDEP], tokens[SEG2_WT_INDEP], tokens[SEG2_CAND_INDEP] );
	}
      }

      for (i = (UC_TOKEN_TYPE_MAX - 1); 0 <= i; --i) {
	anthy_free_xstr( xsa[i] );
      }
    }
  }
  return 0;
}


/** ΥХʥ꼭ե¸
 *@param[in,out]	out			¸ե
 *@param[in,out]	ucdic			ΥХʥ꼭δ¤
 *
 *@note
 *	δؿνƤϸǤΤޤޡ
 *
 *@comment
 *	Patched by G-HAL
 *	Sat,17 Oct,2009 - Sun,18 Oct,2009
 */
void write_ucdic( FILE* const out, const struct uc_dict* const ucdic )
{
  struct sparse_matrix* sm = anthy_sparse_matrix_new();
  if (NULL == sm) {
    fprintf(stderr,"Out of memory." );
    abort();
  }

  { /* ¹˵ͤ */
    if (ucdic && (1 <= ucdic->nr)) {
      const struct use_case* uc;
      printf("ucdic: %d data are processed.\n", ucdic->nr );
      for (uc = ucdic->head; uc; uc = uc->next) {
	anthy_sparse_matrix_set( sm, uc->id[0], uc->id[1], uc->value, NULL );
      }
    } else {
      printf("ucdic: No data.\n" );
    }
  }

  anthy_sparse_matrix_make_matrix( sm );

  { /* ¹Υ᡼ƥե˽񤭽Ф */
    const struct matrix_image* const mi = anthy_matrix_image_new( sm );
    int i;
    if (NULL == mi) {
      fprintf(stderr,"Out of memory." );
      abort();
    }
    for (i = 0; i < mi->size; ++i) {
      write_nl( out, mi->image[i] );
    }
  }

  return;
}


/** ΥХʥ꼭ν
 *@param[in]		dic			Ѥμǡ
 *@return					ΥХʥ꼭
 *
 *@comment
 *	Patched by G-HAL
 *	Sat,17 Oct,2009 - Sun,18 Oct,2009
 *	Sat,31 Oct,2009
 */
struct uc_dict* const init_ucdic( const struct yomi_entry_list* const dic )
{
  struct uc_dict* const ucdic = (struct uc_dict*) malloc( sizeof(struct uc_dict) );
  ucdic->nr   = 0;
  ucdic->head = NULL;
  ucdic->dic_entry = dic;
  return ucdic;
}

#endif
/* [ End of File ] */
/* vim:ts=8 sw=2 nomodified:
 */
