/**@file
 *			Patches for Anthy, by G-HAL
 *@brief	mergesort شؿ
 *@date		Sun,02 Nov,2008
 *@date		Thu,14 Oct,2010
 *@author	Copyright(C)2008-2010 G-HAL
 */
#ifndef __ALTERNATIVE_MERGESORT_H__
#define __ALTERNATIVE_MERGESORT_H__

#if defined(HAVE_CONFIG_H)
# include "config.h"
#endif

#if defined(HAVE_SYS_TYPES_H)
# include <sys/types.h>
#endif


#if (!defined(HAVE_MERGESORT) && defined(HAVE_CONFIG_H))
# if defined(HAVE_ALTERNATIVE_MERGESORT)
#  if defined(HAVE_STDDEF_H)
#   include <stddef.h>
#  endif
#  ifdef __cplusplus
extern "C" {
#  endif
extern int mergesort(void *base, size_t nmemb, size_t size, int (*cmp)(const void *, const void *));
#  ifdef __cplusplus
}
#  endif
#  define	ENABLE_ALTERNATIVE_MERGESORT
# else
#  error("A function mergesort() or alternative function is required.")
# endif
#endif


#endif /* __ALTERNATIVE_MERGESORT_H__ */
/* [ End of File ] */
/* vim:ts=4 sw=4 nomodified:
 */
