/*
 * AnthyǻȤʸν
 *  typedef struct xstr_ {
 *    xstr *str; int len;
 *  } xstr;
 *
 * malloc(0);ΰ̣Ϲͤʤ0ʸʸ򰷤褦
 * ǥ󥰤򤹤롣free(0)ɤ
 *
 * ǥեȤǤ
 *  cstrC̤EUCʸ
 *
 * Copyright (C) 2000-2007 TABATA Yusuke
 *
 */
/*
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */
#if 0		/* Patched by G-HAL */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "config.h"
/* for ANTHY_*_ENCODING */
#include <anthy/anthy.h>

#include <anthy/xstr.h>
#include <anthy/xchar.h>
#include "diclib_inner.h"
#else
#if defined(HAVE_CONFIG_H)
# include "config.h"
#endif

#if defined(HAVE_STDLIB_H)
# include <stdlib.h>
#endif
#if defined(HAVE_MALLOC_H)
# include <malloc.h>
#endif
#if defined(HAVE_STDIO_H)
# include <stdio.h>
#endif
#if defined(HAVE_STRING_H)
# include <string.h>
#endif
#if defined(HAVE_STRINGS_H)
# include <strings.h>
#endif
#if defined(HAVE_LIMITS_H)
# include <limits.h>
#endif
#if defined(HAVE_SYS_LIMITS_H)
# include <sys/limits.h>
#endif
#if !defined(__STDC_LIMIT_MACROS)
# define __STDC_LIMIT_MACROS
#endif
#if !defined(__STDC_CONSTANT_MACROS)
# define __STDC_CONSTANT_MACROS
#endif
#if defined(HAVE_STDINT_H)
# include <stdint.h>
#endif
#if !defined(__STDC_FORMAT_MACROS)
# define __STDC_FORMAT_MACROS
#endif
#if defined(HAVE_INTTYPES_H)
# include <inttypes.h>
#endif
#if defined(HAVE_SYS_TYPES_H)
# include <sys/types.h>
#endif
#if defined(HAVE_ASSERT_H)
# include <assert.h>
#endif
#if defined(HAVE_ALLOCA_H)	/* Patched by G-HAL, Wed,13 Oct,2010 */
# include <alloca.h>
#elif defined(HAVE_ALLOCA)
#else
# error	"alloca() was not found."
#endif

#include "anthy/anthy.h"
#include "anthy/logger.h"	/* Patched by G-HAL, Mon,25 May,2009 */
#include "anthy/xstr.h"
#include "anthy/xchar.h"
#include "diclib_inner.h"
#include "anthy_hash.h"		/* Patched by G-HAL, Fri,30 Jan,2009 */
#endif

#if !defined(USE_ICONV)	/* Patched by G-HAL, Mon,25 May,2009 */
/* ̤˽ϤȤΥ󥳡ǥ */
static int print_encoding;
#else
/** ̤˽ϤȤΥ󥳡ǥ */
static enum ANTHY_ENCODING print_encoding;
#endif

#if 0	/* Patched by G-HAL, Sun,07 Jun,2009 */
#define MAX_BYTES_PER_XCHAR 10
#endif

#if !defined(USE_ICONV)	/* Patched by G-HAL, Mon,25 May,2009 */
static int
xc_isprint(xchar xc)
{
  return xc > 0;
}

/** CʸбxstrĹ׻
 */
static int
xlengthofcstr(const char *c)
{
  int ll = 0;
  int len = strlen(c);
  int i;
  for (i = 0; i < len; i++) {
    ll ++;
    if ((c[i] & UINT8_C(0x80))) {
      i++;
    }
  }
  return ll;
}

const char *
anthy_utf8_to_ucs4_xchar(const char *s, xchar *res)
{
  const unsigned char *str = (const unsigned char *)s;
  int i, len;
  xchar cur;
  cur = str[0];
  if (str[0] < UINT8_C(0x80)) {
    len = 1;
  } else if (str[0] < UINT8_C(0xe0)) {
    cur &= UINT8_C(0x1f);
    len = 2;
  } else if (str[0] < UINT8_C(0xf0)) {
    cur &= UINT8_C(0x0f);
    len = 3;
  } else if (str[0] < UINT8_C(0xf8)) {
    cur &= UINT8_C(0x07);
    len = 4;
  } else if (str[0] < UINT8_C(0xfc)) {
    cur &= UINT8_C(0x03);
    len = 5;
  } else {
    cur &= UINT8_C(0x01);
    len = 6;
  }
  str ++;
  for (i = 1; i < len; i++) {
    cur <<= 6;
    cur |= (str[0] & UINT8_C(0x3f));
    str++;
  }
  *res = cur;
  return (const char *)str;
}

static xstr *
utf8_to_ucs4_xstr(const char *s)
{
  const unsigned char *str = (const unsigned char *)s;
  xstr res;
  res.str = (xchar *)alloca(sizeof(xchar) * strlen(s));
  res.len = 0;

  while (*str) {
    xchar cur;
    str = (const unsigned char *)anthy_utf8_to_ucs4_xchar((const char *)str,
							  &cur);
    res.str[res.len] = cur;
    res.len ++;
  }
  return anthy_xstr_dup(&res);
}

static int
put_xchar_to_utf8_str(xchar xc, char *buf_)
{
  int i, len;
  uint8_t* buf = (uint8_t*)buf_;
  if (xc < UINT8_C(0x80)) {
    buf[0] = 0;
    len = 1;
  } else if (xc < UINT16_C(0x800)) {
    buf[0] = UINT8_C(0xc0);
    len = 2;
  } else if (xc < UINT32_C(0x10000)) {
    buf[0] = UINT8_C(0xe0);
    len = 3;
  } else if (xc < UINT32_C(0x200000)) {
    buf[0] = UINT8_C(0xf0);
    len = 4;
  } else if (xc < UINT32_C(0x400000)) {
    buf[0] = UINT8_C(0xf8);
    len = 5;
  } else {
    buf[0] = UINT8_C(0xfc);
    len = 6;
  }
  for (i = len - 1; i > 0; i--) {
    buf[i] = (xc & UINT8_C(0x3f)) | UINT8_C(0x80);
    xc >>= 6;
  }
  buf[0] += xc;
  buf[len] = UINT8_C(0);
  return len;
}

static char *
ucs4_xstr_to_utf8(xstr *xs)
{
  char *buf = (char*) alloca(xs->len * 6 + 1);
  int i, t = 0;
  buf[0] = 0;
  for (i = 0; i < xs->len; i++) {
    xchar xc = xs->str[i];
    put_xchar_to_utf8_str(xc, &buf[t]);
    t = strlen(buf);
  }
  return strdup(buf);
}

/** Cʸxstrѹ
 */
xstr *
anthy_cstr_to_xstr(const char *c, int encoding)
{
  xstr *x;
  int i, j, l;
  if (encoding == ANTHY_UTF8_ENCODING) {
    return utf8_to_ucs4_xstr(c);
  }
  l = xlengthofcstr(c);
  x = (xstr *)malloc(sizeof(struct xstr_));
  if (!x) {
    return NULL;
  }
  x->len = l;
  x->str = (xchar*) malloc(sizeof(xchar)*l);
  for (i = 0, j = 0; i < l; i++) {
    if (!(c[j] & UINT8_C(0x80))){
      x->str[i] = c[j];
      j++;
    } else {
      const unsigned char* const p = (const unsigned char*)&c[j];
      x->str[i] = (p[1] | (p[0]<<8)) | UINT16_C(0x8080);
      x->str[i] = anthy_euc_to_ucs(x->str[i]);
      j++;
      j++;
    }
  }
  return x;
}

char *
anthy_xstr_to_cstr(xstr *s, int encoding)
{
  int i, j, l;
  char *p;

  if (encoding == ANTHY_UTF8_ENCODING) {
    return ucs4_xstr_to_utf8(s);
  }

  l = s->len;
  for (i = 0; i < s->len; i++) {
    int ec = anthy_ucs_to_euc(s->str[i]);
    if (ec > 255) {
      l++;
    }
  }
  p = (char *)malloc(l + 1);
  p[l] = 0;
  j = 0;
  for (i =  0; i < s->len; i++) {
    int ec = anthy_ucs_to_euc(s->str[i]);
    if (ec < 256) {
      p[j] = ec;
      j++;
    }else{
      p[j] = ec >> 8;
      j++;
      p[j] = ec & UINT8_C(255);
      j++;
    }
  }
  return p;
}
#endif

#if 0	/* Patched by G-HAL, Tue,20 Oct,2009 */
xstr *
anthy_xstr_dup(xstr *s)
#else
xstr* anthy_xstr_dup( const xstr* const s )
#endif
{
  int i;
  xstr *x = (xstr *)malloc(sizeof(xstr));
  x->len = s->len;
  if (s->len) {
    x->str = (xchar*) malloc(sizeof(xchar)*s->len);
  }else{
    x->str = NULL;
  }
  for (i = 0; i < x->len; i++) {
    x->str[i] = s->str[i];
  }
  return x;
}

xchar *
anthy_xstr_dup_str( const xstr* const s )
{
  xchar *c;
  int i;
  if (s->len) {
    c = (xchar*) malloc(sizeof(xchar)*s->len);
  }else{
    c = NULL;
  }
  for (i = 0; i < s->len; i++) {
    c[i] = s->str[i];
  }
  return c;
}

void
anthy_free_xstr(xstr *x)
{
  if (!x) {
    return ;
  }
  /**/
  free(x->str);
  free(x);
}

void
anthy_free_xstr_str(xstr *x)
{
  if (!x) {
    return ;
  }
  free(x->str);
}

#if !defined(USE_ICONV)	/* Patched by G-HAL, Mon,25 May,2009, Wed,10 Jun,2009 */
int
anthy_sputxchar(char *buf, xchar x, int encoding)
{
  if (!xc_isprint(x)) {
    sprintf(buf, "??");
    return 2;
  }
  if (encoding == ANTHY_UTF8_ENCODING) {
    return put_xchar_to_utf8_str(x, buf);
  }
  x = anthy_ucs_to_euc(x);
  if (x < 256) {
    buf[0] = x;
    buf[1] = 0;
    return 1;
  }
  buf[2] = UINT8_C(0);
  buf[1] = UINT8_C(0x80) | (x & UINT8_C(255));
  buf[0] = UINT8_C(0x80) | ((x>>8) & UINT8_C(255));
  return 2;
}

int
anthy_sputxstr(char *buf, xstr *x, int encoding)
{
  char b[MAX_BYTES_PER_XCHAR];
  int i, l = 0;
  for (i = 0; i < x->len; i++) {
    anthy_sputxchar(b, x->str[i], encoding);
    sprintf(&buf[l], "%s", b);
    l += strlen(b);
  }
 #if 1	/* Patched by G-HAL, Fri,20 Feb,2009 */
  buf[l] = '\x0';
 #endif
  return l;
}

int
anthy_snputxstr(char *buf, int n, xstr *x, int encoding)
{
  char b[MAX_BYTES_PER_XCHAR];
  int i, l=0;
  for (i = 0; i < x->len; i++) {
    anthy_sputxchar(b, x->str[i], encoding);
    if ((int)strlen(b) + l >= n) {
      return l;
    }
    n -= sprintf(&buf[l], "%s", b);
    l += strlen(b);
  }
  return l;
}

void
anthy_putxchar(xchar x)
{
  char buf[MAX_BYTES_PER_XCHAR];
  if (!xc_isprint(x)) {
    printf("\\%x", x);
    return ;
  }
  anthy_sputxchar(buf, x, print_encoding);
  printf("%s", buf);
}

void
anthy_putxstr(xstr *x)
{
  int i;
  for (i = 0; i < x->len; i++) {
    anthy_putxchar(x->str[i]);
  }
}

void
anthy_putxstrln(xstr *x)
{
  anthy_putxstr(x);
  printf("\n");
}
#else
void anthy_putxchar( xchar xc )
{
  const size_t	buf_size = MAX_BYTES_PER_XCHAR * 1 + MAX_BYTES_BASE;
  char* const	buf = alloca( buf_size );
  const xchar	xc_tmp[1] = { xc };
  const xstr	xs = { .len = 1, .str = xc_tmp };
  anthy_snputxstr( buf, buf_size, &xs, print_encoding );
  printf("%s", buf );
  return;
}

void anthy_putxstr( xstr* const xs )
{
  const size_t	buf_size = MAX_BYTES_PER_XCHAR * xs->len + MAX_BYTES_BASE;
  char* const	buf = alloca( buf_size );
  anthy_snputxstr( buf, buf_size, xs, print_encoding );
  printf("%s", buf );
  return;
}

void anthy_putxstrln( xstr* const xs )
{
  const size_t	buf_size = MAX_BYTES_PER_XCHAR * xs->len + MAX_BYTES_BASE;
  char* const	buf = alloca( buf_size );
  anthy_snputxstr( buf, buf_size, xs, print_encoding );
  printf("%s\n", buf );
  return;
}
#endif

xstr*
anthy_xstrcpy(xstr *dest, xstr *src)
{
  int i;
  /* ʸ򥳥ԡ */
  dest->len = src->len;
  for (i = 0; i < src->len; i++) {
    dest->str[i] = src->str[i];
  }

  return dest;
}
/* ֤ͤstrcmpƱ */
int
anthy_xstrcmp(const xstr* const x1, const xstr* const x2)
{
  int i, m;
 #if 1	/* Patched by G-HAL, Mon,25 May,2009 */
  if (NULL == x1) {
    return (NULL == x2) ? 0 : -1;
  } else if (NULL == x2) {
    return 1;
  }
 #endif
  if (x1->len < x2->len) {
    m = x1->len;
  }else{
    m = x2->len;
  }
  for (i = 0 ; i < m ; i++) {
    if (x1->str[i] < x2->str[i]) {
      return -1;
    }
    if (x1->str[i] > x2->str[i]) {
      return 1;
    }
  }
  if (x1->len < x2->len) {
    return -1;
  }
  if (x1->len > x2->len) {
    return 1;
  }
  return 0;
}

/* ֤ͤstrncmpƱ */
int
anthy_xstrncmp(xstr *x1, xstr *x2, int n)
{
  int i, m;
  if (x1->len < x2->len) {
    m = x1->len;
  }else{
    m = x2->len;
  }
  if (m > n) m = n;
  for (i = 0 ; i < m ; i++) {
    if (x1->str[i] < x2->str[i]) {
      return -1;
    }
    if (x1->str[i] > x2->str[i]) {
      return 1;
    }
  }
  if (x2->len <= n && x1->len < x2->len) {
    return -1;
  }
  if (x1->len <= n && x1->len > x2->len) {
    return 1;
  }
  return 0;
}


xstr *
anthy_xstrcat(xstr *s, xstr *a)
{
  int i, l;
  if (!s) {
    s = (xstr*) malloc(sizeof(xstr));
    s->str = NULL;
    s->len = 0;
  }
  l = s->len + a->len;

  if (l < 1) {              /* ⤷ϳؽǡƤк */
    free(s->str);
    s->str = NULL;
    s->len = 0;
    return s;
  }

  s->str = (xchar*) realloc(s->str, sizeof(xchar)*l);
  for (i = 0; i < a->len; i ++) {
    s->str[s->len+i] = a->str[i];
  }
  s->len = l;
  return s;
}

xstr *
anthy_xstrappend(xstr *xs, xchar xc)
{
  xstr p;
  xchar q[1];
  p.len = 1;
  p.str = q;
  q[0] = xc;
  return anthy_xstrcat(xs, &p);
}


#if 0		/* Patched by G-HAL, Fri,12 Jun,2009 */
#else
/** xs  UCS-2 ΤߤǹƤ뤫ݤ򸡺
 *@param[in]		xs			Ƚꤹʸ
 *@retval		0			UCS-2 ǤɽԲǽ
 *@retval		1			UCS-2 ɽǽ
 *
 *@comment
 *	Patched by G-HAL
 *	Mon,20 Oct,2008
 */
int anthy_xstr_is_ucs2( const xstr* const xs )
{
  size_t i;
  const xchar* ptr;
  for (i = 0, ptr = xs->str; i < xs->len; i++, ptr++) {
    if ((~UINT32_C(0xFFFF)) & (*ptr)) {
      return 0;
    }
  }
  return 1;
}


/** ʸ˶̤ʸ
 *@param[in]		xs			Ƚꤹʸ
 *@return					ʸ XCT_*
 *
 *@comment
 *	 Anthy  xchar.c ư
 *	Patched by G-HAL
 *	Fri,12 Jun,2009
 */
enum XCT_t anthy_get_xstr_type( const xstr* const xs )
{
  enum XCT_t ret = XCT_ALL;
  int i;
  for (i = 0; i < xs->len; ++i) {
    ret &= anthy_get_xchar_type( xs->str[i] );
  }
  return ret;
}
#endif



long long
anthy_xstrtoll(xstr *x)
{
  xchar c;
  int i;
  long long n = 0;/*  */
  if (!x->len || x->len > 16) {
    return -1;
  }
  if (!anthy_get_xstr_type(x) & (XCT_NUM | XCT_WIDENUM)) {
    return -1;
  }
  for (i = 0; i < x->len; i++) {
    c = x->str[i];
    n *= 10;
    n += anthy_xchar_to_num(c);
  }
  return n;
}

/** ѤοȾѤˤ
 */
xstr *
anthy_xstr_wide_num_to_num(xstr* src_xs)
{
  int i;
  xstr *dst_xs;
  dst_xs = anthy_xstr_dup(src_xs);
  for (i = 0; i < src_xs->len; ++i) {
    dst_xs->str[i] = anthy_xchar_wide_num_to_num(src_xs->str[i]);
  }
  return dst_xs;
}

/** ʿ̾򥫥ʤѴ
 */
xstr *
anthy_xstr_hira_to_kata(xstr *src_xs)
{
  xstr *dst_xs;
  int i, j;
  dst_xs = anthy_xstr_dup(src_xs);

  for (i = 0 ,j = 0; i < dst_xs->len; i++, j++) {
    /* ֤פΥå */
    if (i < dst_xs->len - 1 && dst_xs->str[i] == HK_U
	&& dst_xs->str[i+1] == HK_DDOT) {
      dst_xs->str[j] = KK_VU;/*  */
      i++;
      continue ;
    }
    /**/
   #if 0	/* Patched by G-HAL, Tue,09 Jun,2009 */
    dst_xs->str[j] = dst_xs->str[i];
    if ((anthy_ucs_to_euc(dst_xs->str[j]) & UINT16_C(0xff00)) == UINT16_C(0xa400)) {
      /* Ҥ餬ʤä256­ */
      dst_xs->str[j] = anthy_ucs_to_euc(dst_xs->str[j]);
      dst_xs->str[j] += 256;
      dst_xs->str[j] = anthy_euc_to_ucs(dst_xs->str[j]);
    }
   #else
    dst_xs->str[j] = anthy_xchar_hira_to_kata( dst_xs->str[i] );
   #endif
  }
  dst_xs->len = j;
  return dst_xs;
}

#if 1	/* Patched by G-HAL, Sun,19 Apr,2009 */
/** ʿ̾򥫥ʤѴ
 *@param[in]		src_xs			Ѵʸ
 *@return					Ѵʸ
 *
 *@comment
 *	֤פϡ֥פѴ롣
 *
 *	Patched by G-HAL, Sun,19 Apr,2009
 */
xstr* const anthy_xstr_hira_to_kata_without_vu( const xstr* const src_xs )
{
  int i, j;
  xstr* const dst_xs = (xstr*) malloc( sizeof(xstr) );
  if (NULL == dst_xs) {
    return NULL;
  }
  if ((NULL == src_xs)
      || (src_xs->len < 0)
      || ((SIZE_MAX / sizeof(xchar)) < src_xs->len)
  ) {
    free( dst_xs );
    return NULL;
  }
  dst_xs->str = (xchar*) malloc( sizeof(xchar) * (size_t)src_xs->len );
  if (NULL == dst_xs->str) {
    free( dst_xs );
    return NULL;
  }

  for (i = 0, j = 0; i < src_xs->len; ++i) {
    dst_xs->str[j] = anthy_xchar_hira_to_kata( src_xs->str[i] );
    ++j;
  }

  dst_xs->len = j;
  return dst_xs;
}

/** ʤʿ̾Ѵ
 *@param[in]		src_xs			Ѵʸ
 *@return					Ѵʸ
 *
 *@comment
 *	֥פϡ֤פѴ롣
 *
 *	Patched by G-HAL, Sun,19 Apr,2009
 */
xstr* const anthy_xstr_kata_to_hira( const xstr* const src_xs )
{
  int i, j;
  xstr* const dst_xs = (xstr*) malloc( sizeof(xstr) );
  if (NULL == dst_xs) {
    return NULL;
  }
  if ((NULL == src_xs)
      || (src_xs->len < 0)
      || ((SIZE_MAX / sizeof(xchar) / 2) < src_xs->len)
  ) {
    free( dst_xs );
    return NULL;
    /* (SIZE_MAX / sizeof(xchar) / 2)  /2 ϡ֥פΤ֤ */
  }
  dst_xs->str = (xchar*) malloc( sizeof(xchar) * (size_t)src_xs->len * 2 );
  if (NULL == dst_xs->str) {
    free( dst_xs );
    return NULL;
  }

  for (i = 0, j = 0; i < src_xs->len; ++i) {
    if (KK_VU == src_xs->str[i]) {
      /* ֥ */
      dst_xs->str[j] = HK_U;
      ++j;
      dst_xs->str[j] = HK_DDOT;
      ++j;
    } else {
      /* ¾ */
      dst_xs->str[j] = anthy_xchar_kata_to_hira( src_xs->str[i] );
      ++j;
    }
  }

  dst_xs->len = j;
  { xchar* const tmp = dst_xs->str;
    dst_xs->str = realloc( dst_xs->str, sizeof(xchar) * (size_t)dst_xs->len );
    if (NULL == dst_xs->str) {
      dst_xs->str = tmp;
    }
  }
  return dst_xs;
}

/** ֥פ֥פѴ
 *@param[in]		src_xs			Ѵʸ
 *@return					Ѵʸ
 *
 *	Patched by G-HAL, Sun,19 Apr,2009
 */
xstr* const anthy_xstr_vu_to_uddot( const xstr* const src_xs )
{
  int i, j;
  xstr* const dst_xs = (xstr*) malloc( sizeof(xstr) );
  if (NULL == dst_xs) {
    return NULL;
  }
  if ((NULL == src_xs)
      || (src_xs->len < 0)
      || ((SIZE_MAX / sizeof(xchar) / 2) < src_xs->len)
  ) {
    free( dst_xs );
    return NULL;
    /* (SIZE_MAX / sizeof(xchar) / 2)  /2 ϡ֥פΤ֤ */
  }
  dst_xs->str = (xchar*) malloc( sizeof(xchar) * (size_t)src_xs->len * 2 );
  if (NULL == dst_xs->str) {
    free( dst_xs );
    return NULL;
  }

  for (i = 0, j = 0; i < src_xs->len; ++i) {
    if (KK_VU == src_xs->str[i]) {
      /* ֥ */
      dst_xs->str[j] = HK_U_KANA;
      ++j;
      dst_xs->str[j] = HK_DDOT;
      ++j;
    } else {
      /* ¾ */
      dst_xs->str[j] = src_xs->str[i];
      ++j;
    }
  }

  dst_xs->len = j;
  { xchar* const tmp = dst_xs->str;
    dst_xs->str = realloc( dst_xs->str, sizeof(xchar) * (size_t)dst_xs->len );
    if (NULL == dst_xs->str) {
      dst_xs->str = tmp;
    }
  }
  return dst_xs;
}

/** ֥פ֤פѴ
 *@param[in]		src_xs			Ѵʸ
 *@return					Ѵʸ
 *
 *	Patched by G-HAL, Sun,19 Apr,2009
 */
xstr* const anthy_xstr_vu_to_hirauddot( const xstr* const src_xs )
{
  int i, j;
  xstr* const dst_xs = (xstr*) malloc( sizeof(xstr) );
  if (NULL == dst_xs) {
    return NULL;
  }
  if ((NULL == src_xs)
      || (src_xs->len < 0)
      || ((SIZE_MAX / sizeof(xchar) / 2) < src_xs->len)
  ) {
    free( dst_xs );
    return NULL;
    /* (SIZE_MAX / sizeof(xchar) / 2)  /2 ϡ֥פΤ֤ */
  }
  dst_xs->str = (xchar*) malloc( sizeof(xchar) * (size_t)src_xs->len * 2 );
  if (NULL == dst_xs->str) {
    free( dst_xs );
    return NULL;
  }

  for (i = 0, j = 0; i < src_xs->len; ++i) {
    if (KK_VU == src_xs->str[i]) {
      /* ֥ */
      dst_xs->str[j] = HK_U;
      ++j;
      dst_xs->str[j] = HK_DDOT;
      ++j;
    } else {
      /* ¾ */
      dst_xs->str[j] = src_xs->str[i];
      ++j;
    }
  }

  dst_xs->len = j;
  { xchar* const tmp = dst_xs->str;
    dst_xs->str = realloc( dst_xs->str, sizeof(xchar) * (size_t)dst_xs->len );
    if (NULL == dst_xs->str) {
      dst_xs->str = tmp;
    }
  }
  return dst_xs;
}
#endif

xstr *
anthy_xstr_hira_to_half_kata(xstr *src_xs)
{
#if !defined(USE_ICONV)	/* Patched by G-HAL, Tue,09 Jun,2009, Sat,13 Jun,2009 */
  int len = src_xs->len;
  int i, j;
  xstr *xs;
  for (i = 0; i < src_xs->len; i++) {
    const struct half_kana_table *tab = anthy_find_half_kana(src_xs->str[i]);
    if (tab && tab->mod) {
      len ++;
    }
  }
  xs = (xstr*) malloc(sizeof(xstr));
  xs->len = len;
  xs->str = (xchar*) malloc(sizeof(xchar) * len);
  j = 0;
  for (i = 0; i < src_xs->len; i++) {
    const struct half_kana_table *tab = anthy_find_half_kana(src_xs->str[i]);
    if (tab) {
      xs->str[j] = anthy_euc_to_ucs(tab->dst);
      if (tab->mod) {
	j++;
	xs->str[j] = anthy_euc_to_ucs(tab->mod);
      }
    } else {
      xs->str[j] = src_xs->str[i];
    }
    j++;
  }
  return xs;
#else
  int		len = src_xs->len;
  int		src_left = len;
  xchar*	src_ptr = src_xs->str;
  xstr* const	dst_xs = (xstr*) malloc( sizeof(xstr) );
  xchar*	dst_ptr = (xchar*) malloc( sizeof(xchar) * len * 2 );
  dst_xs->str = dst_ptr;

  for (; 0 < src_left; --src_left, ++src_ptr) {
    const int result_xc = anthy_find_half_kana( *src_ptr, dst_ptr, (dst_ptr + 1) );
    if (result_xc) {
      ++dst_ptr;
      if (0 != (*dst_ptr)) {
	++len;
	++dst_ptr;
      }
    } else {
      *dst_ptr = *src_ptr;
      ++dst_ptr;
    }
  }
  dst_xs->len = len;
  { xchar* const tmp = dst_xs->str;
    dst_xs->str = realloc( dst_xs->str, sizeof(xchar) * (size_t)len );
    if (NULL == dst_xs->str) {
      dst_xs->str = tmp;
    }
  }
  return dst_xs;
#endif
}

xstr *
anthy_conv_half_wide(xstr *xs)
{
  int i;
  xstr *res;
  for (i = 0; i < xs->len; i++) {
    if (!anthy_lookup_half_wide(xs->str[i])) {
      return NULL;
    }
  }
  res = anthy_xstr_dup(xs);
  for (i = 0; i < xs->len; i++) {
    res->str[i] = anthy_lookup_half_wide(xs->str[i]);
  }
  return res;
}

#if !defined(HASH_Init)	/* Patched by G-HAL, Fri,30 Jan,2009 */
# if 0	/* Patched by G-HAL, Tue,20 Oct,2009 */
int
anthy_xstr_hash(xstr *xs)
{
  int h,i;
  h = 0;
 #if 1	/* Patched by G-HAL, Mon,25 May,2009 */
  if (NULL == xs) {
    return h;
  }
 #endif
  for (i = 0 ;i < xs->len ;i++) {
    h *= 97;
    h += xs->str[i]<<4;
    h += xs->str[i]>>4;
  }
  if (h < 0) {
    return -h;
  }
  return h;
}
# else

/* CRC32 RFC2083 */
static int crc_table_computed = 0;
static uint32_t crc_table[256];
static const uint32_t crc_init_value = UINT32_C(0xFFFFFFFF);
/* static const uint32_t crc_value = UINT32_C(0xEDB88320); */		/* CRC32-IEEE802.3  */
static const uint32_t crc_value = UINT32_C(0x82F63B78);		/* CRC32C Castagnoli */
/* static const uint32_t crc_value = UINT32_C(0xEB31D82E); */		/* CRC32K Koopman */

/** ϥåͥơ֥
 *
 *@comment
 *	Patched by G-HAL
 *		Tue,20 Oct,2009
 */
static void make_crc_table( void )
{
  uint32_t c;
  size_t n;
  size_t k;
  for (n = 0; n < 256; ++n) {
    c = (uint32_t) n;
    for (k = 0; k < 8; ++k) {
      if (c & 1) {
	c = crc_value ^ (c >> 1);
      } else {
	c = c >> 1;
      }
    }
    crc_table[n] = c;
  }
  crc_table_computed = 1;
  return;
}


/** ϥåͷ׻³
 *@param		hash			ϥåͤ
 *@param		d			ϥåɲäǡ
 *@return					ϥå
 *
 *@comment
 *	Patched by G-HAL
 *		Sat,07 Nov,2009
 */
static inline uint32_t hash_uint8_update( uint32_t hash, uint8_t d )
{
  return crc_table[(hash ^ d) & UINT8_C(0xFF)] ^ (hash >> 8);
}

/** ϥåͷ׻³
 *@param		hash			ϥåͤ
 *@param		d			ϥåɲäǡ
 *@return					ϥå
 *
 *@comment
 *	Patched by G-HAL
 *		Sat,07 Nov,2009
 */
static inline uint32_t hash_uint32_update( uint32_t hash, uint32_t d )
{
  uint32_t h = hash;
  h = hash_uint8_update( h, (d >> (8*3)) );
  h = hash_uint8_update( h, (d >> (8*2)) );
  h = hash_uint8_update( h, (d >> (8*1)) );
  h = hash_uint8_update( h, (d >> (8*0)) );
  return h;
}


/** ϥåͷ׻³
 *@param		hash			ϥåͤ
 *@param		d			ϥåɲäǡ
 *@return					ϥå
 *
 *@note
 *	anthy_hash_*_start(),
 *	anthy_hash_*_update(), ...
 *	anthy_hash_finalize()
 *	ν֤ǸƤӽФ
 *
 *@comment
 *	Patched by G-HAL
 *		Sat,07 Nov,2009
 *		Mon,06 Sep,2010
 */
inline uint32_t anthy_hash_uint8_update( uint32_t hash, uint8_t d )
{
  assert( 0 < crc_table_computed );
  return hash_uint8_update( hash, d );
}

/** ϥåͷ׻³
 *@param		hash			ϥåͤ
 *@param		d			ϥåɲäǡ
 *@return					ϥå
 *
 *@note
 *	anthy_hash_*_start(),
 *	anthy_hash_*_update(), ...
 *	anthy_hash_finalize()
 *	ν֤ǸƤӽФ
 *
 *@comment
 *	Patched by G-HAL
 *		Sat,07 Nov,2009
 *		Mon,06 Sep,2010
 */
inline uint32_t anthy_hash_uint32_update( uint32_t hash, uint32_t d )
{
  assert( 0 < crc_table_computed );
  return hash_uint32_update( hash, d );
}


/** ʸΥϥåͷ׻³
 *@param		hash			ϥåͤ
 *@param[in]		s			ʸ
 *@return					ϥå
 *
 *@note
 *	anthy_hash_*_start(),
 *	anthy_hash_*_update(), ...
 *	anthy_hash_finalize()
 *	ν֤ǸƤӽФ
 *
 *@comment
 *	Patched by G-HAL
 *		Sun,01 Nov,2009
 *		Sat,07 Nov,2009
 *		Mon,06 Sep,2010
 */
inline uint32_t anthy_hash_str_update( uint32_t hash, const char* const s )
{
  uint32_t h = hash;

  if ((NULL == s) || ('\0' == *s)) {
    return hash;
  }
  assert( 0 < crc_table_computed );
  { size_t i;
    const size_t len = strlen( s );
    const char* ptr;
    for (i = 0, ptr = s; i < len; ++i, ++ptr) {
      h = hash_uint8_update( h, *ptr );
    }
  }
  return h;
}

/** ʸΥϥåͷ׻³
 *@param		hash			ϥåͤ
 *@param[in]		xs			ʸ
 *@return					ϥå
 *
 *@note
 *	anthy_hash_*_start(),
 *	anthy_hash_*_update(), ...
 *	anthy_hash_finalize()
 *	ν֤ǸƤӽФ
 *
 *@comment
 *	Patched by G-HAL
 *		Tue,20 Oct,2009
 *		Sun,01 Nov,2009
 *		Sat,07 Nov,2009
 *		Mon,06 Sep,2010
 */
inline uint32_t anthy_hash_xstr_update( uint32_t hash, const xstr* const xs )
{
  uint32_t h = hash;

  if ((NULL == xs) || (xs->len < 1)) {
    return hash;
  }
  assert( NULL != xs->str );
  assert( 0 < crc_table_computed );
  { int i;
    const xchar* ptr;
    for (i = 0, ptr = xs->str; i < xs->len; ++i, ++ptr) {
     #if 0
      h *= 24919;
      h += (*ptr);
     #else
      /* h = hash_uint8_update( h, ((*ptr) >> (8*3)) ); */
      h = hash_uint8_update( h, ((*ptr) >> (8*2)) );
      h = hash_uint8_update( h, ((*ptr) >> (8*1)) );
      h = hash_uint8_update( h, ((*ptr) >> (8*0)) );
     #endif
    }
  }
  return h;
}


/** ʸΥϥåͷ׻򳫻Ϥ
 *@param[in]		s			ʸ
 *@return					ϥå
 *
 *@note
 *	anthy_hash_*_start(),
 *	anthy_hash_*_update(), ...
 *	anthy_hash_finalize()
 *	ν֤ǸƤӽФ
 *
 *@comment
 *	Patched by G-HAL
 *		Sun,01 Nov,2009
 */
inline uint32_t anthy_hash_str_start( const char* const s )
{
  return anthy_hash_str_update( crc_init_value, s );
}

/** ʸΥϥåͷ׻򳫻Ϥ
 *@param[in]		xs			ʸ
 *@return					ϥå
 *
 *@note
 *	anthy_hash_*_start(),
 *	anthy_hash_*_update(), ...
 *	anthy_hash_finalize()
 *	ν֤ǸƤӽФ
 *
 *@comment
 *	Patched by G-HAL
 *		Tue,20 Oct,2009
 *		Sun,01 Nov,2009
 */
inline uint32_t anthy_hash_xstr_start( const xstr* const xs )
{
  return anthy_hash_xstr_update( crc_init_value, xs );
}


/** ϥåͷ׻λ
 *@param		hash			ϥåͤ
 *@return					ϥå
 *@retval		< 0			顼
 *
 *@note
 *	anthy_hash_*_start(),
 *	anthy_hash_*_update(), ...
 *	anthy_hash_finalize()
 *	ν֤ǸƤӽФ
 *
 *@comment
 *	Patched by G-HAL
 *		Tue,20 Oct,2009
 *		Sun,01 Nov,2009
 *		Thu,14 Oct,2010
 */
inline int anthy_hash_finalize( uint32_t hash )
{
  hash &= UINT32_C(0x7FFFFFFF);
  if (0 == hash) {
   #if defined(DEBUG) && (1 <= DEBUG)
    fprintf(stderr, "wrong hash\n" );
   #endif
    hash = UINT32_C(0x7FFFFFFF);	/*  */
  }
  return hash;
}

/** ʸΥϥåͤ
 *@param[in]		xs			ʸ
 *@return					ϥå
 *@retval		< 0			顼
 *
 *@comment
 *	Patched by G-HAL
 *		Tue,20 Oct,2009
 *		Thu,12 Aug,2010
 */
inline int anthy_xstr_hash( const xstr* const xs )
{
  if ((NULL == xs) || (xs->len < 1)) {
    return 0;
  }
  return anthy_hash_finalize( anthy_hash_xstr_start( xs ) );
}

# endif
#else
int anthy_xstr_hash( const xstr* const xs )
{
  HASH_CTX ctx;

  HASH_Init( &ctx );
  { size_t i;
    for (i = 0; i < xs->len; ++i) {
      HASH_Update( &ctx, &(xs->str[i]), sizeof(xs->str[i]) );
    }
  }
  { uint32_t ret = 0;
   #if (sizeof(uint32_t)*CHAR_BIT) < (HASH_DIGEST_LEN*8)
    uint8_t digest[HASH_DIGEST_LEN];
   #else
    uint8_t digest[sizeof(uint32_t)*CHAR_BIT/8] = 0;
   #endif
    HASH_Final( digest, &ctx );

   #if defined(CHARARRAY_IS_CONTINUOUS8BIT)
    ret = *((uint32_t*)digest);
   #else
    size_t len = (sizeof(ret)*CHAR_BIT) < (HASH_DIGEST_LEN*8) ? (sizeof(ret)*CHAR_BIT) : (HASH_DIGEST_LEN*8);
    /* η׻ len ȡretΥǡĹۤ뤬ƾ̵Τ֡ */
    for (; 0 < len; --len) {
      ret += (digest[len] << (len * 8));
    }
   #endif
    ret &= UINT32_C(0x7FFFFFFF);
    if (0 == ret) {
     #if defined(DEBUG) && (1 <= DEBUG)
      fprintf(stderr, "wrong hash\n" );
     #endif
      ret = UINT32_C(0x7FFFFFFF);	/*  */
    }
    return ret;
  }
}
#endif

#if !defined(USE_ICONV)	/* Patched by G-HAL, Mon,25 May,2009 */
static char *
conv_cstr(const char *s, int from, int to)
{
  char *res;
  xstr *xs = anthy_cstr_to_xstr(s, from);
  if (!xs) {
    return NULL;
  }
  res = anthy_xstr_to_cstr(xs, to);
  anthy_free_xstr(xs);
  return res;
}

char *
anthy_conv_euc_to_utf8(const char *s)
{
  return conv_cstr(s, ANTHY_EUC_JP_ENCODING, ANTHY_UTF8_ENCODING);
}

char *
anthy_conv_utf8_to_euc(const char *s)
{
  return conv_cstr(s, ANTHY_UTF8_ENCODING, ANTHY_EUC_JP_ENCODING);
}
#endif

void
anthy_xstr_set_print_encoding(int encoding)
{
  print_encoding = encoding;
}

int
anthy_init_xstr(void)
{
 #if !defined(HASH_Init)	/* Patched by G-HAL, Fri,30 Jan,2009 */
  if (0 == crc_table_computed) {
    make_crc_table();
  }
 #endif
  return 0;
}

void anthy_quit_xstr(void)
{
}
/* vim:ts=8 sw=2 nomodified:
 */
