/**@file
 *			Patches for Anthy, by G-HAL
 *@brief	°쥰դǤʻҡΥܥ
 *@date		Tue,27 Oct,2009
 *@date		Wed,13 Oct,2010 - Thu,14 Oct,2010
 *@author	Copyright(C)2009-2010 G-HAL
 */
#if defined(HAVE_CONFIG_H)
# include "config.h"
#endif

#if defined(HAVE_STDLIB_H)
# include <stdlib.h>
#endif
#if defined(HAVE_SYS_TYPES_H)
# include <sys/types.h>
#endif

#include "anthy/settings.h"
#include "anthy/splitter.h"
#include "src-splitter/wordborder.h"
#include "src-splitter/depgraph_type_sym.h"



/** °쥰 H ܡʻˤ̾ΰ
 * Patched by G-HAL
 *	Tue,27 Oct,2009
 *@attention
 *	anthy/wtype.h  #define POS_* ȹ碌ʤФʤʤ
 */
static const struct {
	const int type;
	const char* const name;
	const char* const sym;
} depgraph_pos_class_tab[] = {
	{ POS_NONE,			"(̵)",									"_" },
	{ POS_NOUN,			"̾",									"n" },
	{ POS_PRT,			"",									"prt" },
	{ POS_XV,			"",									"xv" },
	{ POS_V,			"ư",									"v" },
	{ POS_A,			"ƻ",								"a" },
	{ POS_AJV,			"ư",								"j" },
	{ POS_AV,			"",									"av" },
	{ POS_ME,			"Ϣλ",								"me" },
	{ POS_CONJ,			"³",								"conj" },
	{ POS_IJ,			"()",								"ij" },
	{ POS_PRE,			"Ƭ",								"pre" },
	{ POS_SUC,			"",								"suc" },
	{ POS_TANKANJI,		"ñ",								"kj" },
	{ POS_N2T,			"̾դ̾첽",				"n2t" },
	{ POS_D2KY,			"ưϢѷդƻ첽",		"d2ky" },
	{ POS_NUMBER,		"",									"num" },
	{ POS_INVAL,		"",									"inval" },
	{ POS_OPEN,			"",								"(" },
	{ POS_CLOSE,		"Ĥ",								")" },
};

/** °쥰 C ܡʳѷˤ̾ΰ
 * Patched by G-HAL
 *	Tue,27 Oct,2009
 *@attention
 *	anthy/wtype.h  #define CT_* ȹ碌ʤФʤʤ
 */
static const struct {
	const int type;
	const char* const name;
	const char* const sym;
} depgraph_ct_class_tab[] = {
	{ CT_NONE,			"(̵)",									"_" },
	{ CT_SYUSI,			"߷",								"s" },
	{ CT_MIZEN,			"̤",								"z" },
	{ CT_RENYOU,		"Ϣѷ",								"y" },
	{ CT_RENTAI,		"Ϣη",								"t" },
	{ CT_KATEI,			"",								"k" },
	{ CT_MEIREI,		"̿",								"m" },
	{ CT_HEAD,			"촴",									"g" },
	{ CT_MEISIKA,		"ưϢѷ̾첽",						"n" },
};

/** °쥰 S ܡʻˤ̾ΰ
 * Patched by G-HAL
 *	Tue,27 Oct,2009
 *@attention
 *	anthy/segclass.h  #define DEP_* ȹ碌ʤФʤʤ
 */
static const struct {
	const int type;
	const char* const name;
	const char* const sym;
} depgraph_dep_class_tab[] = {
	{ DEP_NONE,			"°ʤ",							"_" },
	{ DEP_FUZOKUGO,		"°",							"f" },
	{ DEP_KAKUJOSHI,	"ʽ",								"k" },
	{ DEP_RENYOU,		"Ϣ",									"y" },
	{ DEP_RENTAI,		"Ϣ",									"t" },
	{ DEP_END,			"ü",									"e" },
	{ DEP_RAW,			"̾ñ",								"r" },
	{ DEP_EOS,			"ʸ",									"z" },
	{ DEP_PART,			"ٹζ°첽ͥ㤯ʤ",	"p+" },
	{ DEP_PART_GUESS,	"ٹζ°첽ͥ",			"p-" },
};



/** °쥰դ H ܤɽʸμ
 *@param[in]		mw				meta_word
 *@return						ɽʸ
 *
 *	Patches by G-HAL
 *		Tue,27 Oct,2009
 */
const char* const anthy_depgraph_pos_class_sym( const struct meta_word* const mw )
{
	size_t i;
	if ((NULL == mw) || (NULL == mw->wl)) {
		return "*";
	}
	for (i = 0; i < _number_(depgraph_pos_class_tab); ++i) {
		if (depgraph_pos_class_tab[i].type == mw->wl->head_pos) {
			return depgraph_pos_class_tab[i].sym;
		}
	}
	return "?";
}

/** °쥰դ C ܤɽʸμ
 *@param[in]		mw				meta_word
 *@return						ɽʸ
 *
 *	Patches by G-HAL
 *		Tue,27 Oct,2009
 */
const char* const anthy_depgraph_ct_class_sym( const struct meta_word* const mw )
{
	size_t i;
	if ((NULL == mw) || (NULL == mw->wl)) {
		return "*";
	}
	for (i = 0; i < _number_(depgraph_ct_class_tab); ++i) {
		if (depgraph_ct_class_tab[i].type == mw->wl->tail_ct) {
			return depgraph_ct_class_tab[i].sym;
		}
	}
	return "?";
}

/** °쥰դ S ܤɽʸμ
 *@param[in]		mw				meta_word
 *@return						ɽʸ
 *
 *	Patches by G-HAL
 *		Tue,27 Oct,2009
 */
const char* const anthy_depgraph_dep_class_sym( const struct meta_word* const mw )
{
	size_t i;
	if ((NULL == mw) || (NULL == mw->wl)) {
		return "*";
	}
	for (i = 0; i < _number_(depgraph_dep_class_tab); ++i) {
		if (depgraph_dep_class_tab[i].type == mw->wl->part[PART_DEPWORD].dc) {
			return depgraph_dep_class_tab[i].sym;
		}
	}
	return "?";
}
/* [ End of File ] */
/* vim:ts=4 sw=4 nomodified:
 */
