/**@file
 *			Patches for the Anthy, by G-HAL
 *@brief	ʸڤꥢ르ꥺࡧʸĹ
 *@date		Sun,16 Nov,2008 - Sat,22 Nov,2008
 *@date		Mon,19 Jan,2009
 *@date		Sat,24 Jan,2009, Wed,28 Jan,2009 - Thu,29 Jan,2009
 *@date		Wed,04 Feb,2009 - Thu,05 Feb,2009
 *@date		Sun,08 Feb,2009
 *@date		Mon,09 Feb,2009
 *@date		Tue,24 Feb,2009
 *@date		Fri,06 Mar,2009 - Sun,08 Mar,2009
 *@date		Fri,01 May,2009
 *@date		Sun,17 May,2009
 *@date		Sun,07 Jun,2009
 *@date		Sat,19 Sep,2009
 *@date		Sat,14 Nov,2009 - Sun,15 Nov,2009
 *@date		Tue,17 Nov,2009 - Wed,18 Nov,2009
 *@date		Fri,27 Nov,2009
 *@date		Wed,13 Oct,2010 - Thu,14 Oct,2010
 *@author	Copyright(C)2008-2010 G-HAL
 */
#if defined(HAVE_CONFIG_H)
# include "config.h"
#endif

#if defined(HAVE_STDLIB_H)
# include <stdlib.h>
#endif
#if defined(HAVE_MALLOC_H)
# include <malloc.h>
#endif
#if !defined(__STDC_LIMIT_MACROS)
# define __STDC_LIMIT_MACROS
#endif
#if !defined(__STDC_CONSTANT_MACROS)
# define __STDC_CONSTANT_MACROS
#endif
#if defined(HAVE_STDINT_H)
# include <stdint.h>
#endif
#if !defined(__STDC_FORMAT_MACROS)
# define __STDC_FORMAT_MACROS
#endif
#if defined(HAVE_INTTYPES_H)
# include <inttypes.h>
#endif
#if defined(HAVE_SYS_TYPES_H)
# include <sys/types.h>
#endif
#if defined(HAVE_STRING_H)
# include <string.h>
#endif
#if defined(HAVE_STRINGS_H)
# include <strings.h>
#endif
#if defined(HAVE_LIMITS_H)
# include <limits.h>
#endif
#if defined(HAVE_SYS_LIMITS_H)
# include <sys/limits.h>
#endif
#if defined(HAVE_ALLOCA_H)
# include <alloca.h>
#elif defined(HAVE_ALLOCA)
#else
# error	"alloca() was not found."
#endif

#include "anthy/settings.h"
#include "anthy/splitter.h"
#include "src-splitter/lattice.h"



static const struct priority_of_metaword_t MAXLEN_PRIORITY_OF_METAWORD = {
	.splitkind_pri[SPLITKIND_OCHAIRE_MIDDLE      ] = { .pri = 37, .sub = 1, },
	.splitkind_pri[SPLITKIND_OCHAIREwoD_MIDDLE   ] = { .pri = 36, .sub = 1, },
	.splitkind_pri[SPLITKIND_OCHAIREwoI_MIDDLE   ] = { .pri = 35, .sub = 1, },
	.splitkind_pri[SPLITKIND_OCHAIREwoIwoD_MIDDLE] = { .pri = 34, .sub = 1, },
	.CAND_COUNTER_MAXLIMIT                         = { .pri = 29, .sub = 1, },
	.CAND_COUNTER_MAXLIMIT_VALUE                   = { .pri = 25, .sub = 1, },
	.splitkind_pri[SPLITKIND_OCHAIRE_HEAD        ] = { .pri = 17, .sub = 1, },
	.splitkind_pri[SPLITKIND_OCHAIREwoD_HEAD     ] = { .pri = 16, .sub = 1, },
	.splitkind_pri[SPLITKIND_OCHAIRE_TAIL        ] = { .pri = 15, .sub = 1, },
	.splitkind_pri[SPLITKIND_OCHAIRE_SINGLE      ] = { .pri = 14, .sub = 1, },
	.splitkind_pri[SPLITKIND_OCHAIREwoI_TAIL     ] = { .pri = 14, .sub = 1, },
	.splitkind_pri[SPLITKIND_OCHAIREwoD_TAIL     ] = { .pri = 13, .sub = 1, },
	.splitkind_pri[SPLITKIND_OCHAIREwoIwoD_TAIL  ] = { .pri = 12, .sub = 1, },
	.splitkind_pri[SPLITKIND_OCHAIREwoD_SINGLE   ] = { .pri = 11, .sub = 1, },
	.OCHAIRE_WEAKMODE                              = { .pri =  5, .sub = 0, },
	.CAND_STRONGMODE                               = { .pri = 11, .sub = 0, },
	.CAND_COUNTER_MINLIMIT                         = { .pri = 10, .sub = 1, },
	.CAND_WEAKMODE                                 = { .pri =  5, .sub = 0, },
	.splitkind_pri[SPLITKIND_DEFAULT             ] = { .pri =  5, .sub = 0, },
	.splitkind_pri[SPLITKIND_COMPOUNDHEAD        ] = { .pri = -1, .sub = 0, },
	.splitkind_pri[SPLITKIND_COMPOUNDPART        ] = { .pri = -2, .sub = 0, },
	.splitkind_pri[SPLITKIND_COMPOUND            ] = { .pri = -3, .sub = 0, },
	.splitkind_pri[SPLITKIND_COMPOUNDLEAF        ] = { .pri =  5, .sub = 0, },
	.splitkind_pri[SPLITKIND_OCHAIREwoI_HEAD     ] = { .pri = -8, .sub = 0, },
	.splitkind_pri[SPLITKIND_OCHAIREwoIwoD_HEAD  ] = { .pri = -8, .sub = 0, },
	.splitkind_pri[SPLITKIND_OCHAIREwoI_SINGLE   ] = { .pri = -8, .sub = 0, },
	.splitkind_pri[SPLITKIND_OCHAIREwoIwoD_SINGLE] = { .pri = -8, .sub = 0, },
	.splitkind_pri[SPLITKIND_DELETEDHISTORY      ] = { .pri = -9, .sub = 0, },
};



/**  meta_word ̡ͥоη󥽥󥫥󥿡 */
enum valuation_t {
	disable = UINT8_C(0x00),		/**< Բ */
	block   = UINT8_C(0x01),		/**< Ū˻Ѷػ */
	enable  = UINT8_C(0x02),		/**< Ѳݤ */
	unknown = UINT8_C(0x03),		/**< ̤ */
	weak    = UINT8_C(0x07),		/**< ǤȤʤ */
	normal  = UINT8_C(0x0F),		/**< ɸ */
	strong  = UINT8_C(0x1F),		/**< ͥ褷ƻ */
	valuation_max = UINT8_C(0x20),	/**< ʼ */
};

/**  meta_word δ */
struct mw_table_t {
	struct meta_word*	mw;				/**< ʥݥ󥿡meta_word μ */
	enum valuation_t	valuation;		/**<  meta_word ͥ */
	int					extra_score;	/**< meta_word ΥФɲ */
	size_t				extra_depth;	/**<  meta_word Ρʸ-1 */
};

static const size_t	mw_table_t_alloc_step_size = 16;	/**< mw_list_t  mw_table_t ˤơԳݤ */

/** Ƴʸ֤ˤ롢ƱĹ meta_word ΰ */
struct mw_list_t {
	size_t								num;				/**< mw_table ǿ */
	struct mw_table_t*					mw_table;			/**< meta_word ΰ */
	enum valuation_t					valuation;			/**<  mw_list_t κǹͥ */
};

/** ʸڹ¤ */
struct maxlen_fn_phrases_node_t {
	struct maxlen_fn_phrases_node_t*	parent;					/**< ʥݥ󥿡˿ƥΡ */
	struct maxlen_fn_phrases_node_t*	child;					/**< :(Master->to - node->from +1)meta_word ĹλҥΡɡ[0]: Ĺ, [1]: Ĺ, ġ */
	struct mw_list_t*					mw_list;				/**< :(Master->to - node->from +1)meta_word Ĺ meta_word ΰmaxlen_fn_phrases_class_t  mw_list ʣʪ */
	size_t								max_mw_list;			/**< mw_list ˳ǼƤֹ */
	size_t								from;					/**< ʸ */
	size_t								depth;					/**< ΥΡɤο */
	int									priority;				/**< calc_cmpnode_priority() ɾʻ޴ѡ */
	int									minlen;					/**< calc_cmpnode_priority() йʸĹʻ޴ѡ */
	int									score;					/**< calc_cmpnode_priority() 祹ʻ޴ѡ */
	int									ochaire_phrase_score;	/**< calc_cmpnode_priority() OCHAIREʸʻ޴ѡ */
	enum valuation_t					valuation;				/**< ΥΡɤκǹͥ */
};

/** ʸĹפν˻Ȥǡκ */
struct maxlen_fn_phrases_class_t {
	struct splitter_context* const		sc;					/**< ʥݥ󥿡ʸڤδþ */
	size_t								to;					/**< Ǹʸ */
	struct mw_list_t** const			mw_list;			/**< :Master->to˳ʸ :(Master->to - node->from +1)meta_word Ĺ  mw_list_t Υå */
	size_t* const						max_mw_list;		/**< :Master->tomw_list ˳ǼƤֹ */
	size_t								maxdepth;			/**< õ翼 */
	struct maxlen_fn_phrases_node_t		root_node;			/**< ʸꥹȤκ */
};



/** ʸꥹȤ
 *@param[in,out]	node		ʸꥹ
 *
 *@note
 *		ѤߤΥե饰ΩƤƤʤΤա
 *		Ѥߥե饰Ƥϰʲ
 *			child->max_mw_list = 0;
 *			child->child       = NULL;
 *			child->mw_list     = NULL;
 *
 *		Fri,06 Mar,2009, Sun,08 Mar,2009
 */
static void free_maxlen_n_phrases_node( struct maxlen_fn_phrases_node_t* const node )
{
	if (NULL == node) {
		return;
	}
	if (0 < node->max_mw_list) {
		size_t	i = node->max_mw_list;
		struct maxlen_fn_phrases_node_t*	child = &(node->child[i]);
		struct mw_list_t*	list = &(node->mw_list[i]);
		for (; 0 < i; --i, --child, --list) {
			free_maxlen_n_phrases_node( child );
			free( list->mw_table );
		}
	}
	free( node->child );
	free( node->mw_list );
	return;
}



/** ¦ʸڤ꤬ꤵ줿 mw κ¦ʸȰפ뤫ɤȽꤹ
 *@param[in]		sc				ʸڤ
 *@param[in]		node			ȽȤʸڤ
 *@param[in]		mw				ȽȤ mw
 *@retval			0				פʤ
 *@retval			1				פ
 *
 *@note
 *		Ω̵ OCHAIRE бΰ١ʸκڤθϤʤ
 *
 *		Sun,16 Nov,2008
 *		Fri,06 Mar,2009
 */
static int check_is_match_leftmw( const struct splitter_context* const sc,
								 const struct maxlen_fn_phrases_node_t* node,
								 const struct meta_word* mw )
{
	const struct word_split_info_cache* const	info = sc->word_split_info;
	size_t	i;

	if (NULL == mw) {
		return 0;
	}
	mw = mw->mw1_left;

	while (mw) {
		/* ʸΥå */
		for (i = mw->from + mw->len - 1; mw->from < i; --i) {
			if (0 != info->seg_border[i]) {
				return 0;
			}
		}
		/* ʸᱦڤΥå */
		if (node) {
			if (node->from != (mw->from + mw->len)) {
				return 0;
			}
		} else {
			if (0 == info->seg_border[mw->from + mw->len]) {
				return 0;
			}
		}
		/*  */
		mw = mw->mw1_left;
		if (node) {
			node = node->parent;
		}
	}
	return 1;
}



/** ʸڹ¤ۤ
 *@param[in,out]	Master			þ
 *@param[in,out]	node			ʸΥΡ
 *
 *		Fri,06 Mar,2009 - Sat,07 Mar,2009
 *		Fri,01 May,2009
 *		Sun,17 May,2009
 *		Sat,19 Sep,2009
 */
static void build_path( struct maxlen_fn_phrases_class_t* const Master,
					   struct maxlen_fn_phrases_node_t* const node )
{
	const size_t	from     = node->from;
	const size_t	to       = Master->to;
	const size_t	left_len = to - from;

	/* meta_word å */
	if (NULL == Master->mw_list[from]) {
		struct mw_list_t* const	mw_list = calloc( (left_len + 1), sizeof(struct mw_list_t) );
		struct mw_list_t*		mw_list_p;
		struct meta_word*		mw;
		const size_t			mw_list_maxnum_table_size = (left_len + 1) * sizeof(size_t);
		size_t* const			mw_list_maxnum_table = alloca( mw_list_maxnum_table_size );
		size_t*					mw_list_maxnum;

		Master->mw_list[from]     = mw_list;
		Master->max_mw_list[from] = 0;
		memset( mw_list_maxnum_table, 0, mw_list_maxnum_table_size );

		for (mw = Master->sc->word_split_info->cnode[from].mw; mw; mw = mw->next) {
			/* Ŭ */
			if (mw->can_use < ok) {
				continue;
			}
			if (left_len < mw->len) {
				continue;
			}

			/* Ǽ */
			if (Master->max_mw_list[from] < mw->len) {
				Master->max_mw_list[from] = mw->len;
			}
			mw_list_p      = &(mw_list[mw->len]);
			mw_list_maxnum = &(mw_list_maxnum_table[mw->len]);
			if (*mw_list_maxnum <= mw_list_p->num) {
				void* const	mem = realloc( mw_list_p->mw_table, ((*mw_list_maxnum + mw_table_t_alloc_step_size) * sizeof(struct mw_table_t)) );
				if (mem) {
					mw_list_p->mw_table = mem;
					*mw_list_maxnum += mw_table_t_alloc_step_size;
				}
			}
			if (mw_list_p->num < *mw_list_maxnum) {
				mw_list_p->mw_table[mw_list_p->num].mw          = mw;
				mw_list_p->mw_table[mw_list_p->num].valuation   = unknown;
				mw_list_p->mw_table[mw_list_p->num].extra_score = 0;
				mw_list_p->mw_table[mw_list_p->num].extra_depth = 0;
				if (mw->wl) {
					if (anthy_settings.anthy_mode.lattice.maxlen_mode.phrase_with_pre_post_as_2
						&& (0 < mw->wl->part[PART_PREFIX].len) && (0 < mw->wl->part[PART_POSTFIX].len)
					) {
						mw_list_p->mw_table[mw_list_p->num].extra_depth = 1;
					}
				}
				++ mw_list_p->num;
			}
		}
	  #if 0
		{	size_t	i;
			for (i = left_len; 0 < i; --i) {
				mw_list_p = &(mw_list[i]);
				mw_list_p->mw_table = realloc( mw_list_p->mw_table, (mw_list_p->num * sizeof(struct mw_table_t)) );
			}
		}
	  #endif
	}

	/* meta_word å夫 meta_word  */
	if (NULL == node->mw_list) {
		size_t	i = Master->max_mw_list[from];
		struct mw_list_t*	mw_list_base = &(Master->mw_list[from][i]);
		struct mw_list_t*	mw_list_p;
		node->mw_list = calloc( (i + 1), sizeof(struct mw_list_t) );
		size_t	j;

		mw_list_p = &(node->mw_list[i]);
		node->max_mw_list = i;
		node->priority             = 0;
		node->minlen               = 0;
		node->score                = 0;
		node->ochaire_phrase_score = 0;
		node->valuation            = disable;

		for (; 0 < i; --i, --mw_list_base, --mw_list_p) {
			const size_t	num = mw_list_base->num;
			if (0 < num) {
				const size_t	len = sizeof(struct mw_table_t) * num;
				struct mw_table_t*	mwt = malloc( len );
				int		current_priority;
				int		have_sub_priority;
				int		minlen;
				int		check_ochaire_phrase_score;

				mw_list_p->num      = num;
				mw_list_p->mw_table = mwt;
				memcpy( mwt, mw_list_base->mw_table, len );

				for (j = 0; j < mw_list_p->num; ++j, ++mwt) {
					struct meta_word* const	mw = mwt->mw;

					/* Ŭ */
					if ((MW_ochaire_min <= mw->type) && (mw->type <= MW_ochaire_max)) {
						if (!check_is_match_leftmw( Master->sc, node, mw )) {
							mwt->valuation = disable;
							continue;
						}
					}

					/* ޴򻻽 */
					current_priority = calc_cmpnode_priority( &MAXLEN_PRIORITY_OF_METAWORD, mw, 0, 0, &have_sub_priority, &minlen );
					if (current_priority < 0) {
						mwt->valuation = disable;
						continue;
					}
					if (node->minlen < minlen) {
						node->minlen = minlen;
					}
					if (node->priority <= current_priority) {
						if (node->priority < current_priority) {
							node->priority             = current_priority;
							node->score                = 0;
							node->ochaire_phrase_score = 0;
						}
						check_ochaire_phrase_score = 1;
						if (have_sub_priority) {
							if (mw->score < node->score) {
								check_ochaire_phrase_score = 0;
							} else if (node->score < mw->score) {
								node->score                = mw->score;
								node->ochaire_phrase_score = 0;
							}
						}
						if (check_ochaire_phrase_score
							&& ((MW_ochaire_min <= mw->type) && (mw->type <= MW_ochaire_max))
						) {
							if (node->ochaire_phrase_score < mw->ochaire_phrase_score) {
								node->ochaire_phrase_score = mw->ochaire_phrase_score;
							}
						}
					}
				}
			}
		}
	}

	/* meta_word ҥΡɰ */
	if (NULL == node->child) {
		size_t								i = node->max_mw_list;
		struct mw_list_t*					mw_list_p = &(node->mw_list[i]);
		struct maxlen_fn_phrases_node_t*	child;
		node->child = malloc( (i + 1) * sizeof(struct maxlen_fn_phrases_node_t) );
		child = &(node->child[i]);

		for (; 0 < i; --i, --child, --mw_list_p) {
			child->parent      = node;
			child->child       = NULL;
			child->mw_list     = NULL;
			child->max_mw_list = 0;
			child->from        = from + i;
			child->valuation   = disable;
		}
	}

	/* ҥΡɰƵƤӽФ */
	if (node->depth < Master->maxdepth) {
		size_t	i = node->max_mw_list;
		struct maxlen_fn_phrases_node_t*	child = &(node->child[i]);
		struct mw_list_t*					mw_list_p = &(node->mw_list[i]);
		for (; 0 < i; --i, --child, --mw_list_p) {
			if (0 < mw_list_p->num) {
				child->depth = node->depth + 1;
				build_path( Master, child );
			}
		}
	}

	return;
}


/** ʸڹ¤λ޴
 *@param[in]		Master			þ
 *@param[in,out]	node			ʸΥΡ
 *@param			maxdepth		޴ο
 *@param			maxlen			޴ʸ
 *@param			valuation		оݤȤǹͥ
 *
 *		Sun,16 Nov,2008 - Sat,22 Nov,2008
 *		Sat,07 Mar,2009 - Sun,08 Mar,2009
 */
static void cut_path( struct maxlen_fn_phrases_class_t* const Master,
					 struct maxlen_fn_phrases_node_t* const node,
					 size_t maxdepth, size_t maxlen,
					 enum valuation_t valuation )
{
	size_t	i = node->max_mw_list;
	struct maxlen_fn_phrases_node_t*	child     = &(node->child[i]);
	struct mw_list_t*					mw_list_p = &(node->mw_list[i]);
	enum valuation_t					valuation_node;
	struct mw_table_t*					mwt;
	enum valuation_t					valuation_mw_list;
	size_t								extra_depth;
	size_t								j;

	if (node->valuation < enable) {
		return;
	}
	valuation_node = disable;
	for (; 0 < i; --i, --child, --mw_list_p) {
		if (mw_list_p->valuation < enable) {
			continue;
		}
		mwt = mw_list_p->mw_table;
		valuation_mw_list = disable;
		extra_depth = SIZE_MAX;
		for (j = 0; j < mw_list_p->num; ++j, ++mwt) {
			if (mwt->valuation < enable) {
				continue;
			}
			if (mwt->valuation <= valuation) {
				if (strong <= mwt->valuation) {
					/* Ǿäʤ */
				} else if (maxdepth < (node->depth + mwt->extra_depth)) {
					mwt->valuation = block;
				}
			}
			if (enable <= mwt->valuation) {
				valuation_mw_list |= mwt->valuation;
				if (mwt->extra_depth < extra_depth) {
					extra_depth = mwt->extra_depth;
				}
			}
		}
		mw_list_p->valuation = valuation_mw_list;
		if (enable <= valuation_mw_list) {
			child->depth = node->depth + 1 + extra_depth;
			cut_path( Master, child, maxdepth, maxlen, valuation_max );
			if (child->valuation < enable) {
				if ((node->from + i) < maxlen) {
					if (strong <= mw_list_p->valuation) {
						/* Ǿäʤ */
					} else {
						mw_list_p->valuation = disable;
					}
				}
			}
			valuation_node |= mw_list_p->valuation;
		}
	}
	node->valuation = valuation_node;
	if (node->valuation <= valuation) {
		if (maxdepth < node->depth) {
			node->valuation = block;
		}
	}
	return;
}



/** ʸڹ¤ɾ
 *@param[in]		Master			þ
 *@param[in,out]	node			ʸΥΡ
 *@param[in,out]	maxdepth		޴ο줿
 *@param[in,out]	maxlen			޴͡줿Ĺʸ
 *
 *		Sun,16 Nov,2008 - Sat,22 Nov,2008
 *		Mon,19 Jan,2009
 *		Sat,24 Jan,2009, Wed,28 Jan,2009 - Thu,29 Jan,2009
 *		Wed,04 Feb,2009 - Thu,05 Feb,2009
 *		Sun,08 Feb,2009
 *		Tue,24 Feb,2009
 *		Fri,06 Mar,2009 - Sun,08 Mar,2009
 *		Fri,01 May,2009
 */
static void evaluate_path( struct maxlen_fn_phrases_class_t* const Master,
						  struct maxlen_fn_phrases_node_t* const node,
						  size_t* const maxdepth,
						  size_t* const maxlen )
{
	const size_t	from     = node->from;
	const size_t	to       = Master->to;

	size_t								i         = node->max_mw_list;
	struct maxlen_fn_phrases_node_t*	child     = &(node->child[i]);
	struct mw_list_t*					mw_list_p = &(node->mw_list[i]);
	const int							mw_priority = node->priority;
	const int							mw_minlen   = node->minlen;
	const int							mw_score    = node->score;
	int									have_sub_priority;
	int									minlen;
	size_t								left_depth = (*maxdepth) - node->depth;
	int									weak_flag;
	size_t								weak_maxdepth = *maxdepth;
	size_t								weak_maxlen   = *maxlen;
	size_t*								maxdepth_p;
	size_t*								maxlen_p;
	struct mw_table_t*					mwt;
	size_t								j;

	if (NULL == node) {
		return;
	}

	node->valuation = unknown;
	for (; 0 < i; --i, --child, --mw_list_p) {
		const size_t	node_totallen = (from + i);
		size_t			extra_depth   = SIZE_MAX;
		mw_list_p->valuation = disable;

		/* ޴ */
		if ((left_depth <= 0) && (node_totallen < (*maxlen))) {
			continue;
		}
		if (mw_list_p->num <= 0) {
			continue;
		}
		mw_list_p->valuation = unknown;
		{	/* ꥹȤɲ */
			size_t	enable_count = 0;
			mwt = mw_list_p->mw_table;
			weak_flag = 1;
			for (j = 0; j < mw_list_p->num; ++j, ++mwt) {
				struct meta_word* const	mw = mwt->mw;
				const int	current_priority = calc_cmpnode_priority( &MAXLEN_PRIORITY_OF_METAWORD, mw, mw_priority, mw_minlen, &have_sub_priority, &minlen );
				if (mwt->valuation <= disable) {
					continue;
				}
				++enable_count;
				mwt->valuation = weak;
				if (mw_priority <= current_priority) {
					mwt->valuation = normal;
					if (!have_sub_priority) {
						weak_flag = 0;
					} else {
						if ((mw_score <= mw->score)
							&& (!((MW_ochaire_min <= mw->type) && (mw->type <= MW_ochaire_max))
								|| (node->ochaire_phrase_score <= mw->ochaire_phrase_score))
						) {
							mwt->valuation = strong;
							weak_flag = 0;
						}
					}
				}
				if (mwt->extra_depth < extra_depth) {
					extra_depth = mwt->extra_depth;
				}
			}
			if (enable_count < 1) {
				mw_list_p->valuation = disable;
				continue;
			}
		}
		{	/* õ */
			const size_t	node_depth = node->depth + extra_depth;
			if (node_depth <= (*maxdepth)) {
				maxdepth_p = &weak_maxdepth;
				maxlen_p   = &weak_maxlen;
				if (!weak_flag) {
					maxdepth_p = maxdepth;
					maxlen_p   = maxlen;
					if (*maxlen < node_totallen) {
						*maxlen = node_totallen;
					}
				}
				if (weak_maxlen < node_totallen) {
					weak_maxlen = node_totallen;
				}
				if (node_depth < (*maxdepth_p)) {
					if (to <= node_totallen) {
						*maxdepth_p = node_depth;
					} else {
						child->depth = node_depth + 1;
						evaluate_path( Master, child, maxdepth_p, maxlen_p );
					}
					if (!weak_flag) {
						if (weak_maxlen < (*maxlen)) {
							weak_maxlen = *maxlen;
						}
						if ((*maxdepth) < weak_maxdepth) {
							weak_maxdepth = *maxdepth;
						}
						left_depth = (*maxdepth) - node->depth;
					}
				}
			}
		}
	}

	/* ɲäλ޴ */
	if (((*maxlen) < weak_maxlen)
		|| (weak_maxdepth < (*maxdepth))
	) {
		cut_path( Master, node, weak_maxdepth, weak_maxlen, weak );
	}

	return;
}


/** ʸڤڹ¤顢ǹɾ meta_word õ
 *@param[in,out]	Master			þ
 *@param[in]		node			ʸꥹ
 *@param[in]		parent_mw		ƥΡɤκǹɾ meta_word
 *@param[in,out]	mw				ǹɾ meta_word
 *@return							ɾ
 *
 *		Sun,16 Nov,2008 - Fri,21 Nov,2008
 *		Mon,09 Feb,2009
 *		Fri,06 Mar,2009 - Sat,07 Mar,2009
 *		Tue,28 Apr,2009
 *		Sat,14 Nov,2009
 *		Fri,27 Nov,2009
 */
static double get_best_mw( const struct maxlen_fn_phrases_class_t* const Master,
						  const struct maxlen_fn_phrases_node_t* node,
						  struct meta_word* const parent_mw,
						  struct meta_word** const mw )
{
	const enum valuation_t	valuation = node->valuation;
	if (valuation < enable) {
		return 0.0;
	}
	if (!anthy_settings.anthy_mode.lattice.maxlen_mode.puremode) {
		/* §ʸĹץ⡼ */
		size_t								i = node->max_mw_list;
		struct maxlen_fn_phrases_node_t*	child     = &(node->child[i]);
		struct mw_list_t*					mw_list_p = &(node->mw_list[i]);
		struct mw_table_t*					mwt;
		size_t								j;
		struct meta_word*					best_mw = NULL;
		double								current_score;
		double								max_score = -1.0;
		for (; 0 < i; --i, --child, --mw_list_p) {
			if (mw_list_p->valuation < valuation) {
				continue;
			}
			/* ߤΥΡɤĹ i 顢ǹɾʪ */
			current_score = 0.0;
			mwt = mw_list_p->mw_table;
			for (j = 0; j < mw_list_p->num; ++j, ++mwt) {
				if (valuation <= mwt->valuation) {
					const double	node_score =
							(mwt->valuation < strong)
							? (mwt->extra_score + calc_metaword_score( Master->sc, mwt->mw, parent_mw, NULL, NULL ))
							: mwt->mw->score;
					if (current_score < node_score) {
						current_score = node_score;
						best_mw       = mwt->mw;
					}
				}
			}
			if (valuation < strong) {
				/* ҥΡɤɾȹ绻Ƚ */
				if (enable <= child->valuation) {
					const double	child_score = get_best_mw( Master, child, best_mw, NULL );
					current_score = (child_score + current_score) / 2;
				}
			} else {
				/* ͥ strong ξϡΡɤɾΤߤǷ */
			}
			if (max_score == current_score) {
				if ((MW_OCHAIREwithoutDEP == best_mw->type)
					|| (MW_OCHAIREwithoutINDEPwithoutDEP == best_mw->type)
				) {
					/* °̵ؽĹ䤬ƱξϡĹʸͥ */
				} else {
					/* ʳƱξϡûʸͥ */
					if (mw) {
						*mw = best_mw;
					}
				}
			} else if (max_score < current_score) {
				max_score = current_score;
				if (mw) {
					*mw = best_mw;
				}
			}
		}
		return max_score;
	} else {
		/* ʸĹץ⡼ */
		struct mw_list_t*					mw_list_p = node->mw_list;
		struct mw_table_t*					mwt;
		size_t								i, j;
		for (i = 1, ++mw_list_p; i <= node->max_mw_list; ++i, ++mw_list_p) {
			if (mw_list_p->valuation < valuation) {
				continue;
			}
			mwt = mw_list_p->mw_table;
			for (j = 0; j < mw_list_p->num; ++j, ++mwt) {
				if (valuation <= mwt->valuation) {
					if (mw) {
						*mw = mwt->mw;
					}
					return 0.0;
				}
			}
		}
	}
	return 0.0;
}



/** ڤäʸФ best_mw ꤹ
 *@param[in,out]	wsic			
 *@param[in]		mw				ϸ mw
 *
 *		Thu,20 Nov,2008
 *		Sat,24 Jan,2009
 *		Sun,08 Feb,2009
 */
static void
set_bestmw_by_metaword( struct word_split_info_cache* const wsic,
					   struct meta_word* const mw )
{
	if (!wsic || !mw) {
		return;
	}

	switch (mw->type) {
	case MW_DUMMY:
	case MW_SINGLE:
	case MW_COMPOUND_PART:
		break;
	case MW_COMPOUND_LEAF:
		wsic->best_mw[mw->from] = mw;
		mw->can_use = ok;
		break;
	case MW_COMPOUND_HEAD:
	case MW_COMPOUND:
	case MW_NUMBER:
		if (mw->mw1) {
			wsic->best_mw[mw->mw1->from] = mw->mw1;
		}
		set_bestmw_by_metaword( wsic, mw->mw1 );
		set_bestmw_by_metaword( wsic, mw->mw2 );
		break;
	case MW_V_RENYOU_A:
	case MW_V_RENYOU_NOUN:
		break;
	case MW_WRAP:
		set_bestmw_by_metaword( wsic, mw->mw1 );
		break;
	case MW_OCHAIRE:
	case MW_OCHAIREwithoutDEP:
	case MW_OCHAIREwithoutINDEP:
	case MW_OCHAIREwithoutINDEPwithoutDEP:
		set_bestmw_by_metaword( wsic, mw->mw1 );
		break;
	case MW_CANDHISTORY:
		break;
	case MW_END:
	default:
		break;
	}
	return;
}

/** ʸĹˡʸڤ
 *@param[in,out]	sc			ʸڤδþ
 *@param			from		Ϥʸ
 *@param			to			λʸ
 *
 *@note
 *	âƱʸƱĹä硢
 *	Υ르ꥺɤʤиʸ᤬Ĺ򤵤뤬
 *	Ǥϥƥ༭پǷƤ롣
 *
 *		Sun,16 Nov,2008 - Fri,21 Nov,2008
 *		Fri,06 Mar,2009 - Sun,08 Mar,2009
 *		Sat,02 May,2009
 */
void choose_path_by_maxlen_n_phrases( struct splitter_context* const sc,
									 size_t from, size_t to )
{
	if (NULL == sc->word_split_info) {
		return;
	}
	{
		struct maxlen_fn_phrases_class_t Master
		= {
			.sc          = sc,
			.to          = to,
			.mw_list     = alloca( sizeof(struct mw_list_t*) * (to + 1) ),
			.max_mw_list = alloca( sizeof(size_t) * (to + 1) ),
			.maxdepth    = anthy_settings.anthy_mode.lattice.maxlen_mode.phrases,
			.root_node = {
				.parent          = NULL,
				.child           = NULL,
				.mw_list         = NULL,
				.max_mw_list     = 0,
				.from            = from,
				.depth           = 1,
			},
		};
		struct maxlen_fn_phrases_node_t*	node = &(Master.root_node);
		/* Attach */
		{	struct mw_list_t**	list = Master.mw_list;
			size_t*				max_mw_list = Master.max_mw_list;
			size_t	i;
			for (i = 0; i <= Master.to; ++i, ++list, ++max_mw_list) {
				*list = NULL;
				*max_mw_list = 0;
			}
		}

		/* Process */
		{	size_t				maxdepth;
			size_t				maxlen;
			struct meta_word*	mw = NULL;
			struct maxlen_fn_phrases_node_t*	parent;
			struct maxlen_fn_phrases_node_t*	child;
			size_t								i;
			struct mw_list_t**					list_p;
			size_t								j;
			struct mw_list_t*					list;

			while (from < to) {
				/* ١쥯 */
				parent = node->parent;
				if (parent) {
					{
						i = parent->max_mw_list;
						child = &(parent->child[i]);
						list = &(parent->mw_list[i]);
						for (; 0 < i; --i, --child, --list) {
							if (mw->len == i) {
								continue;
							}
							free_maxlen_n_phrases_node( child );
							child->max_mw_list = 0;
							child->child       = NULL;
							child->mw_list     = NULL;
							free( list->mw_table );
							list->mw_table = NULL;
						}
					}
					{
						i = parent->from;
						list_p = &(Master.mw_list[i]);
						for (; i < node->from; ++i, ++list_p) {
							if (*list_p) {
								j = Master.max_mw_list[i];
								Master.max_mw_list[i] = 0;
								list = &((*list_p)[j]);
								for (; 0 < j; --j, --list) {
									free( list->mw_table );
								}
								free( *list_p );
								*list_p = NULL;
							}
						}
					}
				}

				/* ʬõ */
				maxdepth = anthy_settings.anthy_mode.lattice.maxlen_mode.phrases;
				maxlen = 0;
				mw = NULL;

				node->depth = 1;
				build_path( &Master, node );
				evaluate_path( &Master, node, &maxdepth, &maxlen );
				cut_path( &Master, node, maxdepth, maxlen, valuation_max );
				get_best_mw( &Master, node, NULL, &mw );

				if (mw) {
					set_bestmw_by_metaword( sc->word_split_info, mw );
					from += mw->len;
					if (to <= from) {
						from = to;
					} else {
						node = &(node->child[mw->len]);
					}
					sc->word_split_info->best_seg_class[mw->from] = mw->seg_class;
					sc->word_split_info->seg_border[from] = 1;
				} else {
					from = to;
					sc->word_split_info->seg_border[from] = 1;
				}
			}
		}

		/* Detach */
		free_maxlen_n_phrases_node( &(Master.root_node) );
		{	size_t	i;
			struct mw_list_t**	list_p = Master.mw_list;
			for (i = 0; i <= Master.to; ++i, ++list_p) {
				if (*list_p) {
					size_t	j = Master.max_mw_list[i];
					struct mw_list_t*	list = &((*list_p)[j]);
					for (; 0 < j; --j, --list) {
						free( list->mw_table );
					}
					free( *list_p );
				}
			}
		}
	}
	return;
}

/* [ End of File ] */
/* vim:ts=4 sw=4 nomodified:
 */
