/**@file
 *			Patches for Anthy, by G-HAL
 *@brief	metaword
 *@date		Tue,04 Nov,2008
 *@date		Sat,24 Jan,2009
 *@date		Sat,21 Feb,2009
 *@date		Sun,26 Apr,2009 - Mon,27 Apr,2009
 *@date		Fri,01 May,2009
 *@date		Thu,14 Oct,2010
 *@author	Copyright(C)2008-2010 G-HAL
 */

#ifndef	_metaword_h_included_
#define	_metaword_h_included_

#include "anthy/xstr.h"
#include "anthy/splitter.h"
#include "src-splitter/wordborder.h"
#include "anthy/ordering.h"

#ifdef __cplusplus
extern "C" {
#endif


/* src-splitter/metaword_cmp.c */
extern int mw_is_match( const xchar* const yomi, const struct meta_word* const mw0, const struct meta_word* const mw );

/* src-splitter/metaword.c */
extern struct meta_word* const alloc_metaword( struct splitter_context* const sc );

/* src-splitter/metaword_bylearn.c */
extern void anthy_make_metaword_by_candhistory( struct splitter_context* const sc );
extern void anthy_make_metaword_by_ochaire( struct splitter_context* const sc );
extern void anthy_make_metaword_by_keepaliveochaire( struct splitter_context* const sc );
extern void anthy_make_metaword_by_keepalivecompound( struct splitter_context* const sc );


#ifdef __cplusplus
}
#endif

#endif /* _metaword_h_included_ */
/* [ End of File ] */
/* vim:ts=4 sw=4 nomodified:
 */
