#if 0		/* Patched by G-HAL */
#include <string.h>

#include <anthy/splitter.h>
#include <anthy/wtype.h>
#include <anthy/segclass.h>
#include "wordborder.h"
#else
#if defined(HAVE_CONFIG_H)
# include "config.h"
#endif

#if defined(HAVE_STDLIB_H)
# include <stdlib.h>
#endif
#if defined(HAVE_STRING_H)
# include <string.h>
#endif
#if defined(HAVE_STRINGS_H)
# include <strings.h>
#endif

#include "anthy/splitter.h"
#include "anthy/wtype.h"
#include "anthy/segclass.h"
#include "wordborder.h"
#endif

/** dep_class ̾ΰ
 * Patched by G-HAL
 *	Fri,01 May,2009, Tue,19 May,2009
 *@attention
 *	anthy/segclass.h  enum dep_class ȹ碌ʤФʤʤ
 */
static const struct {
  const char *name;
  const char *sym;
} dep_class_tab[] = {
  {"ʤ", "S-"},
  {"", "Sf"},
  {"ʽ", "Sk"},
  {"Ϣ", "Sy"},
  {"Ϣ", "St"},
  {"ü", "Se"},
  {"ñ", "Sr"},
  {"ʸ", "Sz"},
  {"ٹ+", "Sp+"},
  {"ٹ-", "Sp-"},
  {NULL, NULL}
};

/** seg_class ̾ΰ
 *@attention
 *	anthy/segclass.h  enum seg_class ȹ碌ʤФʤʤ
 */
static const struct {
  const char *name;
  const char *sym;
} seg_class_tab[] = {
  {"ʸƬ", "H"}, {"ʸ", "T"}, {"ʸ", "B"},
  {"³", "C"}, {"̾+ʽ", "Nk"}, {"̾+ü", "Ne"},
  {"ư+°", "Vf"}, {"ư+ü", "Ve"}, {"ƻ", "A"},
  {"ư", "AJV"},
  {"Ϣѽ", "YM"}, {"Ϣν", "TM"},
  {"̾", "N"}, {"̾+°", "Nf"}, {"̾+Ϣ", "Ny"},
  {"ư+Ϣ", "Vy"},
  {"ư+Ϣ", "Vt"},
  {"ñ", "KJ"},		/* Patched by G-HAL, Thu,30 Apr,2009 */
  {NULL, NULL}
};

void
anthy_set_seg_class(struct word_list* wl)
{
  int head_pos;
  enum dep_class dc;
  enum seg_class seg_class;

  if (!wl) return;

  head_pos = wl->head_pos;
  dc = wl->part[PART_DEPWORD].dc;
  seg_class = SEG_HEAD;

  if (wl->part[PART_CORE].len == 0) {
    seg_class = SEG_BUNSETSU;
  } else {
    switch (head_pos) {
    case POS_NOUN:
    case POS_NUMBER:
      /* BREAK THROUGH */
    case POS_N2T:
      if (dc == DEP_RAW) {
	seg_class = SEG_MEISHI;
     #if 0	/* Patched by G-HAL, Thu,30 Apr,2009 */
      } else if (dc == DEP_END) {
     #else
      } else if ((dc == DEP_END) || (DEP_EOS == dc)) {
     #endif
	seg_class = SEG_MEISHI_SHUTAN;
      } else if (dc == DEP_RENYOU) {
	seg_class = SEG_MEISHI_RENYOU;
      } else if (dc == DEP_KAKUJOSHI) {
	seg_class = SEG_MEISHI_KAKUJOSHI;
      } else {
	seg_class = SEG_MEISHI_FUZOKUGO;
      }
      break;
    case POS_V:
      if (dc == DEP_RAW) {
	seg_class = SEG_BUNSETSU;
     #if 0	/* Patched by G-HAL, Thu,30 Apr,2009 */
      } else if (dc == DEP_END) {
     #else
      } else if ((dc == DEP_END) || (DEP_EOS == dc)) {
     #endif
	seg_class = SEG_DOUSHI_SHUTAN;
      } else if (dc == DEP_RENYOU) {
	seg_class = SEG_DOUSHI_RENYOU;
      } else if (dc == DEP_RENTAI) {
	seg_class = SEG_DOUSHI_RENTAI;
      } else {
	seg_class = SEG_DOUSHI_FUZOKUGO;
      }
      break;
    case POS_D2KY:
      /* BREAK THROUGH */
    case POS_A:
      seg_class = SEG_KEIYOUSHI;
      if (dc == DEP_RENYOU) {
	seg_class = SEG_RENYOU_SHUSHOKU;
      } else if (dc == DEP_RENTAI) {
	seg_class = SEG_RENTAI_SHUSHOKU;
      }
      break;
    case POS_AJV:
      seg_class = SEG_KEIYOUDOUSHI;
      if (dc == DEP_RENYOU) {
	seg_class = SEG_RENYOU_SHUSHOKU;
      } else if (dc == DEP_RENTAI) {
	seg_class = SEG_RENTAI_SHUSHOKU;
      }
      break;
    case POS_AV:
      seg_class = SEG_RENYOU_SHUSHOKU;
      break;
    case POS_ME:
      seg_class = SEG_RENTAI_SHUSHOKU;
      break;
    case POS_CONJ:
      seg_class = SEG_SETSUZOKUGO;
      break;
    case POS_OPEN:
      seg_class = SEG_BUNSETSU;
      break;
    case POS_CLOSE:
      seg_class = SEG_BUNSETSU;
      break;
    case POS_TANKANJI:		/* Patched by G-HAL, Thu,30 Apr,2009 */
      seg_class = SEG_TANKANJI;
      break;
    default:
      seg_class = SEG_MEISHI;
      break;
    }
  }
  wl->seg_class = seg_class;
}

const char* anthy_seg_class_name(enum seg_class sc)
{
  return seg_class_tab[sc].name;
}

const char* anthy_seg_class_sym(enum seg_class sc)
{
  return seg_class_tab[sc].sym;
}

/* Patched by G-HAL, Fri,01 May,2009 */
const char* const anthy_dep_class_sym( enum dep_class dc )
{
  return dep_class_tab[dc].sym;
}

enum seg_class
anthy_seg_class_by_name(const char *name)
{
  int i;
  for (i = 0; seg_class_tab[i].name; i++) {
    if (!strcmp(seg_class_tab[i].name, name)) {
      return (enum seg_class) i;
    }
  }
  return SEG_BUNSETSU;
}
/* vim:ts=8 sw=2 nomodified:
 */
