/**@file
 *@brief	heap-buffer treatment class, have esptimation value version
 *
 *@date	Tue,07 Jan,2003, Fri,24 Jan,2003
 *@date	Thr,20 Feb,2003
 *@date	Thr,05 Jun,2003 - Fri,06 Jun,2003
 *@date	Sat,14 Jun,2003
 *@date	Thr,05 Aug,2004
 *@date	Fri,12 Jan,2007
 *@date	Thu,01 May,2008 - Sat,03 May,2008
 *@date	Thu,28 Aug,2008
 *@date	Tue,12 Oct,2010 - Thu,14 Oct,2010, Sun,12 Dec,2010
 *@date	Sun,14 Aug,2011 - Fri,19 Aug,2011
 *
 *@author	Copyright(C)2003-2004,2007,2008,2010,2011 G-HAL
 *
 *@note
 *		ɾ var ǾȤʤǤˤʤ롣
 */
#ifndef _HEAPT_H_
#define _HEAPT_H_

#if defined(HAVE_CONFIG_H)
# include "config.h"
#endif

#if defined(HAVE_STDBOOL_H)
# include <stdbool.h>
#else
# if !defined(HAVE__BOOL)
#  if defined(__cplusplus)
typedef bool _Bool;
#  else
typedef unsigned char _Bool;
#  endif
# endif
# define	bool	_Bool
# define	false	0
# define	true	1
# define	__bool_true_false_are_defined	1
#endif
#if !defined(__STDC_LIMIT_MACROS)
# define __STDC_LIMIT_MACROS
#endif
#if !defined(__STDC_CONSTANT_MACROS)
# define __STDC_CONSTANT_MACROS
#endif
#if defined(HAVE_STDINT_H)
# include <stdint.h>
#endif
#if !defined(__STDC_FORMAT_MACROS)
# define __STDC_FORMAT_MACROS
#endif
#if defined(HAVE_INTTYPES_H)
# include <inttypes.h>
#endif
#if defined(HAVE_CSTDINT)
# include <cstdint>
#endif
#if defined(HAVE_LIMITS_H)
# include <limits.h>
#endif
#if defined(HAVE_SYS_LIMITS_H)
# include <sys/limits.h>
#endif
#if defined(HAVE_FLOAT_H)
# include <float.h>
#endif
#if defined(HAVE_NEW)
# include <new>
#endif
#if defined(HAVE_STDEXCEPT)
# include <stdexcept>
#endif
#if defined(HAVE_EXCEPTION)
# include <exception>
#endif

#if !defined(pr_debug)
# define	pr_debug(fmt,arg...)
#endif

#if !defined(HEAP_INLINE)
# define	HEAP_INLINE
#else
# undef		HEAP_INLINE
# define	HEAP_INLINE	inline
#endif


template<class Type, typename Var> class HeapT{
	public:
		class range_error : public std::exception {
		public:
			range_error() throw() { return; }
			virtual ~range_error() throw();
		};
		class out_of_range : public std::exception {
		public:
			out_of_range() throw() { return; }
			virtual ~out_of_range() throw();
		};

	private:
		struct TypeP{
			Type	dat;
			Var		var;
		};
		TypeP*		buf_;		///< ݻǡ
		TypeP*		buf_1;		///< ͭƬǡ
		size_t		size_;		///< ݺѤߥ
		size_t		step_;		///< ɲóݤΥƥå׿
		size_t		wptr_;		///< ݥ
		TypeP*		wpptr;		///< ݥ󥿤λؤ֥å

		HEAP_INLINE void	rise( size_t ptr, Type dat, Var var );
		HEAP_INLINE void	sink( size_t ptr, Type dat, Var var );

	public:
				// I need more smart way...
		#define	VMIN_D	((static_cast<Var>(DBL_MIN))   < 0      ? (static_cast<Var>(DBL_MIN))   : 0)
		#define	VMIN_F	((static_cast<Var>(FLT_MIN))   < VMIN_D ? (static_cast<Var>(FLT_MIN))   : VMIN_D)
	  #if defined(LLONG_MIN)
		#define	VMIN_LL	((static_cast<Var>(LLONG_MIN)) < VMIN_F ? (static_cast<Var>(LLONG_MIN)) : VMIN_F)
	  #else
		#define	VMIN_LL	VMIN_F
	  #endif
		#define	VMIN_L	((static_cast<Var>(LONG_MIN))  < VMIN_LL? (static_cast<Var>(LONG_MIN)) : VMIN_LL)
		#define	VMIN_I	((static_cast<Var>(INT_MIN))   < VMIN_L ? (static_cast<Var>(INT_MIN))   : VMIN_L)
		#define	VMIN_S	((static_cast<Var>(SHRT_MIN))  < VMIN_I ? (static_cast<Var>(SHRT_MIN))  : VMIN_I)
		#define	VMIN_C	((static_cast<Var>(CHAR_MIN))  < VMIN_S ? (static_cast<Var>(CHAR_MIN))  : VMIN_S)
		#define	VMIN_SC	((static_cast<Var>(SCHAR_MIN)) < VMIN_C ? (static_cast<Var>(SCHAR_MIN)) : VMIN_C)
		#define	VMIN	VMIN_SC

				// I need more smart way...
		#define	VMAX_D	((0      < static_cast<Var>(DBL_MAX))   ? (static_cast<Var>(DBL_MAX))   : 0)
		#define	VMAX_F	((VMAX_D < static_cast<Var>(FLT_MAX))   ? (static_cast<Var>(FLT_MAX))   : VMAX_D)
	  #if defined(LLONG_MAX)
		#define	VMAX_ULL ((VMAX_F  <static_cast<Var>(ULLONG_MAX))? (static_cast<Var>(ULLONG_MAX)): VMAX_F)
		#define	VMAX_SLL ((VMAX_ULL<static_cast<Var>(LLONG_MAX)) ? (static_cast<Var>(LLONG_MAX)) : VMAX_ULL)
	  #else
		#define	VMAX_ULL	VMAX_F
		#define	VMAX_SLL	VMAX_ULL
	  #endif
		#define	VMAX_UL	((VMAX_SLL< static_cast<Var>(ULONG_MAX)) ? (static_cast<Var>(ULONG_MAX)) : VMAX_SLL)
		#define	VMAX_SL	((VMAX_UL < static_cast<Var>(LONG_MAX))  ? (static_cast<Var>(LONG_MAX))  : VMAX_UL)
		#define	VMAX_UI	((VMAX_SL < static_cast<Var>(UINT_MAX))  ? (static_cast<Var>(UINT_MAX))  : VMAX_SL)
		#define	VMAX_SI	((VMAX_UI < static_cast<Var>(INT_MAX))   ? (static_cast<Var>(INT_MAX))   : VMAX_UI)
		#define	VMAX_US	((VMAX_SI < static_cast<Var>(USHRT_MAX)) ? (static_cast<Var>(USHRT_MAX)) : VMAX_SI)
		#define	VMAX_SS	((VMAX_US < static_cast<Var>(SHRT_MAX))  ? (static_cast<Var>(SHRT_MAX))  : VMAX_US)
		#define	VMAX_UC	((VMAX_SS < static_cast<Var>(UCHAR_MAX)) ? (static_cast<Var>(UCHAR_MAX)) : VMAX_SS)
		#define	VMAX_SC	((VMAX_UC < static_cast<Var>(SCHAR_MAX)) ? (static_cast<Var>(SCHAR_MAX)) : VMAX_UC)
		#define	VMAX	VMAX_SC


	  #if defined(HEAP_BENCH)
		long	sink_count, rise_count;
	  #endif

	  #if defined(USE_THROW)
		HEAP_INLINE explicit HeapT( size_t param_size = 0, size_t param_step_size = 16 )
				throw (std::bad_alloc);
	  #else
		HEAP_INLINE explicit HeapT( size_t param_size = 0, size_t param_step_size = 16 );
	  #endif
		HEAP_INLINE ~HeapT( void );

		HEAP_INLINE bool	print( void (*func)(Type) ) const;	///< ǡɽ
		inline bool			show( void (*func)(Type) ) const	///< ǡɽ
				{ return print(func); };

	  #if defined(USE_THROW)
		HEAP_INLINE bool	in( Type dat, Var var )
				throw (range_error);							///< Ǽ
		inline bool			put( Type dat, Var var )
				throw (range_error)								///< Ǽ
				{ return in(dat,var); }
	  #else
		HEAP_INLINE bool	in( Type dat, Var var );			///< Ǽ
		inline bool			put( Type dat, Var var )			///< Ǽ
				{ return in(dat,var); }
	  #endif

		HEAP_INLINE Type* const	top( void );					///< 
		HEAP_INLINE Var* const	top_var( void );				///< 

		HEAP_INLINE bool	out( Type* dat );					///< 
		inline bool			get( Type* dat )					///< 
				{ return out(dat); }

	  #if defined(USE_THROW)
		inline	Type	operator[]( size_t ptr ) const
				throw (out_of_range);							///< 
	  #else
		inline	Type	operator[]( size_t ptr ) const;			///< 
	  #endif
		inline	void	clear( void );							///< 
		inline	size_t	size( void ) const;						///< 
		inline	size_t	active( void ) const;					///< ǼѤ
		inline	size_t	empty( void ) const;					///< 
};



template<class Type, typename Var> HEAP_INLINE HeapT<Type,Var>::HeapT( size_t param_size, size_t param_step_size )
#if defined(USE_THROW)
	throw (std::bad_alloc)
#endif
{
	size_ = 0;
	wptr_ = 0;
	wpptr = buf_ = NULL;
  #if defined(HEAP_BENCH)
	rise_count = sink_count = 0;
  #endif
	if (0 < param_size) {
		buf_ = new(std::nothrow) TypeP[param_size+1];
		if (NULL == buf_) {
			this->~HeapT();
		  #if defined(USE_THROW)
			throw std::bad_alloc();
		  #else
			pr_debug("HeapT: %p(%zu)->HeapT(): Out of memory.\n",
							this, param_size );
		  #endif
			return;
		}
		size_ = param_size;
		// buf_[0].dat = NULL;
		buf_[0].var = VMIN;
		buf_1 = &(buf_[1]);
		clear();
	}
	if (0 < param_step_size) {
		step_ = param_step_size;
	} else {
	  #if defined(USE_THROW)
		throw std::bad_alloc();
	  #else
		pr_debug("HeapT: %p(%zu)->HeapT(%zu): Invalid value at param_step_size.\n",
				 this, param_size, param_step_size );
	  #endif
		step_ = 16;
	}
	return;
}


template<class Type, typename Var> HEAP_INLINE HeapT<Type,Var>::~HeapT()
{
	if (NULL != buf_) {
		delete[] buf_;
		size_ = 0;
		buf_1 = buf_ = NULL;
	}
	wptr_ = 0;
	wpptr = NULL;
  #if defined(HEAP_BENCH)
	fprintf(stderr,
				"%s:%d: Heap Benchmark Result: Sink = %ld, Rise = %ld\n",
				__FILE__, __LINE__, static_cast<long>(sink_count), static_cast<long>(rise_count) );
  #endif
	return;
}


template<class Type, typename Var> inline void HeapT<Type,Var>::clear( void )
{
	wptr_ = 1;
	wpptr = buf_1;
	return;
}



template<class Type, typename Var> HEAP_INLINE bool HeapT<Type,Var>::print( void (*func)(Type) ) const
{
	if (wptr_ <= 1) {
		return false;
	}
	for (TypeP* pptr = buf_1; pptr < wpptr; ++pptr) {
		(*func)( pptr->dat );
	}
	return true;
}



template<class Type, typename Var> HEAP_INLINE void HeapT<Type,Var>::rise( size_t ptr, Type dat, Var var )
{
	size_t	uptr;
	Var		uvar;

	goto LP;
	do {
		buf_[ptr].var = uvar;
		buf_[ptr].dat = buf_[uptr].dat;
	  #if defined(HEAP_BENCH)
		rise_count++;
	  #endif
		ptr = uptr;
	LP:
		uptr = size_t(ptr / 2);
		uvar = buf_[uptr].var;
	} while (var < uvar);

	buf_[ptr].dat = dat;
	buf_[ptr].var = var;
	return;
}

template<class Type, typename Var> HEAP_INLINE void HeapT<Type,Var>::sink( size_t ptr, Type dat, Var var )
{
	size_t	dptr, lptr, rptr;
	Var		dvar, lvar, rvar;

	goto LP;
	do {
		dptr = (lvar <= rvar) ? lptr : rptr ;
		buf_[ptr].var = dvar;
		buf_[ptr].dat = buf_[dptr].dat;
	  #if defined(HEAP_BENCH)
		sink_count++;
	  #endif
		ptr = dptr;
	LP:
		lptr = ptr * 2;
		lvar = (lptr < wptr_) ? buf_[lptr].var : VMAX;
		rptr = lptr + 1;
		rvar = (rptr < wptr_) ? buf_[rptr].var : VMAX;
		dvar = (lvar <= rvar) ? lvar : rvar ;
	} while (dvar <= var);

	buf_[ptr].dat = dat;
	buf_[ptr].var = var;
	return;
}



template<class Type, typename Var> HEAP_INLINE bool HeapT<Type,Var>::in( Type dat, Var var )
#if defined(USE_THROW)
	throw (range_error)
#endif
{
	if (size_ < wptr_) {
		size_ += step_;
	  #if defined(CHECK)
		if (size_ < wptr_) {
			size_ = wptr_;
		}
	  #endif
		TypeP* const ret_buf = static_cast<TypeP*>( realloc( buf_, sizeof(TypeP[size_+1])) );
		if (NULL == ret_buf) {
		  #if defined(USE_THROW)
			throw std::bad_alloc();
			return false;
		  #else
			pr_debug("HeapT: %p(%zu)->in(%p): Out of memory.\n",
					 this, param_size, dat );
			return false;
		  #endif
		}
		buf_ = ret_buf;
	}
  #if defined(CHECK)
	if ((var <= VMIN) || (VMAX <= var)) {
	  #if defined(USE_THROW)
		throw range_error();
	  #else
		pr_debug("HeapT: %p(%zu)->in(%p): var is out of range.\n",
						this, this->size_, dat );
		abort();
	  #endif
	}
  #endif
	rise( wptr_, dat, var );
	wptr_++;	wpptr++;
	return true;
}



template<class Type, typename Var> HEAP_INLINE Type* const HeapT<Type,Var>::top( void )
{
	if (wptr_ <= 1) {
		return NULL;
	}
  #if defined(CHECK)
	if (NULL != dat) {
		return &(buf_1->dat):;
	} else {
		return NULL;
	}
  #else
	return &(buf_1->dat);
  #endif
}

template<class Type, typename Var> HEAP_INLINE Var* const HeapT<Type,Var>::top_var( void )
{
	if (wptr_ <= 1) {
		return NULL;
	}
  #if defined(CHECK)
	if (NULL != dat) {
		return &(buf_1->var);
	} else {
		return NULL;
	}
  #else
	return &(buf_1->var);
  #endif
}



template<class Type, typename Var> HEAP_INLINE bool HeapT<Type,Var>::out( Type* dat )
{
	if (wptr_ <= 1) {
		return false;
	}
  #if defined(CHECK)
	if (NULL != dat) {
		*dat = buf_1->dat;
	}
  #else
	*dat = buf_1->dat;
  #endif
	--wptr_;	--wpptr;
	sink( 1, wpptr->dat, wpptr->var );
	return true;
}



template<class Type, typename Var> inline Type HeapT<Type,Var>::operator[]( size_t ptr ) const
#if defined(USE_THROW)
	throw (out_of_range)
#endif
{
  #if defined(CHECK)
	if ((0 <= ptr) && (ptr <= size_)) {
		return buf_[ptr].dat;
	} else {
	  #if defined(USE_THROW)
		throw out_of_range();
	  #else
		pr_debug("HeapT: %p(%zu)->operator[%zu]: Size over flow\n",
						this, this->size_, ptr );
		abort();
	  #endif
	}
  #else
	return buf_[ptr].dat;		// 
  #endif
}


template<class Type, typename Var> inline size_t HeapT<Type,Var>::size( void ) const
{
	return size_;
}

template<class Type, typename Var> inline size_t HeapT<Type,Var>::active( void ) const
{
	return (wptr_ - 1);
}

template<class Type, typename Var> inline size_t HeapT<Type,Var>::empty( void ) const
{
	return ( size() - active() );
}

#endif /* _HEAPT_H_ */
/* [ End of File ] */
/* vim:ts=4 sw=4 nomodified:
 */
