/*
*stdio for Charactor Shell
*(C) 2014 VOSystems.
*/

#include<stdio.h>
#include<string.h>
#include<KeyBoard.h>
#include<scancode.h>
#include<stdarg.h>
/*
COLOR

BRACK, BLUE, GREEN, CIAN, RED, MASENTA
BRAWN, GLAY, D_GLAY, CH_BLUE, CH_GREE
CH_CIAN, PINK, CH_MAS, YELLOW, WHITE
*/

#define COLUMNS (80)
#define LINES (24)
#define ATTRIBUTE (7)

int asm_move_cursol(int ebp);

unsigned short* screen;
char attr;
unsigned int X,Y;

int kbhit(void)
{
	return Generate_Scancode_To_ASCII_Code();
}
void scanf(const char* fmt,...)
{
	va_list arg;
	va_start(arg,char*,fmt);
	char ch=*fmt++;
	unsigned int count=0;
	
	while(ch!='\0'){
	
		if(ch=='%'){
			ch=*fmt++;
			
			if(ch=='d'){
				int buf=0;	char chbuf=0;
				count=0;
				while(1){
					chbuf=getch();
					buf*=10;
					
					if(chbuf=='1'){
						buf+=1;
						putchar(chbuf);
						++count;
					}else if(chbuf=='2'){
						buf+=2;
						putchar(chbuf);
						++count;
					}else if(chbuf=='3'){
						buf+=3;
						putchar(chbuf);
						++count;
					}else if(chbuf=='4'){
						buf+=4;
						putchar(chbuf);
						++count;
					}else if(chbuf=='5'){
						buf+=5;
						putchar(chbuf);
						++count;
					}else if(chbuf=='6'){
						buf+=6;
						putchar(chbuf);
						++count;
					}else if(chbuf=='7'){
						buf+=7;
						putchar(chbuf);
						++count;
					}else if(chbuf=='8'){
						buf+=8;
						putchar(chbuf);
						++count;
					}else if(chbuf=='9'){
						buf+=9;
						putchar(chbuf);
						++count;
					}else if(chbuf=='0'){
						buf+=0;
						putchar(chbuf);
						++count;
					}else if(chbuf=='\b' && count>=0){
						buf/=10;
						putchar(chbuf);
						--count;
					}else{
						buf/=10;
						va_arg(arg,int)=buf;
						break;
					}
				}
			}else if(ch=='s'){
				char *cmd;	cmd=va_arg(arg,char*);
				count=0;
				do{
					*cmd=getch();
					if(*cmd=='\n'){
						putchar(*cmd);
						*cmd='\0';
						break;
						
					}else if(*cmd==' '){
						putchar(' ');
						*cmd='\0';
						break;
						
					}else if(*cmd=='\b' && count>0){
						*cmd-- = '\0';
						count--;
						putchar('\b');
						
					}else{
						putchar(*cmd);
						count++;
						cmd++;
						
					}
				}while(1);
			
			}else if(ch=='c'){
				va_arg(arg,char)=getchar();
			}
		}
		ch=*fmt++;
	}
}

char getchar(void)
{
	char code=0;
	while(code==0)
	{
		code=Generate_Scancode_To_ASCII_Code();
	}
	putchar(code);
	return code;
}

char getch(void)
{
	char code=0;
	while(code==0)
	{
		code=Generate_Scancode_To_ASCII_Code();
	}
	return code;
}

void ClearScreen(void)
{
	screen=(unsigned short*)0xb8000;
	X=0;Y=0;
	while(screen<(unsigned short*)0xc0000)
	{
		*screen++ =NUM_NULL;
	}
	screen=(unsigned short*)0xb8000;
	return;
}

void puts(const char* msg)
{
	
	char ch;
	ch=*msg++;
	
	while(ch!='\0')
	{
		putchar(ch);
		ch=*msg++;
	}
	return;
}

void putchar(const char ch)
{
	if(ch=='\n'){
		screen+=(80-X);/*80 charactors * 2byte - X charactors * 2 byte*/
		Y+=1;
		X=0;
		
	}else if(ch=='\t'){
		*screen++ = (((attr)<<8) | ' ');
		*screen++ = (((attr)<<8) | ' ');
		X+=2;
		
	}else if(ch=='\r'){
		while(X>0)
		{
			*screen-- = (unsigned short)NUM_NULL;
			--X;
		}
	
	}else if(ch=='\b'){
		screen--;
		*screen = (unsigned short)NUM_NULL;
		--X;
		
	}else{
		*screen++ = (((attr)<<8) | ch);
		X+=1;
	}
	return;
}

void printTASK(const char* msg)
{
	puts("[....]");
	attr=WHITE;
	puts(msg);
	return;
}

void printOK(const char* msg)
{
	putchar('\r');
	attr=WHITE;
	puts("[ ");
	attr=GREEN;
	puts("ok");
	attr=WHITE;
	puts(" ]");

	attr=WHITE;
	puts(msg);
	puts("done.\n");
	return;
}

void printFAIL(const char* msg)
{
	putchar('\r');
	attr=WHITE;
	puts("[");
	attr=RED;
	puts("fail");
	attr=WHITE;
	puts("]");

	attr=WHITE;
	puts(msg);
	puts("\n");
	return;
}

void printWARN(const char* msg)
{
	putchar('\r');
	attr=WHITE;
	puts("[");
	attr=YELLOW;
	puts("warn");
	attr=YELLOW;
	puts("]");

	attr=WHITE;
	puts(msg);
	puts("done.\n");
	return;
}

void printINFO(const char* msg)
{
	putchar('\r');
	attr=WHITE;
	puts("[");
	attr=CH_BLUE;
	puts("info");
	attr=WHITE;
	puts("]");

	attr=WHITE;
	puts(msg);
	return;
}

char * uint_to_str_big_hex(char *buf, unsigned src, int base) {
  char *p = buf;
  char *p1, *p2;

  do {
    *p++ = "0123456789ABCDEF"[src%base];
  } while(src /= base);

  // Terminate BUF
  *p = 0;

  // Reverse BUF
  for(p1=buf, p2=p-1; p1 < p2; p1++, p2--) {
    char tmp = *p1;
    *p1 = *p2;
    *p2 = tmp;
  }

  return buf;
}

char * uint_to_str_small_hex(char *buf, unsigned src, int base) {
  char *p = buf;
  char *p1, *p2;

  do {
    *p++ = "0123456789abcdef"[src%base];
  } while(src /= base);

  // Terminate BUF
  *p = 0;

  // Reverse BUF
  for(p1=buf, p2=p-1; p1 < p2; p1++, p2--) {
    char tmp = *p1;
    *p1 = *p2;
    *p2 = tmp;
  }

  return buf;
}

void printf(char* fmt, ...)
{
	char **arg = (char **) &fmt;
	char c;
	arg++;

	while((c = *fmt++) != 0) {
		if(c != '%'){
			putchar(c);
			
		}else{
			char buf[64];
			char *p;
			c = *fmt++;
			
			if(c=='d'){
				// if value is minus, put '-' in the head
				if( 0 > *((int *) arg) ) {
					putchar('-');
					*((int *) arg) *= -1;
				}
				p = uint_to_str_small_hex(buf, *((unsigned *) arg++), 10);
				puts(p);
        
			}else if(c=='x'){
				p = uint_to_str_small_hex(buf, *((unsigned *) arg++), 16);
				puts(p);
        	
        	}else if(c=='X'){
        		p = uint_to_str_big_hex(buf, *((unsigned *) arg++), 16);
				puts(p);
        	
			}else if(c=='s'){
				p = *arg++;
				puts(p);
        	}else if(c=='c'){
        		p=*arg++;
        		char send=*p;
        		putchar(send);
			}else{
				putchar(c);
    	  	}	
		}
  	}
}
