/*
	nullptr Int manager
*/

#include"nullptr.h"
#include<string>
#include<sstream>

using namespace std;
using namespace VOSystemsNullptr::BasicTypes;

void IntManager::operator=(Int data)
{
	this->m_data = data;
}

Int IntManager::operator+(Int i)
{
	return m_data+i;
}

std::string IntManager::operator()(Int i, char type)
{
	stringstream sstr;
	switch(type){
	case 'd':
		if(!i.positive)sstr<<'-';
		sstr<<dec<<i.data;
		break;
	case 'o':
		if(!i.positive)sstr<<'-';
		sstr<<oct<<i.data;
		break;
	case 'x':
		if(!i.positive)sstr<<'-';
		sstr<<"0x";
		sstr<<hex<<i.data;
		break;
	case 'X':
		if(!i.positive)sstr<<'-';
		sstr<<"0x";
		sstr<<hex<<uppercase<<i.data;
		break;
	}
	return sstr.str();
}

Int IntManager::operator-(Int i)
{
	return m_data-i;
}

Int IntManager::operator*(Int i)
{
	return m_data*i;
}

Int IntManager::operator/(Int i)
{
	return m_data/i;
}

Int IntManager::operator%(Int i)
{
	return m_data%i;
}

Int IntManager::operator()(void)
{
	return this->m_data;
}

std::string IntManager::operator()(char type)
{
	string str=IntManager()(this->m_data,type);
	return str;
}

bool IntManager::operator==(IntManager to)
{
	return ((to().data == this->m_data.data) && (to().positive == this->m_data.positive));
}

bool IntManager::operator!=(IntManager to)
{
	return !((*this).operator==(to));
}

bool IntManager::operator<(IntManager to)
{
	return (to().positive==false && this->m_data.positive==true)||(to().data < this->m_data.data);
}

bool IntManager::operator<=(IntManager to)
{
	return !((*this).operator>(to));
}

bool IntManager::operator>(IntManager to)
{
	return (to().positive==true && this->m_data.positive==false)||(to().data > this->m_data.data);
}

bool IntManager::operator>=(IntManager to)
{
	return !((*this).operator<(to));
}

Int IntManager::GetValue(void)
{
	return m_data;
}

std::string IntManager::GetName(void)
{
	return m_name;
}


Int VOSystemsNullptr::BasicTypes::operator+(Int p1,Int p2)
{
	Int tmp;

	if(p2.positive==p1.positive){
		tmp.data=p2.data + p1.data;
		tmp.positive=p2.positive;
	}else{
		tmp.data=(p2.data > p1.data ? +1 : -1)*(p2.data - p1.data);
		tmp.positive=(p2.data > p1.data ? true : false);
	}
	return tmp;
}

Int VOSystemsNullptr::BasicTypes::operator-(Int p1, Int p2)
{
	Int tmp={p2.data,!p2.positive};
	tmp=p1+tmp;
	return tmp;
}

Int VOSystemsNullptr::BasicTypes::operator*(Int p1, Int p2)
{
	Int tmp;

	tmp.data=p1.data*p2.data;
	tmp.positive=(p1.positive==false || p2.positive==false ? false : true);
	return tmp;
}

Int VOSystemsNullptr::BasicTypes::operator/(Int p1, Int p2)
{
	Int tmp;

	tmp.data=p1.data/p2.data;
	tmp.positive=(p1.positive==false || p2.positive==false ? false : true);
	return tmp;
}

Int VOSystemsNullptr::BasicTypes::operator%(Int p1, Int p2)
{
	Int tmp;

	tmp.data=p1.data%p2.data;
	tmp.positive=(p1.positive==false || p2.positive==false ? false : true);
	return tmp;
}
