/*
 * CAN Target Simulator
 * for M16C/5M family + NC30WA v5.45
 *
 * [ SW ]
 */

#include "common.h"
#include "target.h"
#include "sfr5m.h"
#include "timer.h"
#include "sw.h"

/*
 * SW
 * vbV莞(ms)
 */
#define SW_THRES_MS					(20)
										/* 20msAŏԂvΊm */

/*
 * SW
 * vbV
 */
typedef struct _sw_info
{
	BOOL state;
										/* SW(m) */
	BOOL current;
										/* SW() */
	uint16 freerun;
										/* t[^C}(ms) */
} sw_info;

/*
 * SW
 * IuWFNg
 */
static sw_info sw_object[SW_MAX];
										/* SWIuWFNg */


/*
 * SW
 * 
 * ^C}ōs
 */
void sw_init(void)
{
	uint8 loop;

	/* SWIuWFNg */
	for (loop=0; loop<_countof(sw_object); loop++)
	{
		sw_object[loop].state = FALSE;
		sw_object[loop].current = FALSE;
		sw_object[loop].freerun = timer_freerun();
	}

#if SW_MAX == 4

	/* |[gݒ:kldqHSB16C29-64 */

	/* P3_0'H'xɏo(for SW isolation) */
	p3_0 = 1;

	/* P3_0o͕ɐݒ */
	pd3_0 = 1;

#elif SW_MAX == 2

	/* |[gݒ:lTXM3A-0256 */

	/* P8_2͕ɐݒ */
	pd8_2 = 0;

	/* P8_3͕ɐݒ */
	pd8_3 = 0;

#endif /* SW_MAX */
}

/*
 * SW
 * vbVԎ擾
 */
BOOL sw_get(uint8 sw_no)
{
	if (sw_no < _countof(sw_object))
	{
		/* mԂԂ */
		return sw_object[sw_no].state;
	}
	else
	{
		/* ̈O͏ɉĂȂ */
		return FALSE;
	}
}

/*
 * SW
 * ^XN
 */
void sw_task(void)
{
	BOOL sw_one;
	uint8 sw;
	uint8 loop;
	uint16 diff;

#if SW_MAX == 4

	/* P2͕ɐݒ */
	pd2 = 0x00;

	/* p3_0'L'xɏo(B to A) */
	p3_0 = 0;

	/* P2f[^ǂݎ */
	sw = p2;


#elif SW_MAX == 2

	/* P8f[^ǂݎ */
	sw = p8;

	/* 2bitEVtg(p8_2, p8_3Ώ) */
	sw >>= 2;

#endif /* SW_MAX */

	/* [v */
	for (loop=0; loop<_countof(sw_object); loop++)
	{
		/* ĉbitBOOL֕ϊ */
		if ((sw & 0x01) == 0)
		{
			sw_one = TRUE;
		}
		else
		{
			sw_one = FALSE;
		}

		/* sw_onecurrentvĂ邩 */
		if (sw_one != sw_object[loop].current)
		{
			/* currentXV */
			sw_object[loop].current = sw_one;

			/* Čv */
			sw_object[loop].freerun = timer_freerun();
		}

		/* Čv̌oߎԂ擾 */
		diff = timer_freerun() - sw_object[loop].freerun;

		/* 莞Ԍo߂ */
		if (diff >= SW_THRES_MS)
		{
			/* 莞ԁAԂێł */
			sw_object[loop].state = sw_object[loop].current;
		}

		/* swEVtg */
		sw >>= 1;
	}
}
