/*
 * CAN Target Simulator
 * for M16C/5M family + NC30WA v5.45
 *
 * [ ^C} ]
 */

#include "common.h"
#include "target.h"
#include "sfr5m.h"
#include "timer.h"

/*
 * ^C}
 * 荞ݎ(P:us)
 * 1`65000͈̔́A1000̔{Ƃ邱
 */
#define TIMER_CYCLE					(1000)
										/* 1000usƂɊ荞ݔ */

/*
 * ^C}JE^
 */
static uint16 timer_free_ms;
										/* t[^C}(16bit) */
static uint16 timer_ms;
										/* ^C}(msP)(0`999) */
static uint16 timer_sec_lo;
										/* ^C}(secP)(0`9999) */
static uint16 timer_sec_hi;
										/* ^C}(10000secP)(0`65535) */

/*
 * ^C}
 * 
 */
void timer_init(void)
{
	/* JE^ */
	timer_free_ms = 0;
	timer_ms = 0;
	timer_sec_lo = 0;
	timer_sec_hi = 0;

	/* ^C}ABONbNf1NbNI */
	tcdiv00 = 0;

	/* PRC0(veNgrbg)"1"() */
	prc0 = 1;

	/* ^C}A/B/SAI2CC^tF[XASIOf1NbN */
	pclkr = 0x03;

	/* PRC0(veNgrbg)"0"(֎~) */
	prc0 = 0;

	/* TCS3=1, TCS2-0=000bƂf32NbNI */
	tacs0 = 0xaa;

	/* ^C}[hɐݒApXo͂ъOo͂Ȃ */
	ta0mr = 0x00;

	/* ^C}Ao͔g`ύX֎~ */
	taow = 0x00;

	/* VbgJnȂ */
	onsf = 0x00;

	/* gKI(f1NbNgKƂ邪ATAnIN[qƂĂ) */
	trgsr = 0x00;

	/* _EJEg */
	udf = 0x00;

	/* ^C}A0̃JE^ݒB(ݒl+1)/f32ƂȂ */
	ta0 = (uint16)(TIMER_CYCLE - 1);

	/* 荞݃xݒ */
	ta0ic = INTR_DEF_LEVEL;

	/* ^C}A0JEgX^[g */
	ta0s = 1;
}

/*
 * ^C}
 * 荞݃nh
 */
#pragma INTERRUPT /B timer_isr(vect=21)
void timer_isr(void)
{
	/* t[^C} */
	timer_free_ms += (TIMER_CYCLE / 1000);

	/* ms^C} */
	timer_ms += (TIMER_CYCLE / 1000);

	/* sec^C}(lo) */
	if (timer_ms == 1000)
	{
		timer_ms = 0;
		timer_sec_lo++;

		/* sec^C}(hi) */
		if (timer_sec_hi == 10000)
		{
			timer_sec_lo = 0;
			timer_sec_hi++;
		}
	}
}

/*
 * ^C}
 * Ԏ擾
 */
void timer_get(timer_info *info)
{
	uint8 flg;
	uint16 count;
	BOOL equal;
	uint16 us;

	/* 荞݋֎~ */
	flg = cpu_di();

	/* ԏ󂯎 */
	info->sec_hi = timer_sec_hi;
	info->sec_lo = timer_sec_lo;
	info->ms = timer_ms;

	/* ta0ǂݎ */
	us = ta0;

	/*  荞ݕA */
	cpu_ei(flg);

	/* [v */
	equal = FALSE;
	while (equal == FALSE)
	{
		/* 荞݋֎~ */
		flg = cpu_di();

		/* msrł邱ƁAta0ɏȂĂ邱 */
		if ((info->ms == timer_ms) && (ta0 <= us))
		{
			/* v([v𔲂) */
			equal = TRUE;
		}
		else
		{
			/* ԏ󂯎 */
			info->sec_hi = timer_sec_hi;
			info->sec_lo = timer_sec_lo;
			info->ms = timer_ms;

			/* ta0ǂݎ */
			us = ta0;
		}

		/*  荞ݕA */
		cpu_ei(flg);
	}

	/* ta̓_EJE^Ȃ̂ŁAZ */
	us = TIMER_CYCLE - (us + 1);

#if TIMER_CYCLE > 1000
	/* us̏ */
	if (us >= 1000)
	{
		/* us1000Ŋ] */
		info->us = (uint16)(us % 1000);
		us = (uint16)(us / 1000);

		/* ms̏ */
		info->ms += us;
		if (info->ms >= 1000)
		{
			/* msI[o[t[ */
			info->ms -= 1000;

			/* sec(lo)̏ */
			info->sec_lo++;
			if (info->sec_lo == 10000)
			{
				/* sec(lo)I[o[t[ */
				info->sec_lo -= 10000;
				info->sec_hi++;
			}
		}
	}
	else
	{
		/* uŝ܂ܑ΂悢 */
		info->us = us;
	}
#else
	/* uŝ܂ܑ΂悢 */
	info->us = us;
#endif /* TIMER_CYCLE > 1000 */
}

/*
 * ^C}
 * t[^C}擾
 */
uint16 timer_freerun(void)
{
	uint16 ms;
	uint16 flg;

	/* 荞݋֎~ */
	flg = cpu_di();

	/* t[^C}擾 */
	ms = timer_free_ms;

	/* 荞ݕA */
	cpu_ei(flg);

	return ms;
}
