//
// CAN Target Simulator
// for Windows(x86) + Visual Studio Express 2013 for Windows Desktop
//
// [ COMR}h ]
//

#include "StdAfx.h"
#include "CommDeviceList.h"
#include "CommCommand.h"

//
// 萔`
//
#define COMM_COMMAND_TIMEOUT		(100)
										// ^CAEg(ms)
#define COMM_COMMAND_RETRY			(3)
										// gC
#define COMM_OFFSET_STX0			(0)
										// STX0(0x5A)
#define COMM_OFFSET_STX1			(1)
										// STX1(0xA5)
#define COMM_OFFSET_CMD_LEN			(2)
										// R}h(4bit)+OX(4bit)
#define COMM_OFFSET_DATA0			(3)
										// f[^0
#define COMM_OFFSET_DATA1			(4)
										// f[^1
#define COMM_OFFSET_DATA2			(5)
										// f[^2
#define COMM_OFFSET_DATA3			(6)
										// f[^3
#define COMM_OFFSET_DATA4			(7)
										// f[^4
#define COMM_OFFSET_DATA5			(8)
										// f[^5
#define COMM_COMMAND_NAK			(0xF0)
										// NAKR}h

//
// CommCommand()
// RXgN^
//
CommCommand::CommCommand(CommDeviceList* pCommDeviceList)
{
	// COMfoCXXgL
	m_pCommDeviceList = pCommDeviceList;
}

//
// ~CommCommand()
// fXgN^
//
CommCommand::~CommCommand()
{
	DeInit();
}

//
// Init()
// 
//
BOOL CommCommand::Init()
{
	// StartCmd()ōs߁AȂ
	return TRUE;
}

//
// DeInit()
// I
//
void CommCommand::DeInit()
{
}

//
// GetVersion()
// o[W擾
//
BOOL CommCommand::GetVersion(LPWORD pVersion)
{
	BOOL bResult;
	WORD wVersion;

	// R}hM
	bResult = StartCmd(0, 0);

	// ΁Ao[Wi[
	if (bResult == TRUE)
	{
		wVersion = m_byRecvBuf[COMM_OFFSET_DATA0];
		wVersion <<= 8;
		wVersion |= m_byRecvBuf[COMM_OFFSET_DATA1];

		*pVersion = wVersion;
	}

	return bResult;
}

//
// Read8bit()
// 8bitǂݍ
//
BOOL CommCommand::Read8bit(WORD wAddr, LPBYTE pData)
{
	BOOL bResult;
	BYTE byData;

	// Mf[^ݒ
	m_bySendBuf[COMM_OFFSET_DATA0] = (BYTE)(wAddr >> 8);
	m_bySendBuf[COMM_OFFSET_DATA1] = (BYTE)wAddr;

	// R}hM
	bResult = StartCmd(1, 2);

	// ΁Af[^ǂݎ
	if (bResult == TRUE)
	{
		byData = m_byRecvBuf[COMM_OFFSET_DATA0];

		*pData = byData;
	}

	return bResult;
}

//
// Write8bit()
// 8bit
//
BOOL CommCommand::Write8bit(WORD wAddr, BYTE byData)
{
	// Mf[^ݒ
	m_bySendBuf[COMM_OFFSET_DATA0] = (BYTE)(wAddr >> 8);
	m_bySendBuf[COMM_OFFSET_DATA1] = (BYTE)wAddr;
	m_bySendBuf[COMM_OFFSET_DATA2] = byData;

	// R}hM
	return StartCmd(2, 3);
}

//
// Read16bit()
// 16bitǂݍ
//
BOOL CommCommand::Read16bit(WORD wAddr, LPWORD pData)
{
	BOOL bResult;
	WORD wData;

	// Mf[^ݒ
	m_bySendBuf[COMM_OFFSET_DATA0] = (BYTE)(wAddr >> 8);
	m_bySendBuf[COMM_OFFSET_DATA1] = (BYTE)wAddr;

	// R}hM
	bResult = StartCmd(3, 2);

	// ΁Af[^ǂݎ
	if (bResult == TRUE)
	{
		wData = (WORD)m_byRecvBuf[COMM_OFFSET_DATA0];
		wData <<= 8;
		wData |= (WORD)m_byRecvBuf[COMM_OFFSET_DATA1];

		*pData = wData;
	}

	return bResult;
}

//
// Write16bit()
// 16bit
//
BOOL CommCommand::Write16bit(WORD wAddr, WORD wData)
{
	// Mf[^ݒ
	m_bySendBuf[COMM_OFFSET_DATA0] = (BYTE)(wAddr >> 8);
	m_bySendBuf[COMM_OFFSET_DATA1] = (BYTE)wAddr;
	m_bySendBuf[COMM_OFFSET_DATA2] = (BYTE)(wData >> 8);
	m_bySendBuf[COMM_OFFSET_DATA3] = (BYTE)wData;

	// R}hM
	return StartCmd(4, 4);
}

//
// Read32bit()
// 32bitǂݍ
//
BOOL CommCommand::Read32bit(WORD wAddr, LPDWORD pData)
{
	BOOL bResult;
	DWORD dwData;

	// Mf[^ݒ
	m_bySendBuf[COMM_OFFSET_DATA0] = (BYTE)(wAddr >> 8);
	m_bySendBuf[COMM_OFFSET_DATA1] = (BYTE)wAddr;

	// R}hM
	bResult = StartCmd(5, 2);

	// ΁Af[^ǂݎ
	if (bResult == TRUE)
	{
		dwData = (DWORD)m_byRecvBuf[COMM_OFFSET_DATA0];
		dwData <<= 8;
		dwData |= (DWORD)m_byRecvBuf[COMM_OFFSET_DATA1];
		dwData <<= 8;
		dwData |= (DWORD)m_byRecvBuf[COMM_OFFSET_DATA2];
		dwData <<= 8;
		dwData |= (DWORD)m_byRecvBuf[COMM_OFFSET_DATA3];

		*pData = dwData;
	}

	return bResult;
}

//
// Write32bit()
// 32bit
//
BOOL CommCommand::Write32bit(WORD wAddr, DWORD dwData)
{
	// Mf[^ݒ
	m_bySendBuf[COMM_OFFSET_DATA0] = (BYTE)(wAddr >> 8);
	m_bySendBuf[COMM_OFFSET_DATA1] = (BYTE)wAddr;
	m_bySendBuf[COMM_OFFSET_DATA2] = (BYTE)(dwData >> 24);
	m_bySendBuf[COMM_OFFSET_DATA3] = (BYTE)(dwData >> 16);
	m_bySendBuf[COMM_OFFSET_DATA4] = (BYTE)(dwData >> 8);
	m_bySendBuf[COMM_OFFSET_DATA5] = (BYTE)dwData;

	// R}hM
	return StartCmd(6, 6);
}

//
// StartCmd()
// R}hJn
//
BOOL CommCommand::StartCmd(UINT uCmd, UINT uLen)
{
	BYTE bySum;
	UINT uLoop;

	// STXi[
	m_bySendBuf[COMM_OFFSET_STX0] = 0x5A;
	m_bySendBuf[COMM_OFFSET_STX1] = 0xA5;

	// R}h&OXi[
	m_bySendBuf[COMM_OFFSET_CMD_LEN] = (BYTE)((uCmd << 4) | uLen);
	uLen += 3;

	// `FbNTZo
	bySum = 0;
	for (uLoop=0; uLoop < uLen; uLoop++)
	{
		bySum += m_bySendBuf[uLoop];
	}

	// `FbNTi[
	m_bySendBuf[uLen] = bySum;

	// MOobt@
	m_dwHead = 0;
	m_dwTail = 0;
	m_dwNum = 0;

	// R}hԍ
	m_uCmdNum = uCmd;

	// gC
	m_uRetry = 0;

	// R}hC
	return CmdMain();
}

//
// CmdMain()
// R}hC
//
BOOL CommCommand::CmdMain()
{
	BOOL bResult;

	// bResultsŏ
	bResult = FALSE;

	// gC[v
	while (m_uRetry < COMM_COMMAND_RETRY)
	{
		// gCJn(M)
		bResult = StartRetry();
		if (bResult == FALSE)
		{
			// Ms
			break;
		}

		// M҂
		bResult = WaitReply();
		if (bResult == TRUE)
		{
			// ԐMOK
			break;
		}
	}

	return bResult;
}

//
// StartRetry()
// gCJn
//
BOOL CommCommand::StartRetry()
{
	DWORD dwBytes;
	BOOL bResult;

	// MoCg擾
	dwBytes = (DWORD)m_bySendBuf[COMM_OFFSET_CMD_LEN];
	dwBytes &= 0x0f;
	dwBytes += 4;

	// M
	bResult = m_pCommDeviceList->Write(m_bySendBuf, dwBytes);

	// eBbNJEg擾
	m_dwTickCount = GetTickCount();

	return bResult;
}

//
// WaitReply()
// ԐM҂
//
BOOL CommCommand::WaitReply()
{
	DWORD dwDiff;
	DWORD dwRecv;
	DWORD dwLen;
	UINT uCmd;

	// [v
	for (;;)
	{
		// ^CAEg
		dwDiff = (DWORD)(GetTickCount() - m_dwTickCount);
		if (dwDiff >= COMM_COMMAND_TIMEOUT)
		{
			break;
		}

		// Xg[gobt@oRăOobt@֑}
		dwRecv = m_pCommDeviceList->Read(m_byRecvBuf, sizeof(m_byRecvBuf));
		if (dwRecv > 0)
		{
			// }
			Insert(m_byRecvBuf, dwRecv);
		}

		// Oobt@Xg[gobt@֎擾
		dwRecv = Get(m_byRecvBuf, sizeof(m_byRecvBuf));

		// Œ2oCgKv(STX)
		if (dwRecv >= 2)
		{
			// STX̃`FbN
			if ((m_byRecvBuf[COMM_OFFSET_STX0] == 0x5A) || (m_byRecvBuf[COMM_OFFSET_STX1] == 0xA5))
			{
				// Œ4oCgKv(R}hOXƃ`FbNT)
				if (dwRecv >= 4)
				{
					// OX擾
					dwLen = m_byRecvBuf[COMM_OFFSET_CMD_LEN];
					dwLen &= 0x0f;
					dwLen += 4;

					// OXĂ邩
					if (dwRecv >= dwLen)
					{
						// `FbNŤ
						if (IsEqualSum(dwLen - 1) == TRUE)
						{
							// R}h
							uCmd = (UINT)m_byRecvBuf[COMM_OFFSET_CMD_LEN];
							uCmd >>= 4;

							if (uCmd == m_uCmdNum)
							{
								// STX, `FbNT, R}hSOK
								return TRUE;
							}
							else
							{
								// R}hsv(炭NAK)
								Discard(dwLen);
								return FALSE;
							}
						}
						else
						{
							// `FbNTsv
							Discard(dwLen);
							return FALSE;
						}
					}
				}
			}
			else
			{
				// STXقȂBMobt@1oCgp
				Discard(1);
			}
		}

		// X[v
		Sleep(1);
	}

	// ^CAEg
	return FALSE;
}

//
// IsEqualSum()
// `FbNT
//
BOOL CommCommand::IsEqualSum(DWORD dwLen)
{
	BYTE bySum;
	DWORD dwLoop;

	// `FbNTZo
	bySum = 0;
	for (dwLoop=0; dwLoop < dwLen; dwLoop++)
	{
		bySum += m_byRecvBuf[dwLoop];
	}

	// `FbNTr
	if (m_byRecvBuf[dwLen] == bySum)
	{
		return TRUE;
	}
	else
	{
		return FALSE;
	}
}

//
// Insert()
// Oobt@֑}
//
void CommCommand::Insert(const LPBYTE pData, DWORD dwBytes)
{
	DWORD dwRest;

	// Oobt@܂f
	if ((m_dwTail + dwBytes) > sizeof(m_byRingBuf))
	{
		// 2ɕđ}
		dwRest = (m_dwTail + dwBytes) - sizeof(m_byRingBuf);
		dwBytes -= dwRest;
	}
	else
	{
		// 1ő}
		dwRest = 0;
	}

	// 1
	memcpy(&m_byRingBuf[m_dwTail], &pData[0], dwBytes);
	m_dwTail += dwBytes;
	if (m_dwTail == sizeof(m_byRingBuf))
	{
		m_dwTail = 0;
	}
	m_dwNum += dwBytes;

	// 2
	if (dwRest > 0)
	{
		memcpy(&m_byRingBuf[0], &pData[dwBytes], dwRest);
		m_dwTail = dwRest;
		m_dwNum += dwRest;
	}

	// m_dwNumɒBꍇ
	if (m_dwNum >= sizeof(m_byRingBuf))
	{
		m_dwNum = sizeof(m_byRingBuf);
		m_dwHead = m_dwTail;
	}
}

//
// Get()
// Oobt@擾
//
DWORD CommCommand::Get(LPBYTE pData, DWORD dwMaxBytes)
{
	DWORD dwBytes;
	DWORD dwRest;

	// dwMaxBytesm_dwNumrA菭Ȃ
	dwBytes = m_dwNum;
	if (dwBytes < dwMaxBytes)
	{
		dwBytes = dwMaxBytes;
	}

	// Oobt@܂f
	if ((m_dwHead + dwBytes) > sizeof(m_byRingBuf))
	{
		// 2ɕđ}
		dwRest = (m_dwHead + dwBytes) - sizeof(m_byRingBuf);
		dwBytes -= dwRest;
	}
	else
	{
		// 1ő}
		dwRest = 0;
	}

	// 1
	memcpy(&pData[0], &m_byRingBuf[m_dwHead], dwBytes);

	// 2
	if (dwRest > 0)
	{
		memcpy(&pData[dwBytes], &m_byRingBuf[0], dwRest);
	}

	return (dwBytes + dwRest);
}

//
// Discard()
// Oobt@p
//
void CommCommand::Discard(DWORD dwBytes)
{
	// dwBytesNum̂A菬
	if (m_dwNum < dwBytes)
	{
		dwBytes = m_dwNum;
	}

	// HeadZ
	m_dwHead += dwBytes;
	if (m_dwHead >= sizeof(m_byRingBuf))
	{
		m_dwHead -= sizeof(m_byRingBuf);
	}

	// NumZ
	m_dwNum -= dwBytes;
}
