//
// CAN Target Simulator
// for Windows(x86) + Visual Studio Express 2013 for Windows Desktop
//
// [ COMfoCXXg ]
//

#include "StdAfx.h"
#include "CommDevice.h"
#include "CommDeviceList.h"

//
// 萔`
//
#define PORTS_CLASS_NAME			_T("PORTS")
										// PORTSNX̖
#define PORT_REG_NAME				_T("PortName")
										// |[ĝ\WXgl[
#define COM_PREFIX_NAME				_T("COM")
										// COM|[g̐擪Ɍ閼

//
// CommDeviceList()
// RXgN^
//
CommDeviceList::CommDeviceList()
{
}

//
// ~CommDeviceList()
// fXgN^
//
CommDeviceList::~CommDeviceList()
{
	DeInit();
}

//
// Init()
// 
//
BOOL CommDeviceList::Init()
{
	// xN^
	m_vector.clear();

	// ݃I[ṽCfbNX
	m_uCurrent = 0;

	// ݂̓I[vĂȂ
	m_bOpen = FALSE;

	return TRUE;
}

//
// DeInit()
// I
//
void CommDeviceList::DeInit()
{
	// ݃I[vĂ΁AN[Y
	if (m_bOpen == TRUE)
	{
		Close();
	}
}

//
// Open()
// I[v
//
BOOL CommDeviceList::Open(UINT uIndex)
{
	// I[vĂΎs
	if (m_bOpen == TRUE)
	{
		return FALSE;
	}

	// JgύX
	m_uCurrent = uIndex;

	// ʂm_bOpen֑
	m_bOpen = m_vector[m_uCurrent].Open();

	// ʂԂ
	return m_bOpen;
}

//
// Close()
// N[Y
//
void CommDeviceList::Close()
{
	// I[vĂ
	if (m_bOpen == TRUE)
	{
		// N[Y
		m_vector[m_uCurrent].Close();

		// I[vĂȂ
		m_bOpen = FALSE;
	}
}

//
// IsOpen()
// I[vĂ邩擾
//
BOOL CommDeviceList::IsOpen() const
{
	return m_bOpen;
}

//
// GetCurrent()
// ݃I[vĂCfbNX̎擾
//
UINT CommDeviceList::GetCurrent() const
{
	return m_uCurrent;
}

//
// Read()
// M
//
DWORD CommDeviceList::Read(LPBYTE pData, DWORD dwMaxBytes)
{
	if (m_bOpen == TRUE)
	{
		return m_vector[m_uCurrent].Read(pData, dwMaxBytes);
	}
	else
	{
		return 0;
	}
}

//
// Write()
// M
//
BOOL CommDeviceList::Write(const LPBYTE pData, DWORD dwBytes)
{
	if (m_bOpen == TRUE)
	{
		return m_vector[m_uCurrent].Write(pData, dwBytes);
	}
	else
	{
		return FALSE;
	}
}


//
// Enum()
// 
//
BOOL CommDeviceList::Enum()
{
	BOOL bRet;
	GUID PortsGUID;
	DWORD dwRequiredSize;
	HDEVINFO hDevInfo;

	// xN^炩߃NA
	m_vector.clear();

	// PORTSNXɌѕtꂽGUID̎̂擾(GUIĎ͏1ł)
	bRet = SetupDiClassGuidsFromName(PORTS_CLASS_NAME, &PortsGUID, 1, &dwRequiredSize);
	if (bRet == FALSE)
	{
		OutputDebugString(_T("CommDeviceList:SetupDiClassGuidsFromName(ClassGUIDList) returns FALSE\n"));
		return FALSE;
	}
	if (dwRequiredSize != 1)
	{
		OutputDebugString(_T("CommDeviceList:SetupDiClassGuidsFromName(ClassGUIDList) dwRequiredSize != 1\n"));
		return FALSE;
	}

	// foCXZbg擾
	hDevInfo = SetupDiGetClassDevs(&PortsGUID, NULL, NULL, DIGCF_PRESENT);
	if (hDevInfo == NULL)
	{
		OutputDebugString(_T("CommDeviceList:SetupDiClassDevs() returns NULL\n"));
		return FALSE;
	}

	// Tu֐ɔC
	EnumSub(hDevInfo);

	// foCXZbg̎gpI
	bRet = SetupDiDestroyDeviceInfoList(hDevInfo);
	if (bRet == FALSE)
	{
		OutputDebugString(_T("CommDeviceList::SetupDiDestroyDeviceInfoList() returns FALSE\n"));
		return FALSE;
	}

	// 
	return TRUE;
}

//
// EnumSub()
// 񋓃Tu
//
void CommDeviceList::EnumSub(HDEVINFO hDevInfo)
{
	SP_DEVINFO_DATA DeviceInfoData;
	DWORD dwMemberIndex;
	BOOL bRet;

	// 
	dwMemberIndex = 0;
	bRet = TRUE;

	// while[v
	while (bRet == TRUE)
	{
		// DeviceInfoData𖈉񏉊
		ZeroMemory(&DeviceInfoData, sizeof(DeviceInfoData));
		DeviceInfoData.cbSize = sizeof(DeviceInfoData);

		// X̃foCXCX^X擾
		bRet = SetupDiEnumDeviceInfo(hDevInfo, dwMemberIndex, &DeviceInfoData);
		if (bRet == FALSE)
		{
			// ׂĂ̗񋓂I
			break;
		}

		// PfoCX̏
		bRet = EnumOne(hDevInfo, &DeviceInfoData);
		if (bRet == FALSE)
		{
			// PfoCX̏Ɏs
			break;
		}

		// oCfbNX֐i߂
		dwMemberIndex++;
	}
}

//
// EnumOne()
// PfoCX̏
//
BOOL CommDeviceList::EnumOne(HDEVINFO hDevInfo, SP_DEVINFO_DATA* pDevInfoData)
{
	BOOL bRet;
	DWORD dwRequiredSize;
	_TCHAR* pFriendlyName;
	DWORD dwRegDataType;
	HKEY hKey;
	LONG lError;
	DWORD dwRegType;
	DWORD dwRegSize;
	_TCHAR* pPortName;
	int nRet;

	// vO&vCł̃thl[擾ɕKvȃobt@TCY𓾂
	dwRequiredSize = 0;
	SetupDiGetDeviceRegistryProperty(
		hDevInfo,
		pDevInfoData,
		SPDRP_FRIENDLYNAME,
		NULL,
		NULL,
		0,
		&dwRequiredSize);
	if (dwRequiredSize == 0)
	{
		OutputDebugString(_T("CommDeviceList::SetupGetDeviceRegistryProperty(NULL) dwRequiredSize == 0\n"));
		return FALSE;
	}

	// thl[obt@m
	pFriendlyName = new _TCHAR[dwRequiredSize];

	// thl[擾
	bRet = SetupDiGetDeviceRegistryProperty(
		hDevInfo,
		pDevInfoData,
		SPDRP_FRIENDLYNAME,
		&dwRegDataType,
		(PBYTE)pFriendlyName,
		sizeof(_TCHAR) * dwRequiredSize,
		&dwRequiredSize);
	if (bRet == FALSE)
	{
		OutputDebugString(_T("CommDeviceList::SetupGetDeviceRegistryProperty(pFriendlyName) returns FALSE\n"));
		delete[] pFriendlyName;
		return FALSE;
	}

	// thl[擾ł̂ŁAۂCOM|[gǂׂ
	hKey = SetupDiOpenDevRegKey(
		hDevInfo,
		pDevInfoData,
		DICS_FLAG_GLOBAL,
		0,
		DIREG_DEV,
		KEY_QUERY_VALUE);
	if (hKey != INVALID_HANDLE_VALUE)
	{
		// WXg̓ǂݏoɕKvȃTCY擾
		dwRegSize = 0;
		lError = RegQueryValueEx(
			hKey,
			PORT_REG_NAME,
			NULL,
			&dwRegType,
			NULL,
			&dwRegSize);
		if ((lError == ERROR_SUCCESS) && (dwRegType == REG_SZ))
		{
			// |[gl[obt@m
			pPortName = new _TCHAR[dwRegSize];

			// ߂ăWXgǂݏo
			lError = RegQueryValueEx(
				hKey,
				PORT_REG_NAME,
				NULL,
				&dwRegType,
				(LPBYTE)pPortName,
				&dwRegSize);

			// pPortName'COM'Ŏn܂Ă邩ׂ
			nRet = _tcsnicmp(pPortName, COM_PREFIX_NAME, _tcslen(COM_PREFIX_NAME));

			// 'COM'Ŏn܂ĂꍇɌĒǉ
			if (nRet == 0)
			{
				EnumAdd(pFriendlyName, pPortName);
			}

			// |[gl[obt@
			delete[] pPortName;
		}

		// hKey
		RegCloseKey(hKey);
	}

	// thl[obt@
	delete[] pFriendlyName;

	return TRUE;
}

//
// EnumAdd()
// foCX̒ǉ
//
void CommDeviceList::EnumAdd(_TCHAR* pFriendlyName, _TCHAR* pPortName)
{
	// VCommDeviceNX쐬ăxN^֒ǉ
	m_vector.push_back(CommDevice(pFriendlyName, pPortName));
}

//
// GetCount()
// foCX̎擾
//
UINT CommDeviceList::GetCount() const
{ 
	std::vector <CommDevice>::size_type size;

	// TCY擾
	size = m_vector.size();

	return (UINT)size;
}

//
// GetFriendlyName()
/// thl[̎擾
//
const _TCHAR* CommDeviceList::GetFriendlyName(UINT uIndex) const
{
	UINT uCount;
	const _TCHAR* pFriendlyName;

	// ߂l
	pFriendlyName = NULL;

	// JEg擾
	uCount = GetCount();

	// JEg͈͓ł
	if (uIndex < uCount)
	{
		// xN^thl[Ԃ(͕̂ύXs)
		pFriendlyName = m_vector[uIndex].GetFriendlyName();
	}

	return pFriendlyName;
}
