//
// CAN Target Simulator
// for Windows(x86) + Visual Studio Express 2013 for Windows Desktop
//
// [ wp ]
//

#pragma once

#ifdef __cplusplus
extern "C" {
#endif // __cplusplus

typedef unsigned char u1;
typedef unsigned short u2;
typedef unsigned int u4;

//
// Command()
// R}hs
//
void Command(u4 cmd);

//
// Read8bit()
// 8bitǂݍ
//
u1 Read8bit(u2 addr);

//
// Write8bit()
// 8bit
//
void Write8bit(u2 addr, u1 data);

//
// Read16bit()
// 16bitǂݍ
//
u2 Read16bit(u2 addr);

//
// Write16bit()
// 16bit
//
void Write16bit(u2 addr, u2 data);


//
// Read32bit()
// 32bitǂݍ
//
u4 Read32bit(u2 addr);

//
// Write32bit()
// 32bit
//
void Write32bit(u2 addr, u4 data);

//
// LogMsg()
// Oo
//
void LogMsg(const char *msg);

//
// Log8bit()
// Oo(8bitf[^t)
//
void Log8bit(const char *msg, u1 data);

//
// Log16bit()
// Oo(16bitf[^t)
//
void Log16bit(const char *msg, u2 data);

//
// Log32it()
// Oo(32bitf[^t)
//
void Log32bit(const char *msg, u4 data);

#ifdef __cplusplus
}
#endif // __cplusplus
