//
// CAN Target Simulator
// for Windows(x86) + Visual Studio Express 2013 for Windows Desktop
//
// [ OXg{bNX ]
//

#include "StdAfx.h"
#include "LogListBox.h"

//
// LogListBox()
// RXgN^
//
LogListBox::LogListBox()
{
	// oϐ
	m_hInstance = NULL;
	m_hWnd = NULL;
}

//
// ~LogListBox()
// fXgN^
//
LogListBox::~LogListBox()
{
	DeInit();
}

//
// Init()
// 
//
BOOL LogListBox::Init(HINSTANCE hInstance, HWND hWnd)
{
	// CX^XƃEBhEnh`FbN
	if ((hInstance == NULL) || (hWnd == NULL))
	{
		return FALSE;
	}

	// CX^XL
	m_hInstance = hInstance;

	// EBhEnhL
	m_hWnd = hWnd;

	// Xg{bNX̓eNA
	SendMessage(m_hWnd, LB_RESETCONTENT, 0, 0);

	return TRUE;
}

//
// DeInit()
// I
void LogListBox::DeInit()
{
}

//
// LogRes()
// 񃊃\[X烍Oo
//
void LogListBox::LogRes(UINT uID)
{
	int nRet;

	// CX^X`FbN
	if (m_hInstance == NULL)
	{
		return;
	}

	// 񃊃\[X[h
	nRet = LoadString(m_hInstance, uID, m_szRes, _countof(m_szRes));
	if (nRet == 0)
	{
		OutputDebugString(_T("LogListBox:LoadString() returns 0\n"));
		return;
	}

	// Oo
	LogOut();
}

//
// LogMsg()
// bZ[W烍Oo
//
void LogListBox::LogMsg(const _TCHAR* pszMsg)
{
	// Rs[
	_tcscpy_s(m_szRes, _countof(m_szRes), pszMsg);

	// Oo
	LogOut();
}

//
// LogUint()
// bZ[WƐl烍Oo
//
void LogListBox::LogUint(const _TCHAR* pszMsg, UINT uValue)
{
	// tH[}bg
	_stprintf_s(m_szRes, _countof(m_szRes), _T("%s%u"), pszMsg, uValue);

	// Oo
	LogOut();
}

//
// LogOut()
// Oo
//
void LogListBox::LogOut()
{
	SYSTEMTIME st;
	LRESULT result;

	// EBhEnh`FbN
	if (m_hWnd == NULL)
	{
		return;
	}

	// [JԂ擾
	GetLocalTime(&st);

	// tюtH[}bg
	_stprintf_s(
		m_szLog,
		_countof(m_szLog),
		_T("[%02d:%02d:%02d.%03d] "),
		st.wHour,
		st.wMinute,
		st.wSecond,
		st.wMilliseconds);

	// \[XA
	_tcscat_s(m_szLog, _countof(m_szLog), m_szRes);

	// Xg{bNX֒ǉ
	result = SendMessage(m_hWnd, LB_ADDSTRING, 0, (LPARAM)m_szLog);

	if (result != LB_ERR)
	{
		// XN[
		SendMessage(m_hWnd, LB_SETTOPINDEX, (WPARAM)result, 0);
	}

	// WindowsOR\[ւo
	_tcscat_s(m_szLog, _countof(m_szLog), _T("\n"));
	OutputDebugString(m_szLog);
}
