//
// CAN Target Simulator
// for Windows(x86) + Visual Studio Express 2013 for Windows Desktop
//
// [ WinMain ]
//

#include "StdAfx.h"
#include "resource.h"

#include "CommDevice.h"
#include "CommDeviceList.h"
#include "LogListBox.h"
#include "CommCommand.h"
#include "Helper.h"

//
// CX^Xϐ
//
static HINSTANCE g_hInstance;
										// CX^X
static CommDeviceList* g_pCommDeviceList;
										// R~jP[VfoCX̃Xg
static LogListBox* g_pLogListBox;
										// OXg{bNX
static CommCommand* g_pCommCommand;
										// R}h

//
// Read8bit()
// 8bitǂݍ
//
u1 Read8bit(u2 addr)
{
	BYTE data;
	BOOL bRet;

	// R}hs
	bRet = g_pCommCommand->Read8bit((WORD)addr, &data);

	// bRet == FALSEł΁A߂l0Ƃ
	if (bRet == FALSE)
	{
		g_pLogListBox->LogMsg(_T("Read8bit() Failed!"));
		data = 0;
	}

	return data;
}

//
// Writed8bit()
// 8bit
//
void Write8bit(u2 addr, u1 data)
{
	// R}hs
	if (g_pCommCommand->Write8bit((WORD)addr, (BYTE)data) == FALSE)
	{
		g_pLogListBox->LogMsg(_T("Write8bit() Failed!"));
	}
}

//
// Read16bit()
// 16bitǂݍ
//
u2 Read16bit(u2 addr)
{
	WORD data;
	BOOL bRet;

	// R}hs
	bRet = g_pCommCommand->Read16bit((WORD)addr, &data);

	// bRet == FALSEł΁A߂l0Ƃ
	if (bRet == FALSE)
	{
		g_pLogListBox->LogMsg(_T("Read16bit() Failed!"));
		data = 0;
	}

	return data;
}

//
// Writed16bit()
// 16bit
//
void Write16bit(u2 addr, u2 data)
{
	// R}hs
	if (g_pCommCommand->Write16bit((WORD)addr, (WORD)data) == FALSE)
	{
		g_pLogListBox->LogMsg(_T("Write16bit() Failed!"));
	}
}

//
// Read32bit()
// 32bitǂݍ
//
u4 Read32bit(u2 addr)
{
	DWORD data;
	BOOL bRet;

	// R}hs
	bRet = g_pCommCommand->Read32bit((WORD)addr, &data);

	// bRet == FALSEł΁A߂l0Ƃ
	if (bRet == FALSE)
	{
		g_pLogListBox->LogMsg(_T("Read32bit() Failed!"));
		data = 0;
	}

	return data;
}

//
// Write32bit()
// 32bit
//
void Write32bit(u2 addr, u4 data)
{
	// R}hs
	if (g_pCommCommand->Write32bit((WORD)addr, (DWORD)data) == FALSE)
	{
		g_pLogListBox->LogMsg(_T("Write32bit() Failed!"));
	}
}

//
// LogMsg()
// Oo
//
void LogMsg(const char *msg)
{
#ifdef _UNICODE
	_TCHAR szLog[_MAX_PATH];
#endif // _UNICODE

#ifdef _UNICODE
	// UNICODE֕ϊ
	MultiByteToWideChar(
		932,
		MB_PRECOMPOSED,
		msg,
		-1,
		szLog,
		_countof(szLog)
		);

	// UNICODEŏo
	g_pLogListBox->LogMsg(szLog);
#else
	// ̂܂܏o
	g_pLogListBox->LogMsg(szAnsi);
#endif // _UNICODE
}

//
// Log8bit()
// Oo(8bitf[^t)
//
void Log8bit(const char *msg, u1 data)
{
	char szAnsi[_MAX_PATH];

	// ANSIŃtH[}bg
	sprintf_s(szAnsi, _countof(szAnsi), "%s(HEX=0x%02X, DEC=%d)", msg, data, data);

	// Oo
	LogMsg(szAnsi);
}

//
// Log16bit()
// Oo(16bitf[^t)
//
void Log16bit(const char *msg, u2 data)
{
	char szAnsi[_MAX_PATH];

	// ANSIŃtH[}bg
	sprintf_s(szAnsi, _countof(szAnsi), "%s(HEX=0x%04X, DEC=%d)", msg, data, data);

	// Oo
	LogMsg(szAnsi);
}

//
// Log32bit()
// Oo(32bitf[^t)
//
void Log32bit(const char *msg, u4 data)
{
	char szAnsi[_MAX_PATH];

	// ANSIŃtH[}bg
	sprintf_s(szAnsi, _countof(szAnsi), "%s(HEX=0x%08X, DEC=%d)", msg, data, data);

	// Oo
	LogMsg(szAnsi);
}

//
// MainDialogInit()
// C_CAȌ
//
static void MainDialogInit(HWND hWnd)
{
	HWND hListBox;
	HWND hComboBox;
	UINT uCount;
	const _TCHAR* pFriendlyName;
	BOOL bResult;

	// OXg{bNX
	hListBox = GetDlgItem(hWnd, ID_MAINDLG_LOGLIST);
	if (hListBox != NULL)
	{
		g_pLogListBox->Init(g_hInstance, hListBox);
	}

	// R~jP[VfoCXXgXV
	g_pCommDeviceList->Enum();
	g_pLogListBox->LogRes(IDS_PORT_ENUM);

	// COM|[gIR{{bNX
	hComboBox = GetDlgItem(hWnd, ID_MAINDLG_COMCOMBO);
	if (hComboBox != NULL)
	{
		// R~jP[VfoCX̌擾
		uCount = g_pCommDeviceList->GetCount();

		// R~jP[VfoCX[vAthl[ǉ
		for (UINT uLoop = 0; uLoop < uCount; uLoop++)
		{
			pFriendlyName = g_pCommDeviceList->GetFriendlyName(uLoop);
			if (pFriendlyName != NULL)
			{
				// Xg{bNX֒ǉ
				SendMessage(hComboBox, CB_INSERTSTRING, uLoop, (LPARAM)pFriendlyName);

				// OXg{bNX
				g_pLogListBox->LogMsg(pFriendlyName);
			}
		}

		// uCountɂĕ
		if (uCount > 0)
		{
			// ŏ̕I
			SendMessage(hComboBox, CB_SETCURSEL, 0, 0);

			// ŏ̃|[gI[v
			bResult = g_pCommDeviceList->Open(0);
			if (bResult == TRUE)
			{
				g_pLogListBox->LogRes(IDS_PORT_OPEN);
			}
			else
			{
				g_pLogListBox->LogRes(IDS_PORT_OPENERR);
			}
			g_pLogListBox->LogMsg(g_pCommDeviceList->GetFriendlyName(0));
		}
		else
		{
			// COM|[gȂ
			g_pLogListBox->LogRes(IDS_PORT_EMPTY);
		}
	}

	// R}h̓GfBbgRg[
	SetDlgItemText(hWnd, ID_MAINDLG_CMDEDIT, _T("0"));
}

//
// OnCbnSelChange()
// R{{bNXύX
//
static void OnCbnSelChange(UINT uCurSel)
{
	UINT uCurrent;
	BOOL bResult;

	// ݃I[vĂ
	if (g_pCommDeviceList->IsOpen() == TRUE)
	{
		// ݂̃|[gN[Y
		uCurrent = g_pCommDeviceList->GetCurrent();
		g_pCommDeviceList->Close();

		g_pLogListBox->LogRes(IDS_PORT_CLOSE);
		g_pLogListBox->LogMsg(g_pCommDeviceList->GetFriendlyName(uCurrent));
	}

	// Iꂽ|[gI[v
	bResult = g_pCommDeviceList->Open(uCurSel);
	if (bResult == TRUE)
	{
		g_pLogListBox->LogRes(IDS_PORT_OPEN);
	}
	else
	{
		g_pLogListBox->LogRes(IDS_PORT_OPENERR);
	}
	g_pLogListBox->LogMsg(g_pCommDeviceList->GetFriendlyName(uCurSel));
}

//
// OnExec()
// R}hs
//
static void OnExec(HWND hWnd)
{
	HWND hEditCtrl;
	TCHAR szEdit[32];
	UINT uCount;
	UINT uCommand;

	// GfBbgRg[̃EBhEnh擾
	hEditCtrl = GetDlgItem(hWnd, ID_MAINDLG_CMDEDIT);

	// GfBbgRg[̕擾
	ZeroMemory(szEdit, sizeof(szEdit));
	szEdit[0] = _countof(szEdit);
	uCount = SendMessage(hEditCtrl, EM_GETLINE, (WPARAM)0, (LPARAM)szEdit);

	// 񂪑݂ꍇ̂
	if (uCount > 0)
	{
		// I[v̏ꍇ̂
		if (g_pCommDeviceList->IsOpen() == TRUE)
		{
			uCommand = _tcstoul(szEdit, NULL, 10);
			g_pLogListBox->LogUint(_T("R}h "), uCommand);

			// TvAvĂяo
			Command((u4)uCommand);
		}
	}
}

//
// OnTest()
// ʐMeXg
//
static void OnTest()
{
	WORD wVersion;
	BOOL bRet;

	// I[v̏ꍇ̂
	if (g_pCommDeviceList->IsOpen() == TRUE)
	{
		// ʐMeXg
		g_pLogListBox->LogMsg(_T("ʐMeXg:"));

		// R}h0:vgRo[W擾
		bRet = g_pCommCommand->GetVersion(&wVersion);
		if (bRet == TRUE)
		{
			if (wVersion == 0x0001)
			{
				g_pLogListBox->LogMsg(_T("OK"));
			}
			else
			{
				g_pLogListBox->LogMsg(_T("NG(vgRo[WG[)"));
			}
		}
		else
		{
			g_pLogListBox->LogMsg(_T("NG(^CAEg)"));
		}
	}
}

//
// OnCommand()
// WM_COMMANDbZ[Wnh
//
static void OnCommand(HWND hWnd, WPARAM wParam, LPARAM lParam)
{
	UINT uID;
	UINT uNotify;
	HWND hCtrlWnd;
	UINT uCurSel;

	uNotify = HIWORD(wParam);
	uID = LOWORD(wParam);
	hCtrlWnd = (HWND)lParam;

	switch (uID)
	{
	// [ENTER]
	case IDOK:
		// R}hs
		OnExec(hWnd);
		break;

	// [ESC]܂͕{^
	case IDCANCEL:
		EndDialog(hWnd, IDCANCEL);
		break;

	// |[gR{{bNX
	case ID_MAINDLG_COMCOMBO:
		// R{{bNX[UɂĕύXꂽ
		if (uNotify == CBN_SELCHANGE)
		{
			// ݂̑Iʒu擾
			uCurSel = (UINT)SendMessage(hCtrlWnd, CB_GETCURSEL, (WPARAM)0, (LPARAM)0);

			// ύX
			OnCbnSelChange(uCurSel);
		}
		break;

	// s{^
	case ID_MAINDLG_EXECBTN:
		// {^ꂽ
		if (uNotify == BN_CLICKED)
		{
			// s
			OnExec(hWnd);
		}
		break;

	// ʐMeXg{^
	case ID_MAINDLG_CMDTEST:
		// {^ꂽ
		if (uNotify == BN_CLICKED)
		{
			// ʐMeXg
			OnTest();
		}
		break;

	default:
		break;
	}
}

//
// MainDialogProc()
// C_CAOvV[W
//
BOOL CALLBACK MainDialogProc(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
	switch (msg)
	{
	// _CAȌ
	case WM_INITDIALOG:
		MainDialogInit(hWnd);
		return TRUE;

	// R}h
	case WM_COMMAND:
		OnCommand(hWnd, wParam, lParam);
		return TRUE;

	// EBhẼN[Yv
	case WM_CLOSE:
		EndDialog(hWnd, IDOK);
		return TRUE;
	}

	return FALSE;
}

//
// Init()
// IuWFNgCX^X̍쐬
//
static BOOL Init(HINSTANCE hInstance)
{
	BOOL bRet;

	// CX^XL
	g_hInstance = hInstance;

	// R~jP[VfoCX̃Xg
	g_pCommDeviceList = new CommDeviceList;
	bRet = g_pCommDeviceList->Init();
	if (bRet == FALSE)
	{
		return FALSE;
	}

	// OXg{bNX(Init͍sȂ)
	g_pLogListBox = new LogListBox;

	// R}h
	g_pCommCommand = new CommCommand(g_pCommDeviceList);
	bRet = g_pCommCommand->Init();
	if (bRet == FALSE)
	{
		return FALSE;
	}

	return TRUE;
}

//
// DeInit()
// IuWFNgCX^X̍폜
//
static void DeInit(void)
{
	// R}h
	if (g_pCommCommand != NULL)
	{
		delete g_pCommCommand;
		g_pCommCommand = NULL;
	}

	// OXg{bNX
	if (g_pLogListBox != NULL)
	{
		delete g_pLogListBox;
		g_pLogListBox = NULL;
	}

	// R~jP[VfoCX̃Xg
	if (g_pCommDeviceList != NULL)
	{
		g_pCommDeviceList->DeInit();
		delete g_pCommDeviceList;
		g_pCommDeviceList = NULL;
	}
}

//
// WinMain()
// vÕGg|Cg
//
int WINAPI _tWinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPTSTR lpCmdLine, int nCmdShow)
{
	BOOL bRet;

	UNREFERENCED_PARAMETER(hPrevInstance);
	UNREFERENCED_PARAMETER(lpCmdLine);
	UNREFERENCED_PARAMETER(nCmdShow);

	// CX^X̍쐬
	bRet = Init(hInstance);
	if (bRet == FALSE)
	{
		return 0;
	}

	// [__CAO{bNX̕\
	DialogBox(hInstance, MAKEINTRESOURCE(IDD_MAINDIALOG), NULL, MainDialogProc);

	// CX^X̏I
	DeInit();

	return 0;
}
