/*
 * CAN/LIN Checker for RL78/F13,F14
 *
 * Target: QB-R5F10PPJ-TB (RL78/F14, 100pin, 256KB ROM, 20KB RAM)
 * Author: Yasushi Tanaka
 *
 * [ CANgV[o(TJA1050) ]
 */

#include "common.h"
#include "iodefine.h"
#include "log.h"
#include "can_tja.h"

/*
 * CANgV[o
 * Oo͒`
 */
#define CAN_TJA_LOG				(1)
									/* Oo͂ */

/*
 * SFRݒl(PM1WX^)
 */
#define RL78F_PM1_PM12			((u1)(0xfb))
									/* P12o̓[h */

/*
 * SFRݒl(P1WX^)
 */
#define RL78F_P1_P12			((u1)(0x04))
									/* P12o̓xH */

/*
 * CANgV[o
 * 
 */
void can_tja_init(void)
{
	/* o͕ɐ旧āA֎~ */
	P1 |= RL78F_P1_P12;

	/* o͕ݒ肷 */
	PM1 &= RL78F_PM1_PM12;
}

/*
 * CANgV[o
 * Jn
 */
void can_tja_start(void)
{
#if CAN_TJA_LOG != 0
	/* Oo */
	log_msg("CAN_TJA:high-speed mode");
#endif /* CAN_TJA_LOG != 0 */

	/* P12'L'xɂ邱Ƃœ샂[hɂȂ */
	P1 &= (u1)(~RL78F_P1_P12);
}

/*
 * CANgV[o
 * ~
 */
void can_tja_disable(void)
{
#if CAN_TJA_LOG != 0
	/* Oo */
	log_msg("CAN_TJA:silent mode");
#endif /* CAN_TJA_LOG != 0 */

	/* P12'H'xɂ邱ƂŒ~[hɂȂ */
	P1 |= RL78F_P1_P12;
}
