/*
 * CAN/LIN Checker for RL78/F13,F14
 *
 * Target: QB-R5F10PPJ-TB (RL78/F14, 100pin, 256KB ROM, 20KB RAM)
 * Author: Yasushi Tanaka
 *
 * [ ʒ` ]
 */

#ifndef COMMON_H
#define COMMON_H

/*
 * RpC`FbN
 */
#if !defined(__CCRL__) && !defined(__CA78K0R__)
#error not supported compiler
#endif /* !__CC_RL && !__CA78K0R__ */

/*
 * ʌ^`
 */
typedef unsigned char u1;
									/* unsigned, 8bit */
typedef unsigned short u2;
									/* unsigned, 16bit */
typedef unsigned long u4;
									/* unsigned, 32bit */

/*
 * NULL`
 */
#ifndef NULL
#ifdef __cplusplus
#define NULL					(0)
									/* for C++ */
#else
#define NULL					((void*)0)
									/* for C90 */
#endif /* __cplusplus */
#endif /* !NULL */

/*
 * TRUE/FALSE`
 */
#define U1_TRUE					(1)
									/* TRUE */
#define U1_FALSE				(0)
									/* FALSE */

/*
 * SADDR蓖Ē`
 */
#ifdef __CCRL__
#define SADDR					__saddr
									/* saddr̈֊蓖 */
#endif /* __CCRL__ */
#ifdef __CA78K0R__
#define SADDR					__sreg
									/* saddr̈֊蓖 */
#endif /* __CA78K0R__ */

#endif /* COMMON_H */
