//! @file gamemain.h
//! @brief Q[C̃wb_[

//--------------------------------------------------------------------------------
// 
// OpenXOPS
// Copyright (c) 2014-2015, OpenXOPS Project / [-_-;](mikan) All rights reserved.
// 
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
// * Redistributions of source code must retain the above copyright notice, 
//   this list of conditions and the following disclaimer.
// * Redistributions in binary form must reproduce the above copyright notice, 
//   this list of conditions and the following disclaimer in the documentation 
//   and/or other materials provided with the distribution.
// * Neither the name of the OpenXOPS Project nor the@names of its contributors 
//   may be used to endorse or promote products derived from this software 
//   without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL OpenXOPS Project BE LIABLE FOR ANY
// DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
// (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
// LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
// ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//--------------------------------------------------------------------------------

#ifndef GAMEMAIN_H
#define GAMEMAIN_H

#define ENABLE_DEBUGCONSOLE	//!< @brief fobNpR\[̗LiRgŋ@\j

#define MAINMENU_X 280		//!< j[̕\ XWij
#define MAINMENU_Y 140		//!< j[̕\ YWiVj
#define TOTAL_MENUITEMS 8	//!< j[1ʂɕ\~bV
#define MAINMENU_H (TOTAL_MENUITEMS+2)*30 + 25	//!< j[̕\TCYE

#define HUDA_WEAPON_POSX (SCREEN_WIDTH - 255)	//!< \̈EXW
#define HUDA_WEAPON_POSY (SCREEN_HEIGHT - 98)	//!< \̈EYW
#define HUDA_WEAPON_SIZEW 8		//!< \̈ETCYi32sNZ̔zuj
#define HUDA_WEAPON_SIZEH 3		//!< \̈EcTCYi32sNZ̔zuj

#define VIEW_HEIGHT 19.0f							//!< _̍
#define VIEWANGLE_NORMAL DegreeToRadian(65)			//!< p@W
#define VIEWANGLE_SCOPE_1 DegreeToRadian(30)		//!< p@XR[v1
#define VIEWANGLE_SCOPE_2 DegreeToRadian(15)		//!< p@XR[v2

#define TOTAL_EVENTLINE 3				//!< Cxg̃C
#define TOTAL_EVENTENTRYPOINT_0 -100	//!< C 0 ̊JnFԍ
#define TOTAL_EVENTENTRYPOINT_1 -110	//!< C 1 ̊JnFԍ
#define TOTAL_EVENTENTRYPOINT_2 -120	//!< C 2 ̊JnFԍ

#define TOTAL_EVENTENT_SHOWMESSEC 5.0f		//!< CxgbZ[W\b

#ifdef ENABLE_DEBUGCONSOLE
 #define MAX_CONSOLELEN 45		//!< fobNpR\[̕isj
 #define MAX_CONSOLELINES 9		//!< fobNpR\[̍s
 #define CONSOLE_PROMPT ">"		//!< fobNpR\[̃vvg
#endif

#ifndef H_LAYERLEVEL
 #define H_LAYERLEVEL 3		//!< Select include file.
#endif
#include "main.h"

int InitGame(WindowControl *WindowCtrl);

//! Q[̏Ԃ󂯓n\
struct GameInfo{
	bool selectaddon;		//!< addonI
	int selectmission_id;	//!< Iꂽ~bV
	bool missioncomplete;	//!< ~bV
	unsigned int framecnt;	//!< t[
	int fire;		//!< ˌ
	int ontarget;	//!< 
	int kill;		//!< |G̐	
	int headshot;	//!< G̓ɖ
};

#ifdef ENABLE_DEBUGCONSOLE
//! R\[Ǘ\
struct ConsoleData{
	int color;						//!< F
	char textdata[MAX_CONSOLELEN+1];	//!< 
};
#endif

//! @brief I[vjOʊǗNX
//! @details I[vjOʂǗ܂B
class opening : public D3Dscene
{
	//int opening_banner;		//!< I[vjOŕ\eNX`ID
	void Render3D();
	void Render2D();

public:
	opening();
	~opening();
	int Create();
	void Input();
	void Process();
	void Destroy();
};

//! @brief j[ʊǗNX
//! @details j[ʂǗ܂B
class mainmenu : public D3Dscene
{
	int mainmenu_mouseX;		//!< j[ʃ}EXXW
	int mainmenu_mouseY;		//!< j[ʃ}EXYW
	int mainmenu_scrollitems_official;	//!< j[ʂ̃XN[ACe
	int mainmenu_scrollitems_addon;		//!< j[ʂ̃XN[ACe
	float mainmenu_scrollbar_official_height;	//!< j[ʂ̃XN[o[̍
	float mainmenu_scrollbar_official_scale;	//!< j[ʂ̃XN[o[̖ڐ
	int mainmenu_scrollbar_official_y;			//!< j[ʂ̃XN[o[YW
	float mainmenu_scrollbar_addon_height;		//!< j[ʂ̃XN[o[̍
	float mainmenu_scrollbar_addon_scale;		//!< j[ʂ̃XN[o[̖ڐ
	int mainmenu_scrollbar_addon_y;				//!< j[ʂ̃XN[o[YW
	bool mainmenu_scrollbar_flag;		//!< j[ʂ̃XN[o[𑀍쒆tO
	int gametitle;				//!< Q[^Cg摜
	void Render3D();
	void Render2D();

public:
	mainmenu();
	~mainmenu();
	int Create();
	void Input();
	void Process();
	void Destroy();
};

//! @brief u[tBOʊǗNX
//! @details u[tBOʂǗ܂B
class briefing : public D2Dscene
{
	bool TwoTexture;	//!< u[tBO摜2gp
	int TextureA;	//!< u[tBO摜A
	int TextureB;	//!< u[tBO摜B
	void Render2D();

public:
	briefing();
	~briefing();
	int Create();
	void Destroy();
};

//! @brief CQ[ʊǗNX
//! @details CQ[ʂǗ܂B
class maingame : public D3Dscene
{
	//class EventControl Event[TOTAL_EVENTLINE];	//!< CxgNX
	float mouse_rx;		//!< }EXɂ鐅px
	float mouse_ry;		//!< }EXɂ鐂px
	float view_rx;		//!< }EXpxƃJpx̍ij
	float view_ry;		//!< }EXpxƃJpx̍ij 
	bool ShowInfo_Debugmode;	//!< WȂǂ\fobN[h
	bool Camera_Debugmode;		//!< JfobN[h
	bool tag;					//!< IuWFNg̃^O\
	bool radar;					//!< ȈՃ[_[\
	bool wireframe;				//!< }bvC[t[\
	bool CenterLine;			//!< 3DԂɒS\
	bool Camera_Blind;			//!< ډB\
	bool Camera_F1mode;			//!< JF1[h
	int Camera_F2mode;			//!< JF2[h
	bool Camera_HOMEmode;		//!< JHOME[h
	bool Cmd_F5;				//!< ZF5[h
	int InvincibleID;			//!< GȐl̔
	bool PlayerAI;				//!< vC[AIɈς˂
	bool AIstop;				//!< AI~
	bool AINoFight;				//!< AI퓬iȂj
	int start_framecnt;			//!< CQ[JñJEg
	int end_framecnt;			//!< CQ[ĨJEg
	bool EventStop;				//!< Cxg~
	int message_id;				//!< \̃CxgbZ[Wԍ
	int message_cnt;			//!< \̃CxgbZ[WJEg
	bool redflash_flag;		//!< bhtbV`tO
	int time;		//!< timer
	int time_input;					//!< ͎擾̏
	int time_process_object;		//!< {IuWFNg̏
	int time_process_ai;			//!< AȈ
	int time_process_event;			//!< Cxg̏
	int time_sound;				//!< TEh̏
	int time_render;				//!< `̏
	GameInfo MainGameInfo;			//!< UgpǗNX
	bool CheckInputControl(int CheckKey, int mode);
	void Render3D();
	void Render2D();
	bool GetRadarPos(float in_x, float in_y, float in_z, int RadarPosX, int RadarPosY, int RadarSize, float RadarWorldR, int *out_x, int *out_y, float *local_y, bool check);
	void RenderRadar();

#ifdef ENABLE_DEBUGCONSOLE
	bool Show_Console;			//!< fobNpR\[\
	ConsoleData *InfoConsoleData;			//!< fobNpR\[f[^i\ς݁j
	ConsoleData *InputConsoleData;			//!< fobNpR\[f[^i͒j
	char NewCommand[MAX_CONSOLELEN];	//!< Vɓ͂ꂽ̃R}h
	bool ScreenShot;		//!< SSBe
	void AddInfoConsole(int color, char *str);
	void ConsoleInputText(char inchar);
	void ConsoleDeleteText();
	bool GetCommandNum(char *cmd, int *num);
	void InputConsole();
	void ProcessConsole();
	void RenderConsole();
#endif

public:
	maingame();
	~maingame();
	int Create();
	void Input();
	void Process();
	void Sound();
	void Destroy();
};

//! @brief UgʊǗNX
//! @details Ugiʕ\jʂǗ܂B
class result : public D2Dscene
{
	void Render2D();

public:
	result();
	~result();
};

void InitScreen(opening *Opening, mainmenu *MainMenu, briefing *Briefing, maingame *MainGame, result *Result);
void ProcessScreen(WindowControl *WindowCtrl, opening *Opening, mainmenu *MainMenu, briefing *Briefing, maingame *MainGame, result *Result, unsigned int framecnt);

#endif