//! @file gamemain.h
//! @brief Q[C̃wb_[

//--------------------------------------------------------------------------------
// 
// OpenXOPS
// Copyright (c) 2014-2021, OpenXOPS Project / [-_-;](mikan) All rights reserved.
// 
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
// * Redistributions of source code must retain the above copyright notice, 
//   this list of conditions and the following disclaimer.
// * Redistributions in binary form must reproduce the above copyright notice, 
//   this list of conditions and the following disclaimer in the documentation 
//   and/or other materials provided with the distribution.
// * Neither the name of the OpenXOPS Project nor the names of its contributors 
//   may be used to endorse or promote products derived from this software 
//   without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL OpenXOPS Project BE LIABLE FOR ANY
// DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
// (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
// LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
// ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//--------------------------------------------------------------------------------

#ifndef GAMEMAIN_H
#define GAMEMAIN_H

#define MAINMENU_X (SCREEN_WIDTH - 360)			//!< j[̕\ XWij
#define MAINMENU_Y (SCREEN_HEIGHT - 340)		//!< j[̕\ YWiVj
#define TOTAL_MENUITEMS 8						//!< j[1ʂɕ\~bV
#define MAINMENU_H (TOTAL_MENUITEMS+2)*30 + 25	//!< j[̕\TCYE
#define MAINMENU_OPTION_X 10							//!< j[̕\ IvVڃNXWij
#define MAINMENU_OPTION_Y (MAINMENU_Y+MAINMENU_H - 16)	//!< j[̕\ IvVڃNYWiVj

#define INPUT_ARROWKEYS_ANGLE DegreeToRadian(4)		//!< L[ł̉]px
#define INPUT_F1NUMKEYS_ANGLE DegreeToRadian(2)		//!< Ol̎_ł̃eL[̉]px

#define HUDA_WEAPON_POSX (SCREEN_WIDTH - 255)	//!< `悷̈EXW
#define HUDA_WEAPON_POSY (SCREEN_HEIGHT - 98)	//!< `悷̈EYW
#define HUDA_WEAPON_SIZEW 8		//!< `悷̈ETCYi32sNZ̔zuj
#define HUDA_WEAPON_SIZEH 3		//!< `悷̈EcTCYi32sNZ̔zuj

#define VIEW_HEIGHT 19.0f							//!< _̍
#define VIEW_DIST 0.1f								//!< S王_܂ł̋
#define VIEW_F1MODE_ANGLE DegreeToRadian(-22.5f)	//!< Ol̎_ł̎_pxij
#define VIEW_F1MODE_DIST 14.0f						//!< Ol̎_ł̎_iőj
#define VIEW_FREECAMERA_SCALE 1.5f					//!< t[Jł̈ړxi[h́~2j
#define VIEWANGLE_NORMAL DegreeToRadian(65)			//!< p@W
#define VIEWANGLE_SCOPE_1 DegreeToRadian(30)		//!< p@XR[v1
#define VIEWANGLE_SCOPE_2 DegreeToRadian(15)		//!< p@XR[v2

#define TOTAL_EVENTLINE 3				//!< Cxg̃C
#define TOTAL_EVENTENTRYPOINT_0 -100	//!< C 0 ̊JnFԍ
#define TOTAL_EVENTENTRYPOINT_1 -110	//!< C 1 ̊JnFԍ
#define TOTAL_EVENTENTRYPOINT_2 -120	//!< C 2 ̊JnFԍ

#define TOTAL_EVENTENT_SHOWMESSEC 5.0f		//!< CxgbZ[W\b

#ifndef H_LAYERLEVEL
 #define H_LAYERLEVEL 3		//!< Select include file.
#endif
#include "main.h"

#ifdef ENABLE_MENUOPTIONS
 #define OPTIONS_P1_W 340												//!< IvV No.1@
 #define OPTIONS_P1_H (30*6)											//!< IvV No.1@
 #define OPTIONS_P1_X (SCREEN_WIDTH - 360)								//!< IvV No.1@XW
 #define OPTIONS_P1_Y (MAINMENU_Y+MAINMENU_H - OPTIONS_P1_H - 24)		//!< IvV No.1@YW
 #define OPTIONS_P1_DATAS 3												//!< IvV No.1@NeLXg̐
 #define OPTIONS_P2_W 600												//!< IvV No.2@
 #define OPTIONS_P2_H 360												//!< IvV No.2@
 #define OPTIONS_P2_X ((SCREEN_WIDTH - OPTIONS_P2_W)/2)					//!< IvV No.2@XW
 #define OPTIONS_P2_Y (105 + (SCREEN_HEIGHT-105 - OPTIONS_P2_H)/2)		//!< IvV No.2@YW
 #define OPTIONS_P2_DATAS 32											//!< IvV No.2@NeLXg̐
 #define OPTIONS_P3_W 600												//!< IvV No.3@
 #define OPTIONS_P3_H 320												//!< IvV No.3@
 #define OPTIONS_P3_X ((SCREEN_WIDTH - OPTIONS_P3_W)/2)					//!< IvV No.3@XW
 #define OPTIONS_P3_Y (105 + (SCREEN_HEIGHT-105 - OPTIONS_P3_H)/2)		//!< IvV No.3@YW
 #define OPTIONS_P3_DATAS 1												//!< IvV No.3@NeLXg̐
#if (GRAPHIC_ENGINE == 0)||(GRAPHIC_ENGINE == 1)
 #define OPTIONS_LICENSELINE 26											//!< CZX̍s
#elif GRAPHIC_ENGINE == 8
 #define OPTIONS_LICENSELINE 6											//!< CZX̍s
#endif	//GRAPHIC_ENGINE
#endif	//ENABLE_MENUOPTIONS

#ifdef ENABLE_DEBUGCONSOLE
 #define MAX_CONSOLELEN 78		//!< fobNpR\[̕isj
 #define MAX_CONSOLELINES 12	//!< fobNpR\[̍s
 #define CONSOLE_PROMPT ">"		//!< fobNpR\[̃vvg
#endif

int InitGame(WindowControl *WindowCtrl);
void CleanupGame();

//! Q[̏Ԃ󂯓n\
struct GameInfo{
	bool selectaddon;		//!< addonI
	int selectmission_id;	//!< Iꂽ~bV
	bool missioncomplete;	//!< ~bV
	unsigned int framecnt;	//!< t[
	int fire;		//!< ˌ
	float ontarget;	//!< 
	int kill;		//!< |G̐	
	int headshot;	//!< G̓ɖ
};

#ifdef ENABLE_MENUOPTIONS
//! j[NeLXg\
struct MenuLinkTextData{
	bool enable;	//!< NeLXgƂĂ̗LtO	
	int pos_x;		//!< XW
	int pos_y;		//!< YW
	int text_w;		//!< ̕
	int text_h;		//!< ̍
	int text_defaultcolor;		//!< W̕F
	int text_cursorcolor;		//!< I̕F
	char text[32];				//!< eLXg
};
#endif	//ENABLE_MENUOPTIONS

#ifdef ENABLE_DEBUGCONSOLE
//! R\[Ǘ\
struct ConsoleData{
	int color;						//!< F
	char textdata[MAX_CONSOLELEN+1];	//!< 
};
#endif

//! @brief I[vjOʊǗNX
//! @details I[vjOʂǗ܂B
class opening : public D3Dscene
{
	float add_camera_x;			//!< JW X̑
	float add_camera_y;			//!< JW Y̑
	float add_camera_z;			//!< JW Z̑
	float add_camera_rx;		//!< J]px RX̑
	float add_camera_ry;		//!< J]px RY̑
	//int opening_banner;		//!< I[vjOŕ\eNX`ID
	void Render3D();
	void Render2D();

public:
	opening();
	~opening();
	int Create();
	int Recovery();
	void Input();
	void Process();
	void Destroy();
};

//! @brief j[ʊǗNX
//! @details j[ʂǗ܂B
class mainmenu : public D3Dscene
{
	char demopath[MAX_PATH];		//!< ft@C̃pX
	int modescreen;					//!< \
	int mainmenu_mouseX;			//!< j[ʃ}EXXW
	int mainmenu_mouseY;			//!< j[ʃ}EXYW
	int mainmenu_mouseY_old;		//!< j[ʃ}EXYWiÕt[j
	class ScrollbarObject scrollbar_official;	//!< W~bṼXN[o[
	class ScrollbarObject scrollbar_addon;		//!< addoñXN[o[
	int gametitle;					//!< Q[^Cg摜
#ifdef ENABLE_MENUOPTIONS
	MenuLinkTextData Options_p1LinkTextData[OPTIONS_P1_DATAS];		//!< IvV No.1@NeLXgf[^
	MenuLinkTextData Options_p2LinkTextData[OPTIONS_P2_DATAS];		//!< IvV No.2@NeLXgf[^
	MenuLinkTextData Options_p3LinkTextData[OPTIONS_P3_DATAS];		//!< IvV No.3@NeLXgf[^
	class ScrollbarObject scrollbar_license;	//!< CZX̃XN[o[
	int Options_p2LinkTextID;					//!< IvV No.2@ꂽNeLXgID
	bool Options_FullscreenFlag_old;			//!< IvV No.2@tXN[tO
	int Options_KeyConfigID;					//!< IvV No.2@L[ݒID
	int Options_KeyConfigCnt;					//!< IvV No.2@L[ݒJEgit[j
	char *licenseinfo[OPTIONS_LICENSELINE];		//!< CZX
	char *licenseinfobuf;						//!< \郉CZXێobt@[
#endif	//ENABLE_MENUOPTIONS

	void Render3D();
	void Render2D();
#ifdef ENABLE_MENUOPTIONS
	void CreateOptions();
	void InputOptions();
	void ProcessOptions();
	void RenderOptions();
#endif	//ENABLE_MENUOPTIONS

public:
	mainmenu();
	~mainmenu();
	int Create();
	int Recovery();
	void Input();
	void Process();
	void Destroy();
};

//! @brief u[tBOʊǗNX
//! @details u[tBOʂǗ܂B
class briefing : public D2Dscene
{
	bool TwoTexture;	//!< u[tBO摜2gp
	int TextureA;	//!< u[tBO摜A
	int TextureB;	//!< u[tBO摜B
	void Render2D();

public:
	briefing();
	~briefing();
	int Create();
	int Recovery();
	void Destroy();
};

//! @brief CQ[ʊǗNX
//! @details CQ[ʂǗ܂B
class maingame : public D3Dscene
{
	//class EventControl Event[TOTAL_EVENTLINE];	//!< CxgNX
	int SkyNumber;			//!< wiԍ
	bool DarkScreenFlag;	//!< ʂÂ
	bool FogFlag;			//!< tHOL
	float mouse_rx;				//!< }EXɂ鐅px
	float mouse_ry;				//!< }EXɂ鐂px
	float view_rx;				//!< }EXpxƃJpx̍ij
	float view_ry;				//!< }EXpxƃJpx̍ij
	float add_camera_rx;		//!< J]px RX̑
	float add_camera_ry;		//!< J]px RY̑
	bool ShowInfo_Debugmode;	//!< WȂǂ\fobN[h
	bool Camera_Debugmode;		//!< JfobN[h
	bool tag;					//!< IuWFNg̃^O\
	bool radar;					//!< ȈՃ[_[\
	bool wireframe;				//!< }bvC[t[\
	bool nomodel;			//!< f`tO
	bool CenterLine;			//!< 3DԂɒS\
	bool Camera_Blind;			//!< ډB`
	bool Camera_F1mode;			//!< JF1[h
	int Camera_F2mode;			//!< JF2[h
	bool Camera_HOMEmode;		//!< JHOME[h
	bool Cmd_F5;				//!< ZF5[h
	int InvincibleID;			//!< GȐl̔
	bool PlayerAI;				//!< vC[AIɈς˂
	bool AIstop;				//!< AI~
	bool AINoFight;				//!< AI퓬iȂj
	int AIdebuginfoID;			//!< AĨfobN\
	int start_framecnt;			//!< CQ[JñJEg
	int end_framecnt;			//!< CQ[ĨJEg
	bool EventStop;				//!< Cxg~
	int GameSpeed;				//!< Q[̎sxi1ȏ̐lj
	int message_id;				//!< \̃CxgbZ[Wԍ
	int message_cnt;			//!< \̃CxgbZ[WJEg
	bool redflash_flag;		//!< bhtbV`tO
	int time;		//!< timer
	int time_input;					//!< ͎擾̏
	int time_process_object;		//!< {IuWFNg̏
	int time_process_ai;			//!< AȈ
	int time_process_event;			//!< Cxg̏
	int time_sound;				//!< TEh̏
	int time_render;				//!< `̏
	GameInfo MainGameInfo;			//!< UgpǗNX
	bool CheckInputControl(int CheckKey, int mode);
	void InputPlayer(human *myHuman, int mouse_x, int mouse_y, float MouseSensitivity);
	void InputViewCamera(int mouse_x, int mouse_y, float MouseSensitivity);
	void Render3D();
	void Render2D();
	bool GetRadarPos(float in_x, float in_y, float in_z, int RadarPosX, int RadarPosY, int RadarSize, float RadarWorldR, int *out_x, int *out_y, float *local_y, bool check);
	void RenderRadar();

#ifdef ENABLE_DEBUGCONSOLE
	bool Show_Console;			//!< fobNpR\[\
	ConsoleData *InfoConsoleData;			//!< fobNpR\[f[^i\ς݁j
	ConsoleData *InputConsoleData;			//!< fobNpR\[f[^i͒j
	char NewCommand[MAX_CONSOLELEN];	//!< Vɓ͂ꂽ̃R}h
	int ScreenShot;		//!< SSBe
	void AddInfoConsole(int color, char *str);
	void ConsoleInputText(char inchar);
	void ConsoleDeleteText();
	bool GetCommandNum(char *cmd, int *num);
	void InputConsole();
	void ProcessConsole();
	void RenderConsole();
#endif

public:
	maingame();
	~maingame();
	int GetGameSpeed();
	int Create();
	int Recovery();
	void Input();
	void Process();
	void Sound();
	void Destroy();
};

//! @brief UgʊǗNX
//! @details Ugiʕ\jʂǗ܂B
class result : public D2Dscene
{
	void Render2D();

public:
	result();
	~result();
};

void InitScreen(WindowControl *WindowCtrl, opening *Opening, mainmenu *MainMenu, briefing *Briefing, maingame *MainGame, result *Result);
void ProcessScreen(WindowControl *WindowCtrl, opening *Opening, mainmenu *MainMenu, briefing *Briefing, maingame *MainGame, result *Result, unsigned int framecnt);
int ChangeWindowMode(WindowControl *WindowCtrl, D3DGraphics *d3dg, InputControl *inputCtrl, scene *RecoveryScene, bool fullscreen);

#endif