//! @file main.h
//! @brief ŏʂ̃wb_[t@C

//--------------------------------------------------------------------------------
// 
// OpenXOPS
// Copyright (c) 2014-2022, OpenXOPS Project / [-_-;](mikan) All rights reserved.
// 
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
// * Redistributions of source code must retain the above copyright notice, 
//   this list of conditions and the following disclaimer.
// * Redistributions in binary form must reproduce the above copyright notice, 
//   this list of conditions and the following disclaimer in the documentation 
//   and/or other materials provided with the distribution.
// * Neither the name of the OpenXOPS Project nor the names of its contributors 
//   may be used to endorse or promote products derived from this software 
//   without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL OpenXOPS Project BE LIABLE FOR ANY
// DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
// (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
// LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
// ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//--------------------------------------------------------------------------------

#ifndef MAIN_H
#define MAIN_H

#define MAINICON 101		//!< Icon

#ifdef _DEBUG
 #define _CRTDBG_MAP_ALLOC
 #include <crtdbg.h>
#endif

#ifndef H_LAYERLEVEL
 #define H_LAYERLEVEL 3		//!< Select include file.
#endif

#pragma warning(disable:4996)		//VC++xh~
//#pragma warning(disable:4244)

//萔
#define GAMENAME "OpenXOPS"				//!< Q[
#define GAMEVERSION "1.073p"			//!< Q[̃o[W
#define GAMEFRAMEMS 30					//!< t[̏ԁimsj
#define GAMEFPS (1000.0f/GAMEFRAMEMS)	//!< FPSit[[gj@1000 / 30 = 33.333[FPS]
#define DEFAULT_SCREEN_WIDTH 640		//!< XN[̕
#define DEFAULT_SCREEN_HEIGHT 480		//!< XN[̍

#define MAX_ADDONLIST 128		//!< ADDONǂݍލő吔

#define TOTAL_HAVEWEAPON 2		//!< Ă镐̐

//VXẽCN[ht@C
#define _USE_MATH_DEFINES	 //!< math.h 'M_PI' enable
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <string.h>
#include <direct.h>

#define ENABLE_BUG_HUMANWEAPON			//!< ͈͊O̐lEޔԍpoOČiRgŖj
#define ENABLE_BUG_TEAMID				//!< `[ԍ𕉐ɐݒ肵ۂ̃oOČiRgŖj
#define ENABLE_INPUT_MOUSE8BIT			//!< }EX͂char^ 8bitɂiRgŖj
#define ENABLE_WEAPONNAME_SCALING		//!< 햼ꍇɕ\kiRgŖj
#define ENABLE_ADDOBJ_PARAM8BIT			//!< ǉ̐ݒlchar^ 8bitɂiRgŖj
#define ENABLE_DEBUGCONSOLE				//!< fobNpR\[̗LiRgŋ@\j
#define ENABLE_DEBUGLOG					//!< fobNpOo̗͂LiRgŋ@\j
#define ENABLE_CHECKOPENXOPSEVENT		//!< OpenXOPS씻pCxg̗LiRgŋ@\j
#define ENABLE_MENUOPTIONS				//!< j[ɃIvVʒǉiRgŋ@\j
//#define ENABLE_AUTOCREATECONFIG		//!< config.datȂꍇAt@CB
//#define ENABLE_PATH_DELIMITER_SLASH	//!< pX؂蕶A'\'e/f֕ϊB
#define ENABLE_AUTOLOADMIF				//!< .mifɎw肳ꂽꍇAIɃ[hiRgŋ@\j
#define ENABLE_ADDCONFIG				//!< init@Cɂǉݒ擾iRgŋ@\j
#define ENABLE_CHECKDATADIR				//!< NdatatH_[̗L`FbNiRgŋ@\j

//windows.hgpȂȂ
#ifndef _MAX_PATH
 #define _MAX_PATH 260		//!< _MAX_PATH is 260
#endif
#ifndef MAX_PATH
 #define MAX_PATH 260		//!< MAX_PATH is 260
#endif

//BorlandC++ Compilerp̏
#ifdef __BORLANDC__
 //#define sqrtf(df) sqrt(df)
 int _matherr(struct _exception  *__e) { return 1; }
#endif

//gp̑΍p}N
#ifndef MAIN_H
 #define UNREFERENCED_PARAMETER(P) ((P)=(P))
#endif

//float^̎Zp֐p
#ifndef _MSC_VER
 #define sinf(x) (float)sin(x)				//!< sinf(x)
 #define cosf(x) (float)cos(x)				//!< cosf(x)
 #define asinf(x) (float)asin(x)			//!< asinf(x)
 #define acosf(x) (float)acos(x)			//!< acosf(x)
 #define atan2f(y,x) (float)atan2(y,x)		//!< atan2f(y,x)
 #define sqrtf(x) (float)sqrt(x)			//!< sqrtf(x)
 #define floorf(x) (float)floor(x)			//!< floorf(x)
 #define ceilf(x) (float)ceil(x)			//!< ceilf(x)
 #define fabsf(x) (float)fabs(x)			//!< fabsf(x)
#endif

#define SetFlag(value, bit) value = value | bit		//!< rbgɂtO ݒ
#define DelFlag(value, bit) value = value & (~bit)	//!< rbgɂtO 
#define GetFlag(value, bit) (value & bit)			//!< rbgɂtO 擾

#define DegreeToRadian(value) ((float)M_PI/180*value)	//!< x烉WAւ̕ϊ

//჌C[
#if H_LAYERLEVEL >= 1
 #include "debug.h"
 #include "window.h"
 #include "config.h"
 #include "datafile.h"
 #include "d3dgraphics.h"
 #include "input.h"
 #include "sound.h"
 #include "parameter.h"
#endif

//ԃC[
#if H_LAYERLEVEL >= 2
 #include "resource.h"
 #include "collision.h"
 #include "object.h"
 #include "soundmanager.h"
 #include "gui-object.h"
#endif

//C[
#if H_LAYERLEVEL >= 3
 #include "objectmanager.h"
 #include "scene.h"
 #include "gamemain.h"
 #include "ai.h"
 #include "statemachine.h"
 #include "event.h"
#endif

//ǉCu
// not .lib

#ifdef ENABLE_DEBUGLOG
 extern class DebugLog OutputLog;
#endif
extern class StateMachine GameState;
extern class Config GameConfig;

bool CheckCommandParameter(const char *param, const char *cmd);
float AngleNormalization(float r);
void Set2ByteLittleEndian(unsigned char *outdata, unsigned int value);
void Set4ByteLittleEndian(unsigned char *outdata, unsigned int value);
void Set2ByteBigEndian(unsigned char *outdata, unsigned int value);
void Set4ByteBigEndian(unsigned char *outdata, unsigned int value);
unsigned int Get2ByteLittleEndian(unsigned char *indata);
unsigned int Get4ByteLittleEndian(unsigned char *indata);
unsigned int Get2ByteBigEndian(unsigned char *indata);
unsigned int Get4ByteBigEndian(unsigned char *indata);

#endif