/*
 * Decompiled with CFR 0.152.
 */
package org.slim3.gen.generator;

import org.slim3.gen.desc.DaoDesc;
import org.slim3.gen.generator.Generator;
import org.slim3.gen.printer.Printer;
import org.slim3.gen.util.ClassUtil;

public class DaoGenerator
implements Generator {
    protected final DaoDesc daoDesc;

    public DaoGenerator(DaoDesc daoDesc) {
        if (daoDesc == null) {
            throw new NullPointerException("The daoDesc parameter is null.");
        }
        this.daoDesc = daoDesc;
    }

    public void generate(Printer p) {
        if (this.daoDesc.getPackageName().length() != 0) {
            p.println("package %s;", this.daoDesc.getPackageName());
            p.println();
        }
        p.println("import %s;", "org.slim3.datastore.DaoBase");
        p.println();
        p.println("import %s;", this.daoDesc.getModelClassName());
        p.println();
        String modelSimpleClassName = ClassUtil.getSimpleName(this.daoDesc.getModelClassName());
        p.println("public class %s extends %s<%s>{", this.daoDesc.getSimpleName(), ClassUtil.getSimpleName("org.slim3.datastore.DaoBase"), modelSimpleClassName);
        p.println();
        p.println("}", new Object[0]);
    }
}

