/*
 * Decompiled with CFR 0.152.
 */
package org.slim3.gen.generator;

import org.slim3.gen.desc.DaoDesc;
import org.slim3.gen.generator.Generator;
import org.slim3.gen.printer.Printer;
import org.slim3.gen.util.ClassUtil;

public class DaoTestCaseGenerator
implements Generator {
    protected final DaoDesc daoDesc;

    public DaoTestCaseGenerator(DaoDesc daoDesc) {
        if (daoDesc == null) {
            throw new NullPointerException("The daoDesc parameter is null.");
        }
        this.daoDesc = daoDesc;
    }

    public void generate(Printer p) {
        if (this.daoDesc.getPackageName().length() != 0) {
            p.println("package %s;", this.daoDesc.getPackageName());
            p.println();
        }
        if (!"java.lang.Object".equals(this.daoDesc.getTestCaseSuperclassName())) {
            p.println("import %s;", this.daoDesc.getTestCaseSuperclassName());
        }
        p.println("import %s;", "org.junit.Test");
        p.println("import static %s.*;", "org.junit.Assert");
        p.println("import static %s.*;", "org.hamcrest.CoreMatchers");
        p.println();
        p.print("public class %s%s", this.daoDesc.getSimpleName(), "Test");
        if (!"java.lang.Object".equals(this.daoDesc.getTestCaseSuperclassName())) {
            p.print(" extends %s", ClassUtil.getSimpleName(this.daoDesc.getTestCaseSuperclassName()));
        }
        p.println(" {", new Object[0]);
        p.println();
        p.println("    private %1$s dao = new %1$s();", this.daoDesc.getSimpleName());
        p.println();
        p.println("    @%s", ClassUtil.getSimpleName("org.junit.Test"));
        p.println("    public void test() throws Exception {", new Object[0]);
        p.println("        assertThat(dao, is(notNullValue()));", new Object[0]);
        p.println("    }", new Object[0]);
        p.println("}", new Object[0]);
    }
}

