/*
 * Decompiled with CFR 0.152.
 */
package org.slim3.gen.processor;

import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import com.sun.mirror.apt.Filer;
import java.io.IOException;
import java.io.Writer;
import org.slim3.gen.desc.ClassDesc;
import org.slim3.gen.generator.Generator;
import org.slim3.gen.printer.FilePrinter;
import org.slim3.gen.printer.Printer;

public class GenerateSupport {
    protected final AnnotationProcessorEnvironment env;

    public GenerateSupport(AnnotationProcessorEnvironment env) {
        if (env == null) {
            throw new NullPointerException("The env parameter is null.");
        }
        this.env = env;
    }

    public void generate(Generator generator, ClassDesc classDesc) {
        if (generator == null) {
            throw new NullPointerException("The generator parameter is null.");
        }
        if (classDesc == null) {
            throw new NullPointerException("The classDesc parameter is null.");
        }
        Filer filer = this.env.getFiler();
        Printer printer = null;
        try {
            printer = this.createPrinter(filer.createSourceFile(classDesc.getQualifiedName()));
            generator.generate(printer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (printer != null) {
                printer.close();
            }
        }
    }

    protected Printer createPrinter(Writer writer) throws IOException {
        return new FilePrinter(writer);
    }
}

