/*
 * Decompiled with CFR 0.152.
 */
package org.slim3.gen.task;

import java.io.IOException;
import javax.xml.xpath.XPathExpressionException;
import org.slim3.gen.desc.DaoDesc;
import org.slim3.gen.generator.DaoGenerator;
import org.slim3.gen.generator.DaoTestCaseGenerator;
import org.slim3.gen.generator.Generator;
import org.slim3.gen.message.MessageCode;
import org.slim3.gen.message.MessageFormatter;
import org.slim3.gen.task.AbstractGenJavaFileTask;
import org.slim3.gen.task.ClassNameBuilder;
import org.slim3.gen.task.GenModelTask;
import org.slim3.gen.task.JavaFile;
import org.slim3.gen.task.WebConfig;

public class GenDaoTask
extends AbstractGenJavaFileTask {
    protected String packageName;
    protected String testCaseSuperclassName = "org.slim3.tester.AppEngineTestCase";
    protected String modelDefinition;
    protected String daoClassNameProperty;

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public void setTestCaseSuperclassName(String testCaseSuperclassName) {
        this.testCaseSuperclassName = testCaseSuperclassName;
    }

    public void setModelDefinition(String modelDefinition) {
        this.modelDefinition = modelDefinition;
    }

    public void setDaoClassNameProperty(String daoClassNameProperty) {
        this.daoClassNameProperty = daoClassNameProperty;
    }

    public void doExecute() throws Exception {
        super.doExecute();
        if (this.modelDefinition == null) {
            throw new IllegalStateException("The modelDefinition parameter is null.");
        }
        if (this.daoClassNameProperty == null) {
            throw new IllegalStateException("The daoClassNameProperty parameter is null.");
        }
        if (this.getProject().getProperty(this.daoClassNameProperty) != null) {
            throw new IllegalStateException(MessageFormatter.getMessage(MessageCode.SLIM3GEN0009, this.daoClassNameProperty));
        }
        DaoDesc daoDesc = this.createDaoDesc();
        JavaFile javaFile = this.createJavaFile(daoDesc);
        Generator generator = this.createDaoGenerator(daoDesc);
        this.generateJavaFile(generator, javaFile);
        JavaFile testCaseJavaFile = this.createTestCaseJavaFile(daoDesc);
        Generator testCaseGenerator = this.createDaoTestCaseGenerator(daoDesc);
        this.generateJavaFile(testCaseGenerator, testCaseJavaFile);
        this.getProject().setNewProperty(this.daoClassNameProperty, daoDesc.getQualifiedName());
    }

    protected DaoDesc createDaoDesc() throws IOException, XPathExpressionException {
        GenModelTask.ModelDef modelDef = this.parse(this.modelDefinition);
        String basePackageName = this.getBasePackageName();
        String modelPackageName = basePackageName + "." + "model";
        String daoPackageName = basePackageName + "." + "dao";
        String daoSimpleClassName = modelDef.modelRelativeClassName + "Dao";
        DaoDesc daoDesc = new DaoDesc();
        ClassNameBuilder classNameBuilder = new ClassNameBuilder();
        classNameBuilder.append(daoPackageName);
        classNameBuilder.append(daoSimpleClassName);
        daoDesc.setPackageName(classNameBuilder.getPackageName());
        daoDesc.setSimpleName(classNameBuilder.getSimpleName());
        daoDesc.setModelClassName(modelPackageName + "." + modelDef.modelRelativeClassName);
        daoDesc.setTestCaseSuperclassName(this.testCaseSuperclassName);
        return daoDesc;
    }

    protected GenModelTask.ModelDef parse(String input) {
        GenModelTask task = new GenModelTask();
        return task.parse(input);
    }

    protected String getBasePackageName() throws IOException, XPathExpressionException {
        if (this.packageName != null) {
            return this.packageName;
        }
        WebConfig config = this.createWebConfig();
        StringBuilder buf = new StringBuilder();
        buf.append(config.getRootPackageName());
        if (config.isGWTServiceServletDefined()) {
            buf.append(".");
            buf.append("shared");
        }
        return buf.toString();
    }

    protected Generator createDaoGenerator(DaoDesc daoDesc) {
        return new DaoGenerator(daoDesc);
    }

    protected Generator createDaoTestCaseGenerator(DaoDesc daoDesc) {
        return new DaoTestCaseGenerator(daoDesc);
    }
}

