/*
 * Decompiled with CFR 0.152.
 */
package org.slim3.gen.task;

import java.io.IOException;
import javax.xml.xpath.XPathExpressionException;
import org.slim3.gen.desc.GWTServiceAsyncDesc;
import org.slim3.gen.desc.GWTServiceDesc;
import org.slim3.gen.generator.GWTServiceAsyncGenerator;
import org.slim3.gen.generator.GWTServiceGenerator;
import org.slim3.gen.generator.Generator;
import org.slim3.gen.message.MessageCode;
import org.slim3.gen.message.MessageFormatter;
import org.slim3.gen.task.AbstractGenJavaFileTask;
import org.slim3.gen.task.ClassNameBuilder;
import org.slim3.gen.task.JavaFile;
import org.slim3.gen.task.WebConfig;

public class GenGWTServiceTask
extends AbstractGenJavaFileTask {
    protected String packageName;
    protected String serviceDefinition;
    protected String remoteServiceRelativePath = "service.s3gwt";
    protected String serviceClassNameProperty;

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public void setServiceDefinition(String serviceDefinition) {
        this.serviceDefinition = serviceDefinition;
    }

    public void setRemoteServiceRelativePath(String remoteServiceRelativePath) {
        this.remoteServiceRelativePath = remoteServiceRelativePath;
    }

    public void setServiceClassNameProperty(String serviceClassNameProperty) {
        this.serviceClassNameProperty = serviceClassNameProperty;
    }

    public void doExecute() throws Exception {
        super.doExecute();
        if (this.serviceDefinition == null) {
            throw new IllegalStateException("The serviceDefinition parameter is null.");
        }
        if (this.serviceClassNameProperty == null) {
            throw new IllegalStateException("The serviceClassNameProperty parameter is null.");
        }
        if (this.getProject().getProperty(this.serviceClassNameProperty) != null) {
            throw new IllegalStateException(MessageFormatter.getMessage(MessageCode.SLIM3GEN0009, this.serviceClassNameProperty));
        }
        GWTServiceDesc serviceDesc = this.createServiceDesc();
        JavaFile serviceJavaFile = this.createJavaFile(serviceDesc);
        Generator serviceGenerator = this.createServiceGenerator(serviceDesc);
        this.generateJavaFile(serviceGenerator, serviceJavaFile);
        GWTServiceAsyncDesc serviceAsyncDesc = this.createServiceAsyncDesc(serviceDesc);
        JavaFile serviceAsyncJavaFile = this.createJavaFile(serviceAsyncDesc);
        Generator serviceAsyncGenerator = this.createServiceAsyncGenerator(serviceAsyncDesc);
        this.generateJavaFile(serviceAsyncGenerator, serviceAsyncJavaFile);
        this.getProject().setNewProperty(this.serviceClassNameProperty, serviceDesc.getQualifiedName());
    }

    private GWTServiceDesc createServiceDesc() throws IOException, XPathExpressionException {
        ClassNameBuilder nameBuilder = new ClassNameBuilder();
        nameBuilder.append(this.getServiceBasePackageName());
        nameBuilder.append(this.serviceDefinition);
        GWTServiceDesc serviceDesc = new GWTServiceDesc();
        serviceDesc.setPackageName(nameBuilder.getPackageName());
        serviceDesc.setSimpleName(nameBuilder.getSimpleName());
        serviceDesc.setRemoteServiceRelativePath(this.remoteServiceRelativePath);
        return serviceDesc;
    }

    protected String getServiceBasePackageName() throws IOException, XPathExpressionException {
        if (this.packageName != null) {
            return this.packageName;
        }
        WebConfig config = this.createWebConfig();
        StringBuilder buf = new StringBuilder();
        buf.append(config.getRootPackageName());
        buf.append(".");
        buf.append("client");
        buf.append(".");
        buf.append("service");
        return buf.toString();
    }

    private GWTServiceAsyncDesc createServiceAsyncDesc(GWTServiceDesc serviceDesc) {
        GWTServiceAsyncDesc serviceAsyncDesc = new GWTServiceAsyncDesc();
        serviceAsyncDesc.setPackageName(serviceDesc.getPackageName());
        serviceAsyncDesc.setSimpleName(serviceDesc.getSimpleName() + "Async");
        return serviceAsyncDesc;
    }

    protected Generator createServiceGenerator(GWTServiceDesc serviceDesc) {
        return new GWTServiceGenerator(serviceDesc);
    }

    protected Generator createServiceAsyncGenerator(GWTServiceAsyncDesc serviceAsyncDesc) {
        return new GWTServiceAsyncGenerator(serviceAsyncDesc);
    }
}

