/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.datastore.DatastoreCallbacks;
import com.google.appengine.api.datastore.DatastoreCallbacksImpl;
import com.google.appengine.api.datastore.DeleteContext;
import com.google.appengine.api.datastore.ImplicitTransactionManagementPolicy;
import com.google.appengine.api.datastore.PostLoadContext;
import com.google.appengine.api.datastore.PreGetContext;
import com.google.appengine.api.datastore.PreQueryContext;
import com.google.appengine.api.datastore.PutContext;
import com.google.appengine.api.datastore.ReadPolicy;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public final class DatastoreServiceConfig {
    static final int DEFAULT_RPC_SIZE_LIMIT_BYTES = 0x100000;
    static final int DEFAULT_MAX_BATCH_GET_KEYS = 1000;
    static final int DEFAULT_MAX_BATCH_WRITE_ENTITIES = 500;
    static final String DEFAULT_MAX_ENTITY_GROUPS_PER_RPC_SYS_PROP = "appengine.datastore.defaultMaxEntityGroupsPerRpc";
    static final int DEFAULT_MAX_ENTITY_GROUPS_PER_RPC = DatastoreServiceConfig.getDefaultMaxEntityGroupsPerRpc();
    static final String CALLBACKS_CONFIG_SYS_PROP = "appengine.datastore.callbacksConfig";
    static volatile DatastoreCallbacks CALLBACKS = null;
    private static final String CALLBACKS_CONFIG_FILE = "/META-INF/datastorecallbacks.xml";
    private ImplicitTransactionManagementPolicy implicitTransactionManagementPolicy = ImplicitTransactionManagementPolicy.NONE;
    private ReadPolicy readPolicy = new ReadPolicy(ReadPolicy.Consistency.STRONG);
    private Double deadline;
    private int maxRpcSizeBytes = 0x100000;
    private int maxBatchWriteEntities = 500;
    private int maxBatchReadEntities = 1000;
    private int maxEntityGroupsPerRpc = DEFAULT_MAX_ENTITY_GROUPS_PER_RPC;

    static int getDefaultMaxEntityGroupsPerRpc() {
        return DatastoreServiceConfig.getDefaultMaxEntityGroupsPerRpc(DEFAULT_MAX_ENTITY_GROUPS_PER_RPC_SYS_PROP, 10);
    }

    static int getDefaultMaxEntityGroupsPerRpc(String sysPropName, int defaultVal) {
        String sysPropVal = System.getProperty(sysPropName);
        return sysPropVal == null ? defaultVal : Integer.parseInt(sysPropVal);
    }

    private static InputStream getCallbacksConfigInputStream() {
        String callbacksConfig = System.getProperty(CALLBACKS_CONFIG_SYS_PROP);
        InputStream is = callbacksConfig != null ? new ByteArrayInputStream(callbacksConfig.getBytes()) : DatastoreServiceConfig.class.getResourceAsStream(CALLBACKS_CONFIG_FILE);
        return is;
    }

    private DatastoreServiceConfig() {
    }

    DatastoreServiceConfig(DatastoreServiceConfig config) {
        this.implicitTransactionManagementPolicy = config.implicitTransactionManagementPolicy;
        this.readPolicy = config.readPolicy;
        this.deadline = config.deadline;
        this.maxRpcSizeBytes = config.maxRpcSizeBytes;
        this.maxBatchWriteEntities = config.maxBatchWriteEntities;
        this.maxBatchReadEntities = config.maxBatchReadEntities;
        this.maxEntityGroupsPerRpc = config.maxEntityGroupsPerRpc;
    }

    public DatastoreServiceConfig implicitTransactionManagementPolicy(ImplicitTransactionManagementPolicy p) {
        if (p == null) {
            throw new NullPointerException("implicit transaction management policy must not be null");
        }
        this.implicitTransactionManagementPolicy = p;
        return this;
    }

    public DatastoreServiceConfig readPolicy(ReadPolicy readPolicy) {
        if (readPolicy == null) {
            throw new NullPointerException("read policy must not be null");
        }
        this.readPolicy = readPolicy;
        return this;
    }

    public DatastoreServiceConfig deadline(double deadline) {
        if (deadline <= 0.0) {
            throw new IllegalArgumentException("deadline must be > 0, got " + deadline);
        }
        this.deadline = deadline;
        return this;
    }

    DatastoreServiceConfig maxBatchWriteEntities(int maxBatchWriteEntities) {
        if (maxBatchWriteEntities <= 0) {
            throw new IllegalArgumentException("maxBatchWriteEntities must be > 0, got " + maxBatchWriteEntities);
        }
        this.maxBatchWriteEntities = maxBatchWriteEntities;
        return this;
    }

    DatastoreServiceConfig maxBatchReadEntities(int maxBatchReadEntities) {
        if (maxBatchReadEntities <= 0) {
            throw new IllegalArgumentException("maxBatchReadEntities must be > 0, got " + maxBatchReadEntities);
        }
        this.maxBatchReadEntities = maxBatchReadEntities;
        return this;
    }

    DatastoreServiceConfig maxRpcSizeBytes(int maxRpcSizeBytes) {
        if (maxRpcSizeBytes < 0) {
            throw new IllegalArgumentException("maxRpcSizeBytes must be >= 0, got " + maxRpcSizeBytes);
        }
        this.maxRpcSizeBytes = maxRpcSizeBytes;
        return this;
    }

    public DatastoreServiceConfig maxEntityGroupsPerRpc(int maxEntityGroupsPerRpc) {
        if (maxEntityGroupsPerRpc <= 0) {
            throw new IllegalArgumentException("maxEntityGroupsPerRpc must be > 0, got " + maxEntityGroupsPerRpc);
        }
        this.maxEntityGroupsPerRpc = maxEntityGroupsPerRpc;
        return this;
    }

    public ImplicitTransactionManagementPolicy getImplicitTransactionManagementPolicy() {
        return this.implicitTransactionManagementPolicy;
    }

    public ReadPolicy getReadPolicy() {
        return this.readPolicy;
    }

    public Integer getMaxEntityGroupsPerRpc() {
        return this.getMaxEntityGroupsPerRpcInternal();
    }

    int getMaxEntityGroupsPerRpcInternal() {
        return this.maxEntityGroupsPerRpc;
    }

    public Double getDeadline() {
        return this.deadline;
    }

    boolean exceedsWriteLimits(int count, int size) {
        return count > this.maxBatchWriteEntities || count > 1 && size > this.maxRpcSizeBytes;
    }

    boolean exceedsReadLimits(int count, int size) {
        return count > this.maxBatchReadEntities || count > 1 && size > this.maxRpcSizeBytes;
    }

    DatastoreCallbacks getDatastoreCallbacks() {
        if (CALLBACKS == null) {
            InputStream is = DatastoreServiceConfig.getCallbacksConfigInputStream();
            CALLBACKS = is == null ? new DatastoreCallbacks(){

                @Override
                public void executePrePutCallbacks(PutContext context) {
                }

                @Override
                public void executePostPutCallbacks(PutContext context) {
                }

                @Override
                public void executePreDeleteCallbacks(DeleteContext context) {
                }

                @Override
                public void executePostDeleteCallbacks(DeleteContext context) {
                }

                @Override
                public void executePreGetCallbacks(PreGetContext context) {
                }

                @Override
                public void executePostLoadCallbacks(PostLoadContext context) {
                }

                @Override
                public void executePreQueryCallbacks(PreQueryContext context) {
                }
            } : new DatastoreCallbacksImpl(is, false);
        }
        return CALLBACKS;
    }

    public static final class Builder {
        public static DatastoreServiceConfig withImplicitTransactionManagementPolicy(ImplicitTransactionManagementPolicy p) {
            return Builder.withDefaults().implicitTransactionManagementPolicy(p);
        }

        public static DatastoreServiceConfig withReadPolicy(ReadPolicy readPolicy) {
            return Builder.withDefaults().readPolicy(readPolicy);
        }

        public static DatastoreServiceConfig withDeadline(double deadline) {
            return Builder.withDefaults().deadline(deadline);
        }

        public static DatastoreServiceConfig withMaxEntityGroupsPerRpc(int maxEntityGroupsPerRpc) {
            return Builder.withDefaults().maxEntityGroupsPerRpc(maxEntityGroupsPerRpc);
        }

        public static DatastoreServiceConfig withDefaults() {
            return new DatastoreServiceConfig();
        }

        private Builder() {
        }
    }
}

