/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.datastore.ValidatedQuery;
import com.google.apphosting.api.DatastorePb;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

class IndexComponentsOnlyQuery
extends ValidatedQuery {
    private final Set<String> equalityProps = new LinkedHashSet<String>();
    private final List<OnestoreEntity.Index.Property> orderProps = new ArrayList<OnestoreEntity.Index.Property>();
    private final Set<String> existsProps = new LinkedHashSet<String>();
    private boolean hasKeyProperty = false;

    public IndexComponentsOnlyQuery(DatastorePb.Query query) {
        super(query);
        this.removeNativelySupportedComponents();
        this.categorizeQuery();
    }

    private void removeNativelySupportedComponents() {
        DatastorePb.Query.Order lastOrder;
        for (DatastorePb.Query.Filter filter : this.query.filters()) {
            if (filter.getOpEnum() != DatastorePb.Query.Filter.Operator.EXISTS) continue;
            return;
        }
        boolean hasKeyDescOrder = false;
        if (this.query.orderSize() > 0 && (lastOrder = this.query.getOrder(this.query.orderSize() - 1)).getProperty().equals("__key__")) {
            if (lastOrder.getDirection() == DatastorePb.Query.Order.Direction.ASCENDING.getValue()) {
                this.query.removeOrder(this.query.orderSize() - 1);
            } else {
                hasKeyDescOrder = true;
            }
        }
        if (!hasKeyDescOrder) {
            boolean hasNonKeyInequality = false;
            for (DatastorePb.Query.Filter f : this.query.filters()) {
                if (!ValidatedQuery.INEQUALITY_OPERATORS.contains(f.getOpEnum()) || "__key__".equals(f.getProperty(0).getName())) continue;
                hasNonKeyInequality = true;
                break;
            }
            if (!hasNonKeyInequality) {
                Iterator<DatastorePb.Query.Filter> itr = this.query.filterIterator();
                while (itr.hasNext()) {
                    if (!itr.next().getProperty(0).getName().equals("__key__")) continue;
                    itr.remove();
                }
            }
        }
    }

    private void categorizeQuery() {
        HashSet<String> ineqProps = new HashSet<String>();
        this.hasKeyProperty = false;
        for (DatastorePb.Query.Filter filter : this.query.filters()) {
            String propName = filter.getProperty(0).getName();
            switch (filter.getOpEnum()) {
                case EQUAL: {
                    this.equalityProps.add(propName);
                    break;
                }
                case EXISTS: {
                    this.existsProps.add(propName);
                    break;
                }
                case GREATER_THAN: 
                case GREATER_THAN_OR_EQUAL: 
                case LESS_THAN: 
                case LESS_THAN_OR_EQUAL: {
                    ineqProps.add(propName);
                }
            }
            if (!propName.equals("__key__")) continue;
            this.hasKeyProperty = true;
        }
        if (this.query.orderSize() == 0 && !ineqProps.isEmpty()) {
            this.orderProps.add(new OnestoreEntity.Index.Property().setName((String)ineqProps.iterator().next()));
        }
        for (DatastorePb.Query.Order order : this.query.orders()) {
            if (order.getProperty().equals("__key__")) {
                this.hasKeyProperty = true;
            }
            this.orderProps.add(new OnestoreEntity.Index.Property().setName(order.getProperty()).setDirection(order.getDirection()));
        }
    }

    public Set<String> getEqualityProps() {
        return this.equalityProps;
    }

    public List<OnestoreEntity.Index.Property> getOrderProps() {
        return this.orderProps;
    }

    public Set<String> getExistsProps() {
        return this.existsProps;
    }

    public boolean hasKeyProperty() {
        return this.hasKeyProperty;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexComponentsOnlyQuery that = (IndexComponentsOnlyQuery)o;
        return this.query.equals(that.query);
    }

    @Override
    public int hashCode() {
        return this.query.hashCode();
    }
}

