/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.labs.repackaged.com.google.common.io;

import com.google.appengine.labs.repackaged.com.google.common.annotations.GoogleInternal;
import com.google.appengine.labs.repackaged.com.google.common.io.InputSupplier;
import java.io.IOException;
import java.io.InputStream;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.InvalidMarkException;

@GoogleInternal
public final class ByteBuffers {
    private ByteBuffers() {
    }

    public static ByteBuffer allocate(int capacity) {
        return ByteBuffer.allocate(capacity).order(ByteOrder.LITTLE_ENDIAN);
    }

    public static ByteBuffer allocateDirect(int capacity) {
        return ByteBuffer.allocateDirect(capacity).order(ByteOrder.LITTLE_ENDIAN);
    }

    public static ByteBuffer allocateDirectAndFlip(int capacity) {
        ByteBuffer buf = ByteBuffer.allocateDirect(capacity).order(ByteOrder.LITTLE_ENDIAN);
        buf.flip();
        return buf;
    }

    public static ByteBuffer wrap(byte[] array) {
        return ByteBuffer.wrap(array).order(ByteOrder.LITTLE_ENDIAN);
    }

    public static byte[] extractBytes(ByteBuffer buf) {
        if (buf.hasArray() && buf.arrayOffset() == 0 && buf.position() == 0 && buf.limit() == buf.capacity()) {
            return buf.array();
        }
        byte[] result = new byte[buf.remaining()];
        buf.get(result);
        buf.position(buf.position() - result.length);
        return result;
    }

    public static InputSupplier<InputStream> newInputStreamSupplier(final ByteBuffer buf) {
        return new InputSupplier<InputStream>(){

            @Override
            public InputStream getInput() {
                return ByteBuffers.newConsumingInputStream(buf.slice());
            }
        };
    }

    public static InputStream newConsumingInputStream(final ByteBuffer buf) {
        return new InputStream(){

            @Override
            public int read() {
                try {
                    return buf.get();
                }
                catch (BufferUnderflowException bue) {
                    return -1;
                }
            }

            @Override
            public int read(byte[] b, int off, int len) {
                if (buf.hasRemaining()) {
                    int toRead = Math.min(len, buf.remaining());
                    buf.get(b, off, toRead);
                    return toRead;
                }
                return -1;
            }

            @Override
            public long skip(long n) {
                if (n <= 0L) {
                    return 0L;
                }
                int toSkip = (int)Math.min((long)buf.remaining(), n);
                buf.position(toSkip + buf.position());
                return toSkip;
            }

            @Override
            public int available() {
                return buf.remaining();
            }

            @Override
            public boolean markSupported() {
                return true;
            }

            @Override
            public synchronized void mark(int readlimit) {
                buf.mark();
            }

            @Override
            public synchronized void reset() throws IOException {
                try {
                    buf.reset();
                }
                catch (InvalidMarkException ime) {
                    throw new IOException(ime);
                }
            }
        };
    }
}

