package jp.co.opst.sms.controller;

import javax.servlet.http.HttpSession;

import jp.co.opst.sms.logic.LoginLogic;

import org.slim3.controller.Controller;
import org.slim3.controller.Navigation;

import com.google.appengine.api.users.User;
import com.google.appengine.api.users.UserService;
import com.google.appengine.api.users.UserServiceFactory;

public class LoginController extends Controller {

	@Override
	public Navigation run() throws Exception {
		UserService us = UserServiceFactory.getUserService();
		User user = LoginLogic.checkLogin();

		if (user == null) {
			return redirect(us.createLoginURL(request.getRequestURI()));
		}

		HttpSession session = request.getSession();
		session.setAttribute("UserInformation", us.getCurrentUser());

		return forward("/member/");
	}
}
