package jp.co.opst.sms.controller.masterTools.user;

import jp.co.opst.sms.dao.UserInformationDao;
import jp.co.opst.sms.model.UserInformation;

import org.slim3.tester.ControllerTestCase;
import org.hamcrest.core.IsNull;
import org.junit.Test;

import com.google.appengine.api.datastore.KeyFactory;

import static org.junit.Assert.*;
import static org.hamcrest.CoreMatchers.*;

public class InsertControllerTest extends ControllerTestCase {

    @Test
    public void run() throws Exception {
        tester.start("/masterTools/user/insert");
        InsertController controller = tester.getController();
        assertThat(controller, is(notNullValue()));
        assertThat(tester.isRedirect(), is(false));
        assertThat(tester.getDestinationPath(), is(nullValue()));

    }
    
    @Test
    public void insertNewUser(){
        UserInformation ui = new UserInformation();
        ui.setEMail("test.test@google.co.jp");
        ui.setAuthority("S");
        InsertController ic = new InsertController();
        ic.doInsertNewUser(ui);
        
        ui = new UserInformation();
        
        UserInformationDao uidao = new UserInformationDao();
        ui = uidao.get(KeyFactory.createKey("User", "test.test@google.co.jp"));
        assertThat(ui, null);
    }
}
