#!/usr/local/bin/ruby
#-*- coding: utf-8 -*-

basedir = File::expand_path(File.dirname($0))
$:.unshift File::join([basedir,".."])
require 'yadaemon'

## If opts["daemon"] is true, then the current-working-dir will be moved to '/'.
## In above case, you must expand the relative path by File::expand_path.
outfile = File::join(basedir,"out.txt")

opts = {}
opts[:debug] = true
opts[:daemon] = true
appname = File::basename($0,".rb")
daemon = YaDaemon.new(appname,"#{appname}.pid","/tmp", opts)
if ARGV[0] == "restart"
  begin
    daemon.stop
    while daemon.check_proc
      sleep 1
    end
    puts "running process was terminated."
  rescue
    puts $!
    puts "failed to restart process."
  end
elsif ARGV[0] == "stop"
  begin
    daemon.stop
    while daemon.check_proc
      sleep 1
    end
    puts "running process was terminated."
  rescue
    puts $!
  end
  exit
end

daemon.run do |pid|
  i = 0
  while daemon.running
    open(outfile,"w") do |f|
      f.flock(File::LOCK_EX)
      f.write(format("%s: %s\n", open(pid).read, i))
      f.flush
      f.truncate(f.pos)
    end
    i += 1
    sleep 5
  end
end
puts "another daemon is already running" if daemon.running
