// firmEmu.cpp : AvP[ṼGg |Cg`܂B
//

#include "stdafx.h"

#define MAX_LOADSTRING 100

// O[oϐ:
HINSTANCE hInst;								// ݂̃C^[tFCX
TCHAR szTitle[MAX_LOADSTRING];					// ^Cg o[̃eLXg
TCHAR szWindowClass[MAX_LOADSTRING];			// C EBhE NX
ssd322 oled;
PortServerSock svport;

HWND hMainWnd;
HWND hLogWnd;
HRGN hBtnRgn[7];
HRGN hLedRgn[7];
HRGN hRotRgn;
int nBtnDown=0;

// ̃R[h W[Ɋ܂܂֐̐錾]܂:
ATOM				MyRegisterClass(HINSTANCE hInstance);
BOOL				InitInstance(HINSTANCE, int);
LRESULT CALLBACK	WndProc(HWND, UINT, WPARAM, LPARAM);
INT_PTR CALLBACK	About(HWND, UINT, WPARAM, LPARAM);

int APIENTRY _tWinMain(HINSTANCE hInstance,
                     HINSTANCE hPrevInstance,
                     LPTSTR    lpCmdLine,
                     int       nCmdShow)
{
	UNREFERENCED_PARAMETER(hPrevInstance);
	UNREFERENCED_PARAMETER(lpCmdLine);

 	// TODO: ɃR[h}ĂB
	MSG msg;
	HACCEL hAccelTable;

	// O[oĂ܂B
	LoadString(hInstance, IDS_APP_TITLE, szTitle, MAX_LOADSTRING);
	LoadString(hInstance, IDC_FIRMEMU, szWindowClass, MAX_LOADSTRING);
	MyRegisterClass(hInstance);

	// AvP[V̏s܂:
	if (!InitInstance (hInstance, nCmdShow))
	{
		return FALSE;
	}

	hAccelTable = LoadAccelerators(hInstance, MAKEINTRESOURCE(IDC_FIRMEMU));

	// C bZ[W [v:
	while (GetMessage(&msg, NULL, 0, 0))
	{
		if (!TranslateAccelerator(msg.hwnd, hAccelTable, &msg))
		{
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}
	}

	return (int) msg.wParam;
}



//
//  ֐: MyRegisterClass()
//
//  ړI: EBhE NXo^܂B
//
//  Rg:
//
//    ̊֐юǵA'RegisterClassEx' ֐ǉꂽ
//    Windows 95 O Win32 VXeƌ݊ꍇɂ̂ݕKvłB
//    AvP[VA֘Atꂽ
//    `̏ACR擾ł悤ɂɂ́A
//    ̊֐ĂяoĂB
//
ATOM MyRegisterClass(HINSTANCE hInstance)
{
	oled.init(hInstance);
	WNDCLASSEX wcex;

	wcex.cbSize = sizeof(WNDCLASSEX);

	wcex.style			= CS_HREDRAW | CS_VREDRAW;
	wcex.lpfnWndProc	= WndProc;
	wcex.cbClsExtra		= 0;
	wcex.cbWndExtra		= 0;
	wcex.hInstance		= hInstance;
	wcex.hIcon			= LoadIcon(hInstance, MAKEINTRESOURCE(IDI_FIRMEMU));
	wcex.hCursor		= LoadCursor(NULL, IDC_ARROW);
	wcex.hbrBackground	= (HBRUSH)(30/*COLOR_MENUBAR*/+1);
	wcex.lpszMenuName	= NULL;//MAKEINTRESOURCE(IDC_FIRMEMU);
	wcex.lpszClassName	= szWindowClass;
	wcex.hIconSm		= LoadIcon(wcex.hInstance, MAKEINTRESOURCE(IDI_SMALL));

	return RegisterClassEx(&wcex);
}

//
//   ֐: InitInstance(HINSTANCE, int)
//
//   ړI: CX^X nhۑāAC EBhE쐬܂B
//
//   Rg:
//
//        ̊֐ŁAO[oϐŃCX^X nhۑA
//        C vO EBhE쐬ѕ\܂B
//
BOOL InitInstance(HINSTANCE hInstance, int nCmdShow)
{
	int i;
	int yc = 180;
	int xc[7] = {30,100,150,220,270,340,390};
	for(i = 0; i < 7; i++) {
		hBtnRgn[i] = CreateEllipticRgn(xc[i]-20,yc-20,xc[i]+20, yc+20);
		hLedRgn[i] = CreateEllipticRgn(xc[i]-12,yc-12,xc[i]+12, yc+12);
	}
	hRotRgn = CreateEllipticRgn(470, yc-30, 530, yc+30);

	HWND hWnd;
	hInst = hInstance; // O[oϐɃCX^Xi[܂B
	hWnd = CreateWindow(szWindowClass, szTitle, WS_OVERLAPPEDWINDOW,
	  CW_USEDEFAULT, 0, CW_USEDEFAULT, 0, NULL, NULL, hInstance, NULL);

	if (!hWnd)
	{
	  return FALSE;
	}
	oled.createDipslay(hWnd, 10, 10);

	hLogWnd = CreateWindow(L"EDIT",L"",WS_CHILD|WS_VISIBLE|WS_BORDER|WS_VSCROLL|ES_MULTILINE ,
		10, 10+128+30+40+20, 512, 256, hWnd, NULL, hInstance, NULL);
	SendMessage(hLogWnd, EM_SETLIMITTEXT, 0,0);

	ShowWindow(hWnd, nCmdShow);
	UpdateWindow(hWnd);
	hMainWnd = hWnd;

	WSADATA wsaData;
	WSAStartup(MAKEWORD(2,0), &wsaData);

	svport.open(6602);

	return TRUE;
}

void log(const char *msg)
{
	int len = GetWindowTextLength(hLogWnd);
	SendMessageA(hLogWnd, EM_SETSEL, len, len);
	SendMessageA(hLogWnd, EM_REPLACESEL, 0, (LPARAM)msg);
}

void cmdError(Port *p, const char *cmd)
{
	log("*ERR*\r\n");
	log(cmd);
	log("\r\n");
	p->sendData(2,"?\n");
}

void cmdDSPBright(Port *p, const char *cmd)
{
	p->sendData(2,"?\n");
}
void cmdDSPClear(Port *p, const char *cmd)
{
	log("C\r\n");
	oled.clear();
}
void cmdTunnerFreq(Port *p, const char *cmd)
{
	p->sendData(2,"?\n");
}
void cmdDSPPower(Port *p, const char *cmd)
{
	p->sendData(2,"?\n");
}
void cmdDSPPix(Port *p, const char *cmd)
{
	char b[100];
	const unsigned char *_c = (const unsigned char *)cmd;
	sprintf(b, "P %d %d %2.2x %2.2x %2.2x %2.2x %2.2x %2.2x %2.2x %2.2x\r\n",
		_c[0], _c[1], _c[2], _c[3], _c[4], _c[5], _c[6], _c[7], _c[8], _c[9]);
	log(b);
	oled.send((unsigned char*)cmd);
}
void cmdTunnerInfo(Port *p, const char *cmd)
{
	p->sendData(2,"?\n");
}
void cmdSelectSource(Port *p, const char *cmd)
{
	p->sendData(2,"?\n");
}
void cmdTunnerScan(Port *p, const char *cmd)
{
	p->sendData(2,"?\n");
}
void cmdVolume(Port *p, const char *cmd)
{
	p->sendData(2,"?\n");
}
void cmdReset(Port *p, const char *cmd)
{
	p->sendData(2,"?\n");
}

void doCommand(Port *p, const char *cmd)
{
	switch( *cmd ) {
	case 'A':	cmdError(p, cmd+1);	break;
	case 'B':	cmdDSPBright(p, cmd+1);	break;
	case 'C':	cmdDSPClear(p, cmd+1);	break;
	case 'D':	cmdError(p, cmd);	break;
	case 'E':	cmdError(p, cmd);	break;
	case 'F':	cmdTunnerFreq(p, cmd+1);	break;
	case 'G':	cmdError(p, cmd);	break;
	case 'H':	cmdError(p, cmd);	break;
	case 'I':	cmdError(p, cmd);	break;
	case 'J':	cmdError(p, cmd);	break;
	case 'K':	cmdError(p, cmd);	break;
	case 'L':	cmdError(p, cmd);	break;
	case 'M':	cmdError(p, cmd);	break;
	case 'N':	cmdError(p, cmd);	break;
	case 'O':	cmdDSPPower(p, cmd+1);	break;
	case 'P':	cmdDSPPix(p, cmd+1);	break;	
	case 'Q':	cmdTunnerInfo(p, cmd+1);	break;	
	case 'R':	cmdError(p, cmd);	break;
	case 'S':	cmdSelectSource(p, cmd+1);	break;	
	case 'T':	cmdTunnerScan(p, cmd+1);	break;	
	case 'U':	cmdError(p, cmd);	break;
	case 'V':	cmdVolume(p, cmd);	break;	
	case 'W':	cmdError(p, cmd);	break;
	case 'X':	cmdError(p, cmd);	break;
	case 'Y':	cmdError(p, cmd);	break;
	case 'Z':	cmdReset(p, cmd);	break;	
	default:	cmdError(p, cmd);	break;
	}
	p->sendData(1,">");
}

void doPaint(HWND hWnd, HDC hDC)
{
	RECT r;
	GetClientRect(hWnd, &r);
	int i;
	HBRUSH hWhtBr = (HBRUSH)GetStockObject(WHITE_BRUSH);
	HBRUSH hBtnBr = (HBRUSH)GetStockObject(BLACK_BRUSH);
	HBRUSH hLedBr = CreateSolidBrush(RGB(0x80,0x80,0xff));
	for( i = 0; i < 7; i++ ) {
		FillRgn(hDC, hBtnRgn[i], hWhtBr);
		FrameRgn(hDC, hBtnRgn[i], hBtnBr, 1, 1);
		FrameRgn(hDC, hLedRgn[i], hLedBr, 1, 1);
	}
	FillRgn(hDC, hRotRgn, hWhtBr);
	FrameRgn(hDC, hRotRgn, hBtnBr, 1, 1);
	DeleteObject(hLedBr);

	/*
	int yb = 10 + 128 + 20;
	HRGN hRgn = CreateEllipticRgn( 10, yb, 10+40, yb+40);
	FillRgn(hDC, hRgn, (HBRUSH)GetStockObject(WHITE_BRUSH));
	FrameRgn(hDC, hRgn, (HBRUSH)GetStockObject(BLACK_BRUSH), 1, 1);
	OffsetRgn(hRgn, 70, 0);
	FillRgn(hDC, hRgn, (HBRUSH)GetStockObject(WHITE_BRUSH));
	FrameRgn(hDC, hRgn, (HBRUSH)GetStockObject(BLACK_BRUSH), 1, 1);
	OffsetRgn(hRgn, 50, 0);
	FillRgn(hDC, hRgn, (HBRUSH)GetStockObject(WHITE_BRUSH));
	FrameRgn(hDC, hRgn, (HBRUSH)GetStockObject(BLACK_BRUSH), 1, 1);
	OffsetRgn(hRgn, 70, 0);
	FillRgn(hDC, hRgn, (HBRUSH)GetStockObject(WHITE_BRUSH));
	FrameRgn(hDC, hRgn, (HBRUSH)GetStockObject(BLACK_BRUSH), 1, 1);
	OffsetRgn(hRgn, 50, 0);
	FillRgn(hDC, hRgn, (HBRUSH)GetStockObject(WHITE_BRUSH));
	FrameRgn(hDC, hRgn, (HBRUSH)GetStockObject(BLACK_BRUSH), 1, 1);
	OffsetRgn(hRgn, 70, 0);
	FillRgn(hDC, hRgn, (HBRUSH)GetStockObject(WHITE_BRUSH));
	FrameRgn(hDC, hRgn, (HBRUSH)GetStockObject(BLACK_BRUSH), 1, 1);
	OffsetRgn(hRgn, 50, 0);
	FillRgn(hDC, hRgn, (HBRUSH)GetStockObject(WHITE_BRUSH));
	FrameRgn(hDC, hRgn, (HBRUSH)GetStockObject(BLACK_BRUSH), 1, 1);
	DeleteObject(hRgn);

	hRgn = CreateEllipticRgn(3, yb-7, 10+40+7, yb+40+7);
	OffsetRgn(hRgn, 150+210+100, 0);
	FillRgn(hDC, hRgn, (HBRUSH)GetStockObject(WHITE_BRUSH));
	FrameRgn(hDC, hRgn, (HBRUSH)GetStockObject(BLACK_BRUSH), 1, 1);
	DeleteObject(hRgn);

	HBRUSH hBr = CreateSolidBrush(RGB(0x80,0x80,0xff));

	hRgn = CreateEllipticRgn( 10+8, yb+8, 10+40-8, yb+40-8);
	FrameRgn(hDC, hRgn, hBr, 1, 1);
	OffsetRgn(hRgn, 70, 0);
	FrameRgn(hDC, hRgn, hBr, 1, 1);
	OffsetRgn(hRgn, 50, 0);
	FrameRgn(hDC, hRgn, hBr, 1, 1);
	OffsetRgn(hRgn, 70, 0);
	FrameRgn(hDC, hRgn, hBr, 1, 1);
	OffsetRgn(hRgn, 50, 0);
	FrameRgn(hDC, hRgn, hBr, 1, 1);
	OffsetRgn(hRgn, 70, 0);
	FrameRgn(hDC, hRgn, hBr, 1, 1);
	OffsetRgn(hRgn, 50, 0);
	FrameRgn(hDC, hRgn, hBr, 1, 1);
	DeleteObject(hRgn);
	DeleteObject(hBr);
	*/
}

//
//  ֐: WndProc(HWND, UINT, WPARAM, LPARAM)
//
//  ړI:  C EBhẼbZ[W܂B
//
//  WM_COMMAND	- AvP[V j[̏
//  WM_PAINT	- C EBhE̕`
//  WM_DESTROY	- ~bZ[W\Ė߂
//
//
LRESULT CALLBACK WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	int wmId, wmEvent;
	PAINTSTRUCT ps;
	HDC hdc;

	switch (message)
	{
	case WM_COMMAND:
		wmId    = LOWORD(wParam);
		wmEvent = HIWORD(wParam);
		// Iꂽj[̉:
		switch (wmId)
		{
		case IDM_ABOUT:
			DialogBox(hInst, MAKEINTRESOURCE(IDD_ABOUTBOX), hWnd, About);
			break;
		case IDM_EXIT:
			DestroyWindow(hWnd);
			break;
		default:
			return DefWindowProc(hWnd, message, wParam, lParam);
		}
		break;
	case WM_SIZE:
		{
			RECT r;
			GetClientRect(hWnd, &r);
			SetWindowPos(hLogWnd,
				NULL,
				0, 0, (r.right - r.left)-20, (r.bottom-r.top)-(10+128+30+40+20+10),
				SWP_NOACTIVATE|SWP_NOMOVE|SWP_NOOWNERZORDER|SWP_NOZORDER);
		}
		break;
	case WM_PAINT:
		hdc = BeginPaint(hWnd, &ps);
		doPaint(hWnd, hdc);
		EndPaint(hWnd, &ps);
		break;
	case WM_LBUTTONDOWN:
		{
			POINT pt;
			pt.x	= lParam & 0xFFFF;
			pt.y	= (lParam >> 16) & 0xFFFF;
			int i;
			for( i = 0; i < 7; i++ ) {
				if( PtInRegion(hBtnRgn[i], pt.x, pt.y) ) {
					Port *port = svport.getConnection();
					if( port ) {
						char msg[4];
						sprintf(msg, "D%d", i);
						port->sendPacket(2, msg);
						SetCapture(hWnd);
					}
					nBtnDown = i+1;
					break;
				}
			}
		}
		break;
	case WM_LBUTTONUP:
		{
			if( nBtnDown != 0 ) {
				Port *port = svport.getConnection();
				if( port ) {
					char msg[4];
					sprintf(msg, "U%d", nBtnDown-1);
					port->sendPacket(2, msg);
				}
				nBtnDown = 0;
				ReleaseCapture();
			}
		}
		break;
	case WM_MOUSEWHEEL:
		{
			Port *port = svport.getConnection();
			if( port ) {
				int z = GET_WHEEL_DELTA_WPARAM(wParam);
				if( z < 0 ) {
					port->sendPacket(1, "R");
				} else {
					port->sendPacket(1, "L");
				}
			}
			return 0;
		}
		break;
	case WM_DESTROY:
		PostQuitMessage(0);
		break;
	default:
		return DefWindowProc(hWnd, message, wParam, lParam);
	}
	return 0;
}

// o[W{bNX̃bZ[W nhłB
INT_PTR CALLBACK About(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	UNREFERENCED_PARAMETER(lParam);
	switch (message)
	{
	case WM_INITDIALOG:
		return (INT_PTR)TRUE;

	case WM_COMMAND:
		if (LOWORD(wParam) == IDOK || LOWORD(wParam) == IDCANCEL)
		{
			EndDialog(hDlg, LOWORD(wParam));
			return (INT_PTR)TRUE;
		}
		break;
	}
	return (INT_PTR)FALSE;
}
