/*
 * portServerSock.cpp
 *
 *  Created on: 2012/03/02
 *      Author: tanaka
 */
#include "stdafx.h"

void log(const char *msg);

PortServerSock::PortServerSock()
{
	conn = NULL;
}

PortServerSock::~PortServerSock()
{
}

bool PortServerSock::open(int port)
{
	struct sockaddr_in srcAddr;
	memset(&srcAddr, 0, sizeof(srcAddr));
	srcAddr.sin_port = htons(port);
	srcAddr.sin_family = AF_INET;
	srcAddr.sin_addr.s_addr = htonl(INADDR_ANY);

	SOCKET s = socket(AF_INET, SOCK_STREAM, 0);
	if( s == -1 ) {
		return false;
	}
	bool optval = 1/*1*/;
	int res = ::setsockopt( s, SOL_SOCKET, SO_REUSEADDR, (char*)&optval, sizeof(bool) );

	if( bind(s, (struct sockaddr *) &srcAddr, sizeof(srcAddr)) == -1 ) {
		return false;
	}

	if( listen(s, 1) == -1 ) {
		return false;
	}
	sock = s;

	DWORD dwThreadId;
	hThread = (HANDLE)_beginthreadex(NULL,0,(unsigned (_stdcall*)(void*))workerThread,(void*)this, 0, (unsigned int *)&dwThreadId);

	return true;
}

void PortServerSock::close()
{
	closesocket(sock);
}

unsigned __stdcall PortServerSock::workerThread( void *arg )
{
	PortServerSock *inst = (PortServerSock*)arg;
	inst->process();
	return 0;
}

bool PortServerSock::process()
{
	while(1) {
		struct sockaddr_in clientAddr;
		memset(&clientAddr, 0, sizeof(clientAddr));
		int clientAddrLen=sizeof(clientAddr);

		SOCKET c = accept(sock, (struct sockaddr *)&clientAddr, &clientAddrLen);
		if( c == INVALID_SOCKET ) return false;
		conn = new Port(c);
		if( conn == NULL ) {
			::closesocket(c);
			return false;
		}
		conn->process();
		delete conn;
		conn = NULL;
	}
	return true;
}

void PortServerSock::stop()
{
	closesocket(sock);
	if( conn ) conn->close();
	WaitForSingleObject(hThread, INFINITE);
}

Port::Port(SOCKET s)
{
	sock		= s;
	endSock		= false;
	chunkRead	= 0;
	chunkSize	= 0;
}

Port::~Port()
{
	close();
}

void Port::close()
{
	if( sock ) {
		::closesocket(sock);
		sock	= 0;
	}
}

void doCommand(Port *p, const char *cmd);

bool Port::process()
{
	char buff[256];
	size_t rs;
	sendData(1, ">\r\n");
	while(1) {
		if( !recvPacket(256, buff, rs) ) break;
		doCommand(this, buff);
	}
	return true;
}

bool Port::sendData(size_t size, const char *data)
{
	//chunkRead	= 0;
	//chunkSize	= 0;
	if( sock == 0 ) {
		return false;
	}
	size_t sendLen = ::send(sock, data, size, 0);
	if( sendLen < 0 || sendLen != size ) {
		return false;
	}
	return true;
}

bool Port::recvData(size_t size, char *data, size_t &readed)
{
	readed = 0;
	char *bp = data;
	while(1) {
		if( chunkSize ) {
			char *p = &chunk[chunkRead];
			while( chunkRead < chunkSize && size > 0 ) {
				*bp++ = *p++;
				size--;
				chunkRead++;
			}
			if( size == 0 ) {
				*bp = 0;
				readed = bp - data;
				return true;
			}
		}

		chunkRead	= 0;
		chunkSize	= 0;
		while(chunkSize == 0) {
			size_t recvs = recv(sock, chunk, sizeof(chunk), 0);
			if(recvs == 0) {
				endSock	= true;
				return false;
			}
			if( (int)recvs == SOCKET_ERROR ) {
				if( WSAGetLastError() == WSAEINPROGRESS ) {
					continue;
				} else {
					return false;
				}
			}
			chunkSize = recvs;
		}
	}
	return false;
}

bool Port::flushInput()
{
	char tmp[1024];
	size_t rs;
	while(1) {
		if( !recvData(1024, tmp, rs) ) {
			return false;
		}
		if( rs == 0 ) break;
	}
	return true;
}

bool Port::recvPacket(size_t size, char *data, size_t &readed)
{
	char hd[8];
	size_t rs;
	int i;
	for(i=0; i < 5; i++ ) {
		if( !recvData(2, hd, rs) ) return false;
		if( rs != 2 ) {
			log("packet recive error. frame header empty.\r\n");
			return false;
		}
		if( hd[0] != 'S' ) {
			log("packet recive error. frame header not found.\r\n");
			if( !flushInput() ) {
				log("packet recive error. can't flush input stream\r\n");
				return false;
			}
			sendData(1,"F");
			continue;
		}
		if( hd[1] != 0 ) {
			if( (size_t)(hd[1]) > size ) {
				log("packet recive error. buffer size not enough\r\n");
				return false;
			}
		}
		if( !recvData(hd[1], data, rs) ) {
			log("packet recive error. packet body cant't read.\r\n");
			return false;
		}
		if( rs != hd[1] ) {
			log("packet recive error. packet body size unmatch.\r\n");
			return false;
		}
		readed = rs;
		if( !recvData(1, hd, rs) ) return false;
		if( rs != 1 ) return false;
		if( hd[0] != 'E' ) {
			log("packet recive error. frame terminator not found.\r\n");
			if( !flushInput() ) {
				log("packet recive error. can't flush input stream\r\n");
				return false;
			}
			sendData(1,"F");
			continue;
		}
		break;
	}
	if( i == 5 ) {
		log("packet recive error. retry 5 times, but do not found header.\r\n");
		return false;
	}
	return true;
}

bool Port::sendPacket(size_t size, char *data)
{
	char len=size;
	sendData(1,"S");
	sendData(1,&len);
	sendData(size,data);
	sendData(1,"E");
	return true;
}
