/*
 * portServerSock.h
 *
 *  Created on: 2012/03/02
 *      Author: tanaka
 */

#ifndef PORTSERVERSOCK_H_
#define PORTSERVERSOCK_H_

class Port
{
public:
	Port(SOCKET s);
	~Port();

	void	close();
	bool	sendData(size_t size, const char *data);
	bool	recvData(size_t size, char *data, size_t &readed);
	bool	recvPacket(size_t size, char *data, size_t &readed);
	bool	sendPacket(size_t size, char *data);
	bool	flushInput();
	bool	process();

protected:
	SOCKET	sock;
	HANDLE hThread;
	bool	endSock;
	char	chunk[256];
	size_t	chunkRead;
	size_t	chunkSize;
};

class PortServerSock
{
public:
	PortServerSock();
	~PortServerSock();

	bool	open(int port);
	void	close();
	bool	process();
	void	closed(Port *p);
	void	stop();
	Port*	getConnection() { return conn; }

	static unsigned __stdcall workerThread( void *arg );

protected:
	SOCKET sock;
	Port *conn; 
	HANDLE hThread;
};


#endif /* PORTSERVERSOCK_H_ */
