#include "ssd322emu.h"

ssd322::ssd322()
{
	hWnd	= NULL;
	hInst	= NULL;
}

ssd322::~ssd322()
{
}

bool ssd322::init(HINSTANCE hInstance)
{
	hWnd	= NULL;
	hInst	= hInstance;

	WNDCLASSEX wcex;
	wcex.cbSize = sizeof(WNDCLASSEX);
	wcex.style			= CS_HREDRAW | CS_VREDRAW;
	wcex.lpfnWndProc	= (WNDPROC)wndProcEnt;
	wcex.cbClsExtra		= 0;
	wcex.cbWndExtra		= 0;
	wcex.hInstance		= hInstance;
	wcex.hIcon			= NULL;
	wcex.hCursor		= NULL;
	wcex.hbrBackground	= (HBRUSH)::GetStockObject(BLACK_BRUSH);
	wcex.lpszMenuName	= NULL;
	wcex.lpszClassName	= L"OLEDPanel";
	wcex.hIconSm		= NULL;
	RegisterClassEx(&wcex);
	return true;
}

void ssd322::send(const unsigned char *data)
{
	int y = (int)(*data); data++;
	int x = (int)(*data); data++;
	unsigned char *v0 = gram + y * 8 * 512*3*2 + x*8*6;
	unsigned char *v1 = v0 + 512*3;
	for(int i = 0; i < 8; i++) {
		unsigned char c = *data++;
		for(int b = 0; b < 8; b++) {
			if( c & 0x80 ) {
				*v0++ = 0xff;
				*v0++ = 0x80;
				*v0++ = 0x80;
				*v0++ = 0xff;
				*v0++ = 0x80;
				*v0++ = 0x80;
				*v1++ = 0xff;
				*v1++ = 0x80;
				*v1++ = 0x80;
				*v1++ = 0xff;
				*v1++ = 0x80;
				*v1++ = 0x80;
			} else {
				*v0++ = 0;
				*v0++ = 0;
				*v0++ = 0;
				*v0++ = 0;
				*v0++ = 0;
				*v0++ = 0;
				*v1++ = 0;
				*v1++ = 0;
				*v1++ = 0;
				*v1++ = 0;
				*v1++ = 0;
				*v1++ = 0;
			}
			c = c << 1;
		}
		v0 += 512*3*2-48;
		v1 = v0 + 512*3;
	}
	RECT r;
	r.left	= x*8*2;
	r.top	= y*8*2;
	r.right	= r.left + 16;
	r.bottom= r.top + 16;
	InvalidateRect(hWnd, &r, FALSE);
}

void ssd322::clear()
{
	memset(gram, 0, sizeof(gram));
	InvalidateRect(hWnd, NULL, TRUE);
}

bool ssd322::createDipslay(HWND hParentWnd, int x, int y)
{
	hWnd = CreateWindow(L"OLEDPanel", NULL, WS_CHILD|WS_VISIBLE,
      x, y, 512, 128, hParentWnd, NULL, hInst, NULL);

	if (!hWnd)
	{
	  return false;
	}

	memset(gram, 0, sizeof(gram));

	unsigned char sd[10];
	sd[0] = 1;
	sd[1] = 1;
	sd[2] = 0x80;
	sd[3] = 0x40;
	sd[4] = 0x20;
	sd[5] = 0x10;
	sd[6] = 0x08;
	sd[7] = 0x04;
	sd[8] = 0x02;
	sd[9] = 0x01;
	send(sd);

	::SetProp(hWnd, L"OBJ", (HANDLE)this);
	ShowWindow(hWnd, SW_SHOW);
	UpdateWindow(hWnd);

	return TRUE;
}

void ssd322::doPaint(HDC hDC)
{
	RECT rect;
	GetClientRect(hWnd, &rect);
/*
	unsigned char b[512*3*128];
	unsigned char *s = gram;
	unsigned char *v0 = b;
	unsigned char *v1 = b + 512*3;
	for(int y = 0; y < 64; y++) {
		for(int x = 0; x < 256/8; x++) {
			unsigned char c = *s++;
			for(int b = 0; b < 8; b++) {
				if( c & 0x80 ) {
					*v0++ = 0xff;
					*v0++ = 0x80;
					*v0++ = 0x80;
					*v0++ = 0xff;
					*v0++ = 0x80;
					*v0++ = 0x80;
					*v1++ = 0xff;
					*v1++ = 0x80;
					*v1++ = 0x80;
					*v1++ = 0xff;
					*v1++ = 0x80;
					*v1++ = 0x80;
				} else {
					*v0++ = 0;
					*v0++ = 0;
					*v0++ = 0;
					*v0++ = 0;
					*v0++ = 0;
					*v0++ = 0;
					*v1++ = 0;
					*v1++ = 0;
					*v1++ = 0;
					*v1++ = 0;
					*v1++ = 0;
					*v1++ = 0;
				}
				c = c << 1;
			}
		}
		v0 += 512*3;
		v1 += 512*3;
	}
*/
	BITMAPINFO bmi;
	bmi.bmiHeader.biSize		= sizeof(BITMAPINFOHEADER);
	bmi.bmiHeader.biWidth		= 512;
	bmi.bmiHeader.biHeight		= -128;
	bmi.bmiHeader.biPlanes		= 1;
	bmi.bmiHeader.biBitCount	= 24;
	bmi.bmiHeader.biCompression	= BI_RGB;
	bmi.bmiHeader.biSizeImage	= 0;
	bmi.bmiHeader.biXPelsPerMeter = 0;
	bmi.bmiHeader.biYPelsPerMeter = 0;
	bmi.bmiHeader.biClrUsed		= 0;
	bmi.bmiHeader.biClrImportant= 0;

	HDC hDC2 = CreateCompatibleDC(hDC);
	HBITMAP hBmp = CreateCompatibleBitmap(hDC, rect.right, rect.bottom);
	SetDIBits(hDC2, hBmp, 0, 128, gram, &bmi, DIB_RGB_COLORS);
	HGDIOBJ hBmpSave = SelectObject(hDC2, hBmp);

	BitBlt(hDC, 0, 0, 512, 128, hDC2, 0, 0, SRCCOPY);

	SelectObject(hDC2, hBmpSave);
	DeleteObject(hBmp);
	DeleteDC(hDC2);
}

LRESULT ssd322::wndProcEnt(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	HANDLE h = ::GetProp(hWnd, L"OBJ");
	if( h != NULL ) {
		ssd322 *p = (ssd322*)h;
		return p->wndProc(hWnd, message, wParam, lParam);
	}
	return DefWindowProc(hWnd, message, wParam, lParam);
}

LRESULT ssd322::wndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	PAINTSTRUCT ps;
	HDC hdc;
	RECT rc;

	switch (message)
	{
	case WM_ERASEBKGND:
		GetClientRect(hWnd, &rc);
		FillRect((HDC)wParam, &rc, (HBRUSH)GetStockObject(BLACK_BRUSH));
		return 1;
	case WM_PAINT:
		hdc = BeginPaint(hWnd, &ps);
		doPaint(hdc);
		EndPaint(hWnd, &ps);
		break;
	case WM_LBUTTONDOWN:
		SetFocus(hWnd);
		return 0;
	case WM_SETFOCUS:
		return 0;
	case WM_KILLFOCUS:
		return 0;
	case WM_MOUSEWHEEL:
		return SendMessage(GetParent(hWnd), message, wParam, lParam);
	default:
		return DefWindowProc(hWnd, message, wParam, lParam);
	}
	return 0;
}
