/*
 * devPushButton.cpp
 *
 *  Created on: 2012/03/09
 *      Author: tanaka
 */

#include <stdlib.h>
#include <stdio.h>
#include <syslog.h>
#include <memory.h>
#include "bzmpd.h"
#include "devFirm.h"
#include "port.h"

DevFirm::DevFirm()
{
	bzmpdPtr	= NULL;
	displayPort	= NULL;
	onFirmReady	= NULL;
	onPowerDown	= NULL;

	for( int i = 0; i < 6; i++ ) volumes[i] = 0;
	muting = false;

	selectorPosition = 0;
	onSwitch	= NULL;

	freq	= 0;
	status	= 0;
	chMode	= 0;

}

DevFirm::~DevFirm()
{
}

bool DevFirm::process(Port *port)
{
	char header[8];
	char msg[256];
	size_t msgLen;
	size_t	rs;
	if( strcmp(port->getPortName(), "USB") == 0 ) {
		if( !port->recvData(8, msg, rs) ) {
			bzmpdPtr->log(LOG_ERR, "DevFirm:process packet recive error.");
			return false;
		}
		msg[2]	= 0;
		msgLen	= 2;
	} else {
		if( !port->recvData(1, header, rs) ) {
			bzmpdPtr->log(LOG_ERR, "DevFirm:process packet recive error.");
			return false;
		}
		if( rs != 1 ) {
			bzmpdPtr->log(LOG_ERR, "DevFirm:process packet recive error. frame header empty(1).");
			return false;
		}
		if( header[0] == '>' ) {
			if( onFirmReady ) {
				onFirmReady->onEvent(0, NULL);
			}
			return true;
		}
		if( header[0] != 'S' ) {
			bzmpdPtr->log(LOG_ERR, "DevFirm:process packet recive error. frame header not found. %c", header[0]);
			return false;
		}
		if( !port->recvData(1, header, rs) ) {
			bzmpdPtr->log(LOG_ERR, "DevFirm:process packet recive error.");
			return false;
		}
		if( header[0] != 0 ) {
			if( (size_t)(header[0]) > sizeof(msg) ) {
				bzmpdPtr->log(LOG_ERR, "DevFirm:process packet recive error. buffer size not enough");
				return false;
			}
		}
		msgLen = header[0];
		if( !port->recvData(msgLen, msg, rs) ) {
			bzmpdPtr->log(LOG_ERR, "DevFirm:process packet recive error. packet body cant't read.");
			return false;
		}
		if( rs != msgLen ) {
			bzmpdPtr->log(LOG_ERR, "DevFirm:process packet recive error. packet body size unmatch.");
			return false;
		}
		msg[msgLen] = 0;
		if( !port->recvData(1, header, rs) ) return false;
		if( rs != 1 ) {
			bzmpdPtr->log(LOG_ERR, "DevFirm:process packet recive error. frame terminator empty.");
			return false;
		}
		if( header[0] != 'E' ) {
			bzmpdPtr->log(LOG_ERR, "DevFirm:process packet recive error. frame terminator not found.");
			return false;
		}
		if( msgLen == 0 ) {
			return true;
		}
	}
	if( msg[0] == 'D' ) {
		if( onSwitch ) {
			onSwitch->onEvent(msgLen, msg);
		}
	} else if( msg[0] == 'U' ) {
		if( onSwitch ) {
			onSwitch->onEvent(msgLen, msg);
		}
	} else if( msg[0] == 'L' ) {
		if( onSwitch ) {
			onSwitch->onEvent(msgLen, msg);
		}
	} else if( msg[0] == 'R' ) {
		if( onSwitch ) {
			onSwitch->onEvent(msgLen, msg);
		}
	} else if( msg[0] == 'P' ) {
		if( onPowerDown ) {
			onPowerDown->onEvent(msgLen, msg);
		}
	} else if( msg[0] == '>' ) {
		if( onFirmReady ) {
			onFirmReady->onEvent(msgLen, msg);
		}
	} else {
		bzmpdPtr->log(LOG_DEBUG, "DevFirm:process unknown command. %c%c", msg[0], msg[1]);
	}

	return true;
}

bool DevFirm::setDisplayPort(Port *port)
{
	displayPort	= port;
	return true;
}

//////////////////////////////////////////////////////////////////
// Power control
bool DevFirm::setFirmReadyListener(EventListener *lp)
{
	onFirmReady	= lp;
	return true;
}
bool DevFirm::setPowerDownListener(EventListener *lp)
{
	onPowerDown	= lp;
	return true;
}

bool DevFirm::powerOn()
{
	if( !devicePort->sendData(3, "P1\n") )
		return false;
	return true;
}

bool DevFirm::powerOff()
{
	if( !devicePort->sendData(4, "P0\n") )
		return false;
	return true;
}

//////////////////////////////////////////////////////////////////
// OLED Display
bool DevFirm::setDisplayPower(bool sw)
{
	return true;
}

bool DevFirm::clearDisplay()
{
	Port *p;
	if( displayPort )
		p	= displayPort;
	else
		p	= devicePort;
	if( !p->sendPacket(1, "C") )
		return false;
	return true;
}

bool DevFirm::updateDisplay(int row, int col, const char *data)
{
	Port *p;
	if( displayPort )
		p	= displayPort;
	else
		p	= devicePort;

	char b[11];
	b[0] = 'P';	// Display Pixel
	b[1] = row;
	b[2] = col;
	memcpy(&b[3], data, 8);
	p->sendPacket(11,b);
	return true;
}

//////////////////////////////////////////////////////////////////
// Switch Panel
bool DevFirm::setSwitchListener(EventListener *lp)
{
	onSwitch	= lp;
	return true;
}

//////////////////////////////////////////////////////////////////
// source selector
bool DevFirm::setMediaSource(int ch)
{
	bzmpdPtr->log(LOG_INFO, "DevFirm::setMediaSource(%d) port=%s", ch, devicePort->getPortName());

	char b[2];
	b[0] = 'S';	// Display Pixel
	b[1] = ch;
	return devicePort->sendPacket(2,b);
}

bool DevFirm::getMediasource(int &ch)
{

}

//////////////////////////////////////////////////////////////////
// volume
bool DevFirm::setVolume(int *v)
{
	return true;
}

bool DevFirm::getVolume(int *v)
{
	return true;
}

bool DevFirm::setMute(int sw)
{
	return true;
}

bool DevFirm::getMute(int &sw)
{
	return true;
}

//////////////////////////////////////////////////////////////////
// FM Tunner Panel
bool DevFirm::setFreq(int freq)
{
	return true;
}

bool DevFirm::getFreq(int &freq)
{
	return true;
}

bool DevFirm::searchUpper(int stopLevel)
{
	return true;
}

bool DevFirm::searchLower(int stopLevel)
{
	return true;
}

bool DevFirm::getTuneStatus(TUNESTATUS &st)
{
	return true;
}

bool DevFirm::setChannelMode(int mode)
{
	return true;
}

bool DevFirm::getChannelMode(int &mode)
{
	return true;
}

