/*
 * devPanel.h
 *
 *  Created on: 2012/03/09
 *      Author: tanaka
 */

#ifndef DEVPANEL_H_
#define DEVPANEL_H_

#include "device.h"
class BZMPD;
class EventListener;
typedef struct _TUNESTATUS {
	int		freq;
	int		tunneLevel;
	bool	stereo;
	bool	limitScan;
} TUNESTATUS;

class DevFirm : public Device
{
public:
	DevFirm();
	virtual ~DevFirm();
	virtual const char *getName() { return "panel device"; }
	virtual bool process(Port *port);
	bool setDisplayPort(Port *port);

	// power control
	bool	setFirmReadyListener(EventListener *lp);
	bool	setPowerDownListener(EventListener *lp);
	bool	powerOn();
	bool	powerOff();

	// OLED Panel
	bool setDisplayPower(bool sw);
	bool clearDisplay();
	bool updateDisplay(int row, int col, const char *data);

	// switch panel
	bool	setSwitchListener(EventListener *lp);

	// volume
	bool	setVolume(int *v);
	bool	getVolume(int *v);
	bool	setMute(int sw);
	bool	getMute(int &sw);

	// source selector
	bool	setMediaSource(int ch);
	bool	getMediasource(int &ch);

	// tunner
	bool	setFreq(int freq);
	bool	getFreq(int &freq);
	bool	searchUpper(int stopLevel);
	bool	searchLower(int stopLevel);
	bool	getTuneStatus(TUNESTATUS &st);
	bool	setChannelMode(int mode);
	bool	getChannelMode(int &mode);

protected:
	int		pow[3];
	Port *	displayPort;

	EventListener *onFirmReady;
	EventListener *onPowerDown;

	int		volumes[6];
	bool	muting;

	int		selectorPosition;

	EventListener *onSwitch;

	int			freq;
	int			status;
	int			chMode;
};

#endif /* DEVPANEL_H_ */
