/*
 * devRemocon.cpp
 *
 *  Created on: 2012/03/12
 *      Author: tanaka
 */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <syslog.h>
#include "devRemocon.h"
#include "port.h"
#include "devMPD.h"
#include "controller.h"
#include "bzmpd.h"

DevRemocon::DevRemocon()
{
	bzmpdPtr	= NULL;
	bContinus	= false;
}

DevRemocon::~DevRemocon()
{

}

bool DevRemocon::process(Port *port)
{
	Controller *ctrl = bzmpdPtr->getController();

	char data[1024];
	size_t readed=0;
	if( !port->recvData(sizeof(data), data, readed) ) {
		return false;
	}
	if( readed == 0 ) {
		if( port->isDataEnd() ) {
			ctrl->removeConnection(port);
			delete port;
		}
		return true;
	}
	bzmpdPtr->log(LOG_INFO, ">recv %s", data);

	if( strncmp(data, "close",5) == 0 ) {
		port->close();
		ctrl->removeConnection(port);
		delete port;
		return true;
	}

	if( strcmp(data, "command_list_begin") == 0 ) {
		bContinus = true;
	}
	if( strcmp(data, "command_list_end") == 0 ) {
		bContinus = false;
	}

	if( data[0] != '@' ) {
		DevMPD *mpd = ctrl->getMPD();
		Port *mpdPort = mpd->getPort();
		char buff[1024];
		sprintf(buff, "%s\r\n", data);

		bzmpdPtr->log(LOG_INFO, "send> %s", buff);

		if( !mpdPort->sendData(strlen(buff), buff) ) {
			port->sendData(21, "ACK connection error\n");
			return true;
		}
		if( !bContinus ) {
			while( !mpdPort->isDataEnd() ) {
				if( !mpdPort->recvData(sizeof(data), data, readed) )
					break;
				if( readed == 0 )
					break;

				bzmpdPtr->log(LOG_INFO, "recv< %s", data);

				char buff[1024];
				sprintf(buff, "%s\r\n", data);

				bzmpdPtr->log(LOG_INFO, "<send %s", data);

				port->sendData(strlen(buff), buff);
				if( strncmp(data, "OK", 2) == 0 ) break;
				if( strncmp(data, "ACK", 3) == 0 ) break;
			}
		}
		return true;
	}

	if( data[0] == '@' ) {
		if( strcmp(&data[1], "v+") == 0 ) {
			if( !ctrl->cmdVolumePlus() ) {
				port->sendData(3, "ACK");
			} else {
				port->sendData(2, "OK");
			}
			return true;
		} else if( strcmp(&data[1], "v-") == 0 ) {
			if( !ctrl->cmdVolumeMinus() ) {
				port->sendData(3, "ACK");
			} else {
				port->sendData(2, "OK");
			}
			return true;
		}
		port->sendData(18, "ACK command error\n");
		return true;
	}
	return false;
}


bool DevRemocon::connect(Port *port)
{
	if( !port->setReceiveDevice(this) ) {
		return false;
	}
	Controller *ctrl = bzmpdPtr->getController();
	DevMPD *mpd = ctrl->getMPD();
	return mpd->connect(port);
	/*
	char res[256];
	sprintf(res, "OK MPD %s\n", mpd_version);
	return port->sendData(strlen(res), res);
	*/
}


