/*
 * device.h
 *
 *  Created on: 2012/03/10
 *      Author: tanaka
 */

#ifndef DEVICE_H_
#define DEVICE_H_

class BZMPD;
class Device;
class Port;

enum DeviceAddr {
	DEV_DISPLAY = 1,
	DEV_VOLUME,
	DEV_SELECTOR,
	DEV_ROTARYSW,
	DEV_PUSHBUTTON1,
	DEV_PUSHBUTTON2,
	DEV_PUSHBUTTON3,
	DEV_PUSHBUTTON4,
	DEV_PUSHBUTTON5,
	DEV_PUSHBUTTON6,
	DEV_PUSHBUTTON7,
	DEV_POWER,
	DEV_FMTUNNER,
};

class Device
{
public:
	Device();
	virtual ~Device();
	virtual const char *getName() = 0;
	virtual bool initalize(BZMPD *bzmpd) { bzmpdPtr = bzmpd; return true; }
	virtual bool setDevicePort(Port *port);
	virtual bool process(Port *port);
	virtual bool connect(Port *port);

protected:
	BZMPD *bzmpdPtr;
	Port *devicePort;
};

#endif /* DEVICE_H_ */
