/*
 * gadListbox.cpp
 *
 *  Created on: 2012/03/22
 *      Author: tanaka
 */

#include <syslog.h>
#include <stdlib.h>
#include <malloc.h>

#include "../../ssg/include/ssg.h"
#include "gadListbox.h"

ListBox::ListBox()
{
	data		= NULL;
	curTop		= 0;
	curItem		= 0;
	font		= NULL;
	bmp			= NULL;
}

ListBox::~ListBox()
{
	if( bmp ) delete bmp;
}

void ListBox::onDraw(ssg::Painter *p)
{
	bzmpdPtr->log(LOG_INFO, "ListBox::onDraw w=%d", width);
	if( bmp == NULL ) {
		bmp = ssg::Bitmap::create(width, height, p->getBitmap()->getPixformat());
	}
	ssg::Painter *pp = new ssg::Painter();
	pp->setBitmap(bmp);
	pp->clear();
	pp->setColor(0xff);
	ssg::Point pt;
	pt.x = font->getAscent();
	pt.y = font->getAscent() + font->getDescent();
	for( int n = curTop; n < data->nItems; n++ ) {
		if( pt.y-font->getAscent() > height) break;
		pp->textA(font, &pt, data->pItems[n].text);
		pt.y += lineHeight;
	}
	if( curTop <= curItem && curItem < curTop + nLines ) {
		pt.x = 0;
		pt.y = (curItem - curTop) * lineHeight + font->getAscent() + font->getDescent();
		pp->textA(font, &pt, ">");
	}
	ssg::Point pos;
	pos.x	= x;
	pos.y	= y;
	p->image(bmp, &pos);
	delete pp;
}

void ListBox::onEvent(EventCode ec, int d)
{
	int orgTop = curTop;
	int orgItem = curItem;
	if( ec == EC_ROTATE ) {
		bzmpdPtr->log(LOG_INFO, "ListBox::onEvent ec=%d d=%d", ec, d);
		if( d == -1 ) {
			if( 0 < curItem ) {
				curItem--;
				if( curItem < curTop ) curTop = curItem;
			}
		} else if( d == 1) {
			if( curItem+1 < data->nItems ) {
				curItem++;
				if( curTop+nLines <= curItem ) curTop = curItem - nLines + 1;
			}
		}
	} else if( ec == EC_KEY ) {
		bzmpdPtr->log(LOG_INFO, "ListBox::onEvent ec=%d d=%d curItem=%d maxItem=%d", ec, d, curItem, data->nItems);
		if( d == 1 ) {
			if( 0 < curItem ) {
				curItem--;
				if( curItem < curTop ) curTop = curItem;
			}
		} else if( d == 2) {
			if( curItem+1 < data->nItems ) {
				curItem++;
				if( curTop+nLines <= curItem ) curTop = curItem - nLines + 1;
			}
		}
	}
	if( curTop != orgTop || curItem != orgItem ) {
		bzmpdPtr->log(LOG_INFO, "ListBox::onEvent update ec=%d d=%d curItem=%d maxItem=%d", ec, d, curItem, data->nItems);
		if( screen ) screen->invalidate();
	}
}

bool ListBox::setList(LISTDATA *data, ssg::Font *font)
{
	if( font == NULL ) {
		if( data ) {
			bzmpdPtr->log(LOG_ERR, "ListBox::setList font error");
			return false;
		}
	}
	this->data	= data;
	this->font	= font;
	curItem	= 0;
	curTop	= 0;
	lineHeight	= font->getAscent() + font->getDescent();
	nLines	= height / lineHeight;
	if( screen ) screen->invalidate();

	bzmpdPtr->log(LOG_INFO, "ListBox::setList lineHeight=%d nLines=%d", lineHeight, nLines);

	return true;
}

bool ListBox::selectListItem(int id)
{
	if( 0 <= id && id < data->nItems ) {
		curItem = id;
		if( curItem < curTop ) curTop = curItem;
		if( curTop + nLines <= curItem ) curTop = curItem - nLines + 1;
		return true;
	}
	return false;
}

int	ListBox::getSelectItem()
{
	if( 0 <= curItem && curItem < data->nItems ) {
		return data->pItems[curItem].id;
	}
	return -1;
}


