/*
 * gadMessageBox.cpp
 *
 *  Created on: 2012/03/23
 *      Author: tanaka
 */
#include "../../ssg/include/ssg.h"
#include "gadMessageBox.h"
#include <stdlib.h>
#include <malloc.h>

struct _BUTTONINF {
	ssg::Rect	rect;
	int			textOffset;
	MessageBoxFlag flag;
};

MessageBox::MessageBox()
{
	title		= NULL;
	text		= NULL;
	nTimeoutTime= 0;
	font		= NULL;
	bmp			= NULL;
	flag		= MBF_NULL;
	sel			= MBF_NULL;
	nButtons	= 0;
	iButtons	= NULL;
}

MessageBox::~MessageBox()
{
	if( bmp ) delete bmp;
	if( this->title ) free((void*)this->title);
	if( this->text ) free((void*)this->text);
	if( iButtons ) free((void*)iButtons);
}

void MessageBox::onEvent(EventCode ec, int data)
{
	if( ec == EC_TIMER ) {
		if( nTimeoutTime ) {
			struct timespec ts;
			clock_gettime(CLOCK_REALTIME, &ts);
			if( nTimeoutTime <= ts.tv_sec ) {
				sel	= MBF_CANCEL;
			}
		}
	}
	if( ec == EC_ROTATE ) {
		if( data < 0 ) {
			if( 0 < cButton ) {
				cButton--;
				if(screen) screen->invalidate();
			}
		} else if( data > 0 ) {
			if( cButton+1 < nButtons ) {
				cButton++;
				if(screen) screen->invalidate();
			}
		}
	}
	if( ec == EC_KEY ) {
		if( data == KC_ENTER ) {
			sel	= iButtons[cButton].flag;
		} else if( data == KC_ESC ) {
			sel	= MBF_CANCEL;
		}
	}
}

void MessageBox::onDraw(ssg::Painter *p)
{
	if( bmp == NULL ) {
		bmp = ssg::Bitmap::create(width, height, p->getBitmap()->getPixformat());
	}
	x = (p->getBitmap()->getWidth() - width) / 2;
	y = (p->getBitmap()->getHeight() - height) / 2;
	ssg::Painter *pp = new ssg::Painter();
	pp->setBitmap(bmp);
	pp->clear();
	pp->setColor(0xff);
	ssg::Point pt;

	pt.x = (width - titleSize.x) / 2;
	pt.y = font->getAscent() + font->getDescent();
	pp->textA(font, &pt, title);

	pt.x	= (width - textSize.x) / 2;
	pt.y	+= font->getAscent() * 2 + font->getDescent();
	pp->textA(font, &pt, text);

	for( int i = 0; i < nButtons; i++ ) {
		const char *pText = NULL;
		switch(iButtons[i].flag) {
		case MBF_OK:		pText = "OK";		break;
		case MBF_CANCEL:	pText = "CANCEL";	break;
		case MBF_YES:		pText = "YES";		break;
		case MBF_NO:		pText = "NO";		break;
		}
		pt.x = iButtons[i].rect.x + iButtons[i].textOffset;
		pt.y = iButtons[i].rect.y + font->getAscent() + font->getDescent();
		pp->textA(font, &pt, pText);
		pp->frameRect(&iButtons[i].rect);
	}

	p->image(bmp, &pt);
	drawFrame(p);
	delete pp;
}

bool MessageBox::set(const char *title, const char *text, MessageBoxFlag flag, MessageBoxFlag def, int timeoutsec, ssg::Font *font)
{
	if( this->title ) free((void*)this->title);
	if( this->text ) free((void*)this->text);
	this->title	= strdup(title);
	this->text = strdup(text);
	this->flag	= flag;
	this->font	= font;
	if(this->screen) this->screen->invalidate();

	ssg::Painter *p = new ssg::Painter();
	p->textArea(textSize, font, text);
	p->textArea(titleSize, font, title);
	width = textSize.x + font->getAscent() * 2;
	int ts = titleSize.x + font->getAscent() * 2;
	if( width < ts ) width = ts;
	height = textSize.y * 3 + font->getAscent() * 4;

	cButton	= 0;
	nButtons = 0;
	if( iButtons ) free((void*)iButtons);
	iButtons	= NULL;
	if( flag & MBF_OK ) {
		if( def == MBF_OK ) cButton = nButtons;
		nButtons++;
	}
	if( flag & MBF_CANCEL ) {
		if( def == MBF_CANCEL ) cButton = nButtons;
		nButtons++;
	}
	if( flag & MBF_YES ) {
		if( def == MBF_YES ) cButton = nButtons;
		nButtons++;
	}
	if( flag & MBF_NO ) {
		if( def == MBF_NO ) cButton = nButtons;
		nButtons++;
	}
	if( nButtons ) {
		iButtons	= (BUTTONINF*)malloc(sizeof(BUTTONINF)*nButtons);
		int n = 0;
		int bw = 0;
		if( flag & MBF_OK ) {
			ssg::Point bs;
			p->textArea(bs, font, "OK");
			iButtons[n].rect.width	= bs.x + font->getDescent() * 2;
			iButtons[n].rect.height	= bs.y;
			iButtons[n].textOffset	= (iButtons[n].rect.width - bs.x)/2;
			iButtons[n].flag	= MBF_OK;
			bw	+= iButtons[n].rect.width;
			n++;
		}
		if( flag & MBF_CANCEL ) {
			ssg::Point bs;
			p->textArea(bs, font, "CANCEL");
			iButtons[n].rect.width	= bs.x + font->getDescent() * 2;
			iButtons[n].rect.height	= bs.y;
			iButtons[n].textOffset	= (iButtons[n].rect.width - bs.x)/2;
			iButtons[n].flag	= MBF_CANCEL;
			bw	+= iButtons[n].rect.width;
			n++;
		}
		if( flag & MBF_YES ) {
			ssg::Point bs;
			p->textArea(bs, font, "YES");
			iButtons[n].rect.width	= bs.x + font->getDescent() * 2;
			iButtons[n].rect.height	= bs.y;
			iButtons[n].textOffset	= (iButtons[n].rect.width - bs.x)/2;
			iButtons[n].flag	= MBF_YES;
			bw	+= iButtons[n].rect.width;
			n++;
		}
		if( flag & MBF_NO ) {
			ssg::Point bs;
			p->textArea(bs, font, "NO");
			iButtons[n].rect.width	= bs.x + font->getDescent() * 2;
			iButtons[n].rect.height	= bs.y;
			iButtons[n].textOffset	= (iButtons[n].rect.width - bs.x)/2;
			iButtons[n].flag	= MBF_NO;
			bw	+= iButtons[n].rect.width;
			n++;
		}
		int baw = bw + (nButtons-1) * font->getAscent();
		if( width < baw ) {
			width = baw;
		}
		int bax = (width - baw)/2;
		for( int i = 0; i < nButtons; i++ ) {
			iButtons[i].rect.x	= bax;
			iButtons[i].rect.y	= textSize.y * 2 + font->getAscent() * 3;
			baw += iButtons[i].rect.width + font->getAscent();
		}
	}
	/*
	if( flag & MBF_ICON_INFO ) {
		ssg::Point bs;
		p->textArea(bs, font, "OK");
		bw += bs.x;
		bn++;
	}
	if( flag & MBF_ICON_ERR ) {
		ssg::Point bs;
		p->textArea(bs, font, "OK");
		bw = bs.x;
		bn++;
	}
	if( flag & MBF_ICON_QUESTION ) {
		ssg::Point bs;
		p->textArea(bs, font, "OK");
		bw = bs.x;
		bn++;
	}
	if( flag & MBF_ICON_CAUTION ) {
		ssg::Point bs;
		p->textArea(bs, font, "OK");
		bw = bs.x;
		bn++;
	}
	*/

	if( timeoutsec ) {
		struct timespec ts;
		clock_gettime(CLOCK_REALTIME, &ts);
		nTimeoutTime	= ts.tv_sec + timeoutsec;
	} else {
		nTimeoutTime	= 0;
	}
	delete p;
	return true;
}


