/*
 * gadMessageBox.h
 *
 *  Created on: 2012/03/23
 *      Author: tanaka
 */

#ifndef GADMESSAGEBOX_H_
#define GADMESSAGEBOX_H_

#include <time.h>
#include "gadget.h"
#include "screen.h"
#include "../../ssg/include/ssg.h"
namespace ssg {
	class Bitmap;
	class Font;
	class Painter;
}

typedef struct _BUTTONINF BUTTONINF;

class MessageBox : public Gadget
{
public:
	MessageBox();
	~MessageBox();
	virtual void onDraw(ssg::Painter *p);
	virtual void onEvent(EventCode ec, int data);

	bool set(const char *title, const char *text, MessageBoxFlag flag, MessageBoxFlag def, int timeoutsec, ssg::Font *font);
	MessageBoxFlag getSelect() { return sel; }

protected:
	const char *title;
	const char *text;
	time_t nTimeoutTime;
	MessageBoxFlag flag;
	MessageBoxFlag sel;
	int cButton;
	int	nButtons;
	BUTTONINF	*iButtons;
	ssg::Font *font;
	ssg::Bitmap *bmp;
	ssg::Point titleSize;
	ssg::Point textSize;
};


#endif /* GADMESSAGEBOX_H_ */
